/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.ResolvedMethodName;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyAccess;

final class MemberName
implements Member,
Cloneable {
    private Class<?> clazz;
    private String name;
    private Object type;
    private int flags;
    private ResolvedMethodName method;
    private Object resolution;
    private static final int MH_INVOKE_MODS = 273;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    static final String CONSTRUCTOR_NAME = "<init>";
    static final int RECOGNIZED_MODIFIERS = 65535;
    static final int IS_METHOD = 65536;
    static final int IS_CONSTRUCTOR = 131072;
    static final int IS_FIELD = 262144;
    static final int IS_TYPE = 524288;
    static final int CALLER_SENSITIVE = 0x100000;
    static final int ALL_ACCESS = 7;
    static final int ALL_KINDS = 983040;
    static final int IS_INVOCABLE = 196608;
    static final int IS_FIELD_OR_METHOD = 327680;
    static final int SEARCH_ALL_SUPERS = 0x300000;

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.expandFromVM();
            if (this.name == null) {
                return null;
            }
        }
        return this.name;
    }

    public MethodType getMethodOrFieldType() {
        if (this.isInvocable()) {
            return this.getMethodType();
        }
        if (this.isGetter()) {
            return MethodType.methodType(this.getFieldType());
        }
        if (this.isSetter()) {
            return MethodType.methodType(Void.TYPE, this.getFieldType());
        }
        throw new InternalError("not a method or field: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodType getMethodType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (!this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not invocable, no method type");
        }
        Object type = this.type;
        if (type instanceof MethodType) {
            return (MethodType)type;
        }
        MemberName memberName = this;
        synchronized (memberName) {
            if (this.type instanceof String) {
                String sig = (String)this.type;
                MethodType res = MethodType.fromMethodDescriptorString(sig, this.getClassLoader());
                this.type = res;
            } else if (this.type instanceof Object[]) {
                Object[] typeInfo = (Object[])this.type;
                Class[] ptypes = (Class[])typeInfo[1];
                Class rtype = (Class)typeInfo[0];
                MethodType res = MethodType.methodType(rtype, ptypes);
                this.type = res;
            }
            assert (this.type instanceof MethodType) : "bad method type " + this.type;
        }
        return (MethodType)this.type;
    }

    public MethodType getInvocationType() {
        MethodType itype = this.getMethodOrFieldType();
        if (this.isConstructor() && this.getReferenceKind() == 8) {
            return itype.changeReturnType(this.clazz);
        }
        if (!this.isStatic()) {
            return itype.insertParameterTypes(0, this.clazz);
        }
        return itype;
    }

    public Class<?>[] getParameterTypes() {
        return this.getMethodType().parameterArray();
    }

    public Class<?> getReturnType() {
        return this.getMethodType().returnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getFieldType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not a field or nested class, no simple type");
        }
        Object type = this.type;
        if (type instanceof Class) {
            return (Class)type;
        }
        MemberName memberName = this;
        synchronized (memberName) {
            if (this.type instanceof String) {
                Class<?> res;
                String sig = (String)this.type;
                MethodType mtype = MethodType.fromMethodDescriptorString("()" + sig, this.getClassLoader());
                this.type = res = mtype.returnType();
            }
            assert (this.type instanceof Class) : "bad field type " + this.type;
        }
        return (Class)this.type;
    }

    public Object getType() {
        return this.isInvocable() ? this.getMethodType() : this.getFieldType();
    }

    public String getSignature() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.isInvocable()) {
            return BytecodeDescriptor.unparse(this.getMethodType());
        }
        return BytecodeDescriptor.unparse(this.getFieldType());
    }

    @Override
    public int getModifiers() {
        return this.flags & 0xFFFF;
    }

    public byte getReferenceKind() {
        return (byte)(this.flags >>> 24 & 0xF);
    }

    private boolean referenceKindIsConsistent() {
        byte refKind = this.getReferenceKind();
        if (refKind == 0) {
            return this.isType();
        }
        if (this.isField()) {
            assert (this.staticIsConsistent());
            assert (MethodHandleNatives.refKindIsField(refKind));
        } else if (this.isConstructor()) {
            assert (refKind == 8 || refKind == 7);
        } else if (this.isMethod()) {
            assert (this.staticIsConsistent());
            assert (MethodHandleNatives.refKindIsMethod(refKind));
            if (this.clazz.isInterface()) assert (refKind == 9 || refKind == 6 || refKind == 7 || refKind == 5 && this.isObjectPublicMethod());
        } else assert (false);
        return true;
    }

    private boolean isObjectPublicMethod() {
        if (this.clazz == Object.class) {
            return true;
        }
        MethodType mtype = this.getMethodType();
        if (this.name.equals("toString") && mtype.returnType() == String.class && mtype.parameterCount() == 0) {
            return true;
        }
        if (this.name.equals("hashCode") && mtype.returnType() == Integer.TYPE && mtype.parameterCount() == 0) {
            return true;
        }
        return this.name.equals("equals") && mtype.returnType() == Boolean.TYPE && mtype.parameterCount() == 1 && mtype.parameterType(0) == Object.class;
    }

    boolean referenceKindIsConsistentWith(int originalRefKind) {
        byte refKind = this.getReferenceKind();
        if (refKind == originalRefKind) {
            return true;
        }
        switch (originalRefKind) {
            case 9: {
                assert (refKind == 5 || refKind == 7) : this;
                return true;
            }
            case 5: 
            case 8: {
                assert (refKind == 7) : this;
                return true;
            }
        }
        assert (false) : this + " != " + MethodHandleNatives.refKindName((byte)originalRefKind);
        return true;
    }

    private boolean staticIsConsistent() {
        byte refKind = this.getReferenceKind();
        return MethodHandleNatives.refKindIsStatic(refKind) == this.isStatic() || this.getModifiers() == 0;
    }

    private boolean vminfoIsConsistent() {
        byte refKind = this.getReferenceKind();
        assert (this.isResolved());
        Object vminfo = MethodHandleNatives.getMemberVMInfo(this);
        assert (vminfo instanceof Object[]);
        long vmindex = (Long)((Object[])vminfo)[0];
        Object vmtarget = ((Object[])vminfo)[1];
        if (MethodHandleNatives.refKindIsField(refKind)) {
            assert (vmindex >= 0L) : vmindex + ":" + this;
            assert (vmtarget instanceof Class);
        } else {
            if (MethodHandleNatives.refKindDoesDispatch(refKind)) {
                assert (vmindex >= 0L) : vmindex + ":" + this;
            } else assert (vmindex < 0L) : vmindex;
            assert (vmtarget instanceof MemberName) : vmtarget + " in " + this;
        }
        return true;
    }

    private MemberName changeReferenceKind(byte refKind, byte oldKind) {
        assert (this.getReferenceKind() == oldKind);
        assert (MethodHandleNatives.refKindIsValid(refKind));
        this.flags += refKind - oldKind << 24;
        return this;
    }

    private boolean testFlags(int mask, int value) {
        return (this.flags & mask) == value;
    }

    private boolean testAllFlags(int mask) {
        return this.testFlags(mask, mask);
    }

    private boolean testAnyFlags(int mask) {
        return !this.testFlags(mask, 0);
    }

    public boolean isMethodHandleInvoke() {
        int bits = 272;
        int negs = 8;
        if (this.testFlags(280, 272) && this.clazz == MethodHandle.class) {
            return MemberName.isMethodHandleInvokeName(this.name);
        }
        return false;
    }

    public static boolean isMethodHandleInvokeName(String name) {
        switch (name) {
            case "invoke": 
            case "invokeExact": {
                return true;
            }
        }
        return false;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.flags);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.flags);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public boolean canBeStaticallyBound() {
        return Modifier.isFinal(this.flags | this.clazz.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.flags);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.flags);
    }

    public boolean isNative() {
        return Modifier.isNative(this.flags);
    }

    public boolean isBridge() {
        return this.testAllFlags(65600);
    }

    public boolean isVarargs() {
        return this.testAllFlags(128) && this.isInvocable();
    }

    @Override
    public boolean isSynthetic() {
        return this.testAllFlags(4096);
    }

    public boolean isInvocable() {
        return this.testAnyFlags(196608);
    }

    public boolean isFieldOrMethod() {
        return this.testAnyFlags(327680);
    }

    public boolean isMethod() {
        return this.testAllFlags(65536);
    }

    public boolean isConstructor() {
        return this.testAllFlags(131072);
    }

    public boolean isField() {
        return this.testAllFlags(262144);
    }

    public boolean isType() {
        return this.testAllFlags(524288);
    }

    public boolean isPackage() {
        return !this.testAnyFlags(7);
    }

    public boolean isCallerSensitive() {
        return this.testAllFlags(0x100000);
    }

    public boolean isAccessibleFrom(Class<?> lookupClass) {
        return VerifyAccess.isMemberAccessible(this.getDeclaringClass(), this.getDeclaringClass(), this.flags, lookupClass, 15);
    }

    private void init(Class<?> defClass, String name, Object type, int flags) {
        this.clazz = defClass;
        this.name = name;
        this.type = type;
        this.flags = flags;
        assert (this.testAnyFlags(983040));
        assert (this.resolution == null);
    }

    private void expandFromVM() {
        if (this.type != null) {
            return;
        }
        if (!this.isResolved()) {
            return;
        }
        MethodHandleNatives.expand(this);
    }

    private static int flagsMods(int flags, int mods, byte refKind) {
        assert ((flags & 0xFFFF) == 0);
        assert ((mods & 0xFFFF0000) == 0);
        assert ((refKind & 0xFFFFFFF0) == 0);
        return flags | mods | refKind << 24;
    }

    public MemberName(Method m) {
        this(m, false);
    }

    public MemberName(Method m, boolean wantSpecial) {
        m.getClass();
        MethodHandleNatives.init(this, m);
        if (this.clazz == null) {
            if (m.getDeclaringClass() == MethodHandle.class && MemberName.isMethodHandleInvokeName(m.getName())) {
                MethodType type = MethodType.methodType(m.getReturnType(), m.getParameterTypes());
                int flags = MemberName.flagsMods(65536, m.getModifiers(), (byte)5);
                this.init(MethodHandle.class, m.getName(), type, flags);
                if (this.isMethodHandleInvoke()) {
                    return;
                }
            }
            throw new LinkageError(m.toString());
        }
        assert (this.isResolved() && this.clazz != null);
        this.name = m.getName();
        if (this.type == null) {
            this.type = new Object[]{m.getReturnType(), m.getParameterTypes()};
        }
        if (wantSpecial) {
            if (this.isAbstract()) {
                throw new AbstractMethodError(this.toString());
            }
            if (this.getReferenceKind() == 5) {
                this.changeReferenceKind((byte)7, (byte)5);
            } else if (this.getReferenceKind() == 9) {
                this.changeReferenceKind((byte)7, (byte)9);
            }
        }
    }

    public MemberName asSpecial() {
        switch (this.getReferenceKind()) {
            case 7: {
                return this;
            }
            case 5: {
                return this.clone().changeReferenceKind((byte)7, (byte)5);
            }
            case 9: {
                return this.clone().changeReferenceKind((byte)7, (byte)9);
            }
            case 8: {
                return this.clone().changeReferenceKind((byte)7, (byte)8);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public MemberName asConstructor() {
        switch (this.getReferenceKind()) {
            case 7: {
                return this.clone().changeReferenceKind((byte)8, (byte)7);
            }
            case 8: {
                return this;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public MemberName asNormalOriginal() {
        byte refKind;
        byte normalVirtual = this.clazz.isInterface() ? (byte)9 : 5;
        byte newRefKind = refKind = this.getReferenceKind();
        MemberName result = this;
        switch (refKind) {
            case 5: 
            case 7: 
            case 9: {
                newRefKind = normalVirtual;
            }
        }
        if (newRefKind == refKind) {
            return this;
        }
        result = this.clone().changeReferenceKind(newRefKind, refKind);
        assert (this.referenceKindIsConsistentWith(result.getReferenceKind()));
        return result;
    }

    public MemberName(Constructor<?> ctor) {
        ctor.getClass();
        MethodHandleNatives.init(this, ctor);
        assert (this.isResolved() && this.clazz != null);
        this.name = CONSTRUCTOR_NAME;
        if (this.type == null) {
            this.type = new Object[]{Void.TYPE, ctor.getParameterTypes()};
        }
    }

    public MemberName(Field fld) {
        this(fld, false);
    }

    public MemberName(Field fld, boolean makeSetter) {
        fld.getClass();
        MethodHandleNatives.init(this, fld);
        assert (this.isResolved() && this.clazz != null);
        this.name = fld.getName();
        this.type = fld.getType();
        byte refKind = this.getReferenceKind();
        assert (refKind == (this.isStatic() ? (byte)2 : 1));
        if (makeSetter) {
            this.changeReferenceKind((byte)(refKind + 2), refKind);
        }
    }

    public boolean isGetter() {
        return MethodHandleNatives.refKindIsGetter(this.getReferenceKind());
    }

    public boolean isSetter() {
        return MethodHandleNatives.refKindIsSetter(this.getReferenceKind());
    }

    public MemberName asSetter() {
        byte refKind = this.getReferenceKind();
        assert (MethodHandleNatives.refKindIsGetter(refKind));
        byte setterRefKind = (byte)(refKind + 2);
        return this.clone().changeReferenceKind(setterRefKind, refKind);
    }

    public MemberName(Class<?> type) {
        this.init(type.getDeclaringClass(), type.getSimpleName(), type, MemberName.flagsMods(524288, type.getModifiers(), (byte)0));
        this.initResolved(true);
    }

    static MemberName makeMethodHandleInvoke(String name, MethodType type) {
        return MemberName.makeMethodHandleInvoke(name, type, 4369);
    }

    static MemberName makeMethodHandleInvoke(String name, MethodType type, int mods) {
        MemberName mem = new MemberName(MethodHandle.class, name, type, 5);
        mem.flags |= mods;
        assert (mem.isMethodHandleInvoke()) : mem;
        return mem;
    }

    MemberName() {
    }

    protected MemberName clone() {
        try {
            return (MemberName)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    public MemberName getDefinition() {
        if (!this.isResolved()) {
            throw new IllegalStateException("must be resolved: " + this);
        }
        if (this.isType()) {
            return this;
        }
        MemberName res = this.clone();
        res.clazz = null;
        res.type = null;
        res.name = null;
        res.resolution = res;
        res.expandFromVM();
        assert (res.getName().equals(this.getName()));
        return res;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.getReferenceKind(), this.name, this.getType());
    }

    public boolean equals(Object that) {
        return that instanceof MemberName && this.equals((MemberName)that);
    }

    public boolean equals(MemberName that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        return this.clazz == that.clazz && this.getReferenceKind() == that.getReferenceKind() && Objects.equals(this.name, that.name) && Objects.equals(this.getType(), that.getType());
    }

    public MemberName(Class<?> defClass, String name, Class<?> type, byte refKind) {
        this.init(defClass, name, type, MemberName.flagsMods(262144, 0, refKind));
        this.initResolved(false);
    }

    public MemberName(Class<?> defClass, String name, MethodType type, byte refKind) {
        int initFlags = name != null && name.equals(CONSTRUCTOR_NAME) ? 131072 : 65536;
        this.init(defClass, name, type, MemberName.flagsMods(initFlags, 0, refKind));
        this.initResolved(false);
    }

    public MemberName(byte refKind, Class<?> defClass, String name, Object type) {
        int kindFlags;
        if (MethodHandleNatives.refKindIsField(refKind)) {
            kindFlags = 262144;
            if (!(type instanceof Class)) {
                throw MethodHandleStatics.newIllegalArgumentException("not a field type");
            }
        } else if (MethodHandleNatives.refKindIsMethod(refKind)) {
            kindFlags = 65536;
            if (!(type instanceof MethodType)) {
                throw MethodHandleStatics.newIllegalArgumentException("not a method type");
            }
        } else if (refKind == 8) {
            kindFlags = 131072;
            if (!(type instanceof MethodType) || !CONSTRUCTOR_NAME.equals(name)) {
                throw MethodHandleStatics.newIllegalArgumentException("not a constructor type or name");
            }
        } else {
            throw MethodHandleStatics.newIllegalArgumentException("bad reference kind " + refKind);
        }
        this.init(defClass, name, type, MemberName.flagsMods(kindFlags, 0, refKind));
        this.initResolved(false);
    }

    public boolean hasReceiverTypeDispatch() {
        return MethodHandleNatives.refKindDoesDispatch(this.getReferenceKind());
    }

    public boolean isResolved() {
        return this.resolution == null;
    }

    private void initResolved(boolean isResolved) {
        assert (this.resolution == null);
        if (!isResolved) {
            this.resolution = this;
        }
        assert (this.isResolved() == isResolved);
    }

    void checkForTypeAlias(Class<?> refc) {
        Class<?> type;
        if (this.isInvocable()) {
            MethodType type2;
            if (this.type instanceof MethodType) {
                type2 = (MethodType)this.type;
            } else {
                type2 = this.getMethodType();
                this.type = type2;
            }
            if (type2.erase() == type2) {
                return;
            }
            if (VerifyAccess.isTypeVisible(type2, refc)) {
                return;
            }
            throw new LinkageError("bad method type alias: " + type2 + " not visible from " + refc);
        }
        if (this.type instanceof Class) {
            type = (Class<?>)this.type;
        } else {
            this.type = type = this.getFieldType();
        }
        if (VerifyAccess.isTypeVisible(type, refc)) {
            return;
        }
        throw new LinkageError("bad field type alias: " + type + " not visible from " + refc);
    }

    public String toString() {
        String name;
        if (this.isType()) {
            return this.type.toString();
        }
        StringBuilder buf = new StringBuilder();
        if (this.getDeclaringClass() != null) {
            buf.append(MemberName.getName(this.clazz));
            buf.append('.');
        }
        buf.append((name = this.getName()) == null ? "*" : name);
        Object type = this.getType();
        if (!this.isInvocable()) {
            buf.append('/');
            buf.append(type == null ? "*" : MemberName.getName(type));
        } else {
            buf.append(type == null ? "(*)*" : MemberName.getName(type));
        }
        byte refKind = this.getReferenceKind();
        if (refKind != 0) {
            buf.append('/');
            buf.append(MethodHandleNatives.refKindName(refKind));
        }
        return buf.toString();
    }

    private static String getName(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        return String.valueOf(obj);
    }

    public IllegalAccessException makeAccessException(String message, Object from) {
        message = message + ": " + this.toString();
        if (from != null) {
            message = message + ", from " + from;
        }
        return new IllegalAccessException(message);
    }

    private String message() {
        if (this.isResolved()) {
            return "no access";
        }
        if (this.isConstructor()) {
            return "no such constructor";
        }
        if (this.isMethod()) {
            return "no such method";
        }
        return "no such field";
    }

    public ReflectiveOperationException makeAccessException() {
        String message = this.message() + ": " + this.toString();
        ReflectiveOperationException ex = this.isResolved() || !(this.resolution instanceof NoSuchMethodError) && !(this.resolution instanceof NoSuchFieldError) ? new IllegalAccessException(message) : (this.isConstructor() ? new NoSuchMethodException(message) : (this.isMethod() ? new NoSuchMethodException(message) : new NoSuchFieldException(message)));
        if (this.resolution instanceof Throwable) {
            ex.initCause((Throwable)this.resolution);
        }
        return ex;
    }

    static Factory getFactory() {
        return Factory.INSTANCE;
    }

    static class Factory {
        static Factory INSTANCE = new Factory();
        private static int ALLOWED_FLAGS = 983040;

        private Factory() {
        }

        List<MemberName> getMembers(Class<?> defc, String matchName, Object matchType, int matchFlags, Class<?> lookupClass) {
            matchFlags &= ALLOWED_FLAGS;
            String matchSig = null;
            if (matchType != null) {
                matchSig = BytecodeDescriptor.unparse(matchType);
                matchFlags = matchSig.startsWith("(") ? (matchFlags &= 0xFFF3FFFF) : (matchFlags &= 0xFFF4FFFF);
            }
            int BUF_MAX = 8192;
            int len1 = matchName == null ? 10 : (matchType == null ? 4 : 1);
            MemberName[] buf = Factory.newMemberBuffer(len1);
            int totalCount = 0;
            ArrayList<MemberName[]> bufs = null;
            int bufCount = 0;
            while (true) {
                if ((bufCount = MethodHandleNatives.getMembers(defc, matchName, matchSig, matchFlags, lookupClass, totalCount, buf)) <= buf.length) {
                    if (bufCount < 0) {
                        bufCount = 0;
                    }
                    break;
                }
                totalCount += buf.length;
                int excess = bufCount - buf.length;
                if (bufs == null) {
                    bufs = new ArrayList<MemberName[]>(1);
                }
                bufs.add(buf);
                int len2 = buf.length;
                len2 = Math.max(len2, excess);
                len2 = Math.max(len2, totalCount / 4);
                buf = Factory.newMemberBuffer(Math.min(8192, len2));
            }
            ArrayList<MemberName> result = new ArrayList<MemberName>(totalCount += bufCount);
            if (bufs != null) {
                for (MemberName[] buf0 : bufs) {
                    Collections.addAll(result, buf0);
                }
            }
            result.addAll(Arrays.asList(buf).subList(0, bufCount));
            if (matchType != null && matchType != matchSig) {
                Iterator<MemberName> it = result.iterator();
                while (it.hasNext()) {
                    MemberName m = it.next();
                    if (matchType.equals(m.getType())) continue;
                    it.remove();
                }
            }
            return result;
        }

        private MemberName resolve(byte refKind, MemberName ref, Class<?> lookupClass) {
            MemberName m = ref.clone();
            assert (refKind == m.getReferenceKind());
            try {
                m = MethodHandleNatives.resolve(m, lookupClass, false);
                m.checkForTypeAlias(m.getDeclaringClass());
                m.resolution = null;
            }
            catch (ClassNotFoundException | LinkageError ex) {
                assert (!m.isResolved());
                m.resolution = ex;
                return m;
            }
            assert (m.referenceKindIsConsistent());
            m.initResolved(true);
            assert (m.vminfoIsConsistent());
            return m;
        }

        public <NoSuchMemberException extends ReflectiveOperationException> MemberName resolveOrFail(byte refKind, MemberName m, Class<?> lookupClass, Class<NoSuchMemberException> nsmClass) throws IllegalAccessException, NoSuchMemberException {
            MemberName result = this.resolve(refKind, m, lookupClass);
            if (result.isResolved()) {
                return result;
            }
            ReflectiveOperationException ex = result.makeAccessException();
            if (ex instanceof IllegalAccessException) {
                throw (IllegalAccessException)ex;
            }
            throw (ReflectiveOperationException)nsmClass.cast(ex);
        }

        public MemberName resolveOrNull(byte refKind, MemberName m, Class<?> lookupClass) {
            MemberName result = this.resolve(refKind, m, lookupClass);
            if (result.isResolved()) {
                return result;
            }
            return null;
        }

        public List<MemberName> getMethods(Class<?> defc, boolean searchSupers, Class<?> lookupClass) {
            return this.getMethods(defc, searchSupers, null, null, lookupClass);
        }

        public List<MemberName> getMethods(Class<?> defc, boolean searchSupers, String name, MethodType type, Class<?> lookupClass) {
            int matchFlags = 0x10000 | (searchSupers ? 0x300000 : 0);
            return this.getMembers(defc, name, type, matchFlags, lookupClass);
        }

        public List<MemberName> getConstructors(Class<?> defc, Class<?> lookupClass) {
            return this.getMembers(defc, null, null, 131072, lookupClass);
        }

        public List<MemberName> getFields(Class<?> defc, boolean searchSupers, Class<?> lookupClass) {
            return this.getFields(defc, searchSupers, null, null, lookupClass);
        }

        public List<MemberName> getFields(Class<?> defc, boolean searchSupers, String name, Class<?> type, Class<?> lookupClass) {
            int matchFlags = 0x40000 | (searchSupers ? 0x300000 : 0);
            return this.getMembers(defc, name, type, matchFlags, lookupClass);
        }

        public List<MemberName> getNestedTypes(Class<?> defc, boolean searchSupers, Class<?> lookupClass) {
            int matchFlags = 0x80000 | (searchSupers ? 0x300000 : 0);
            return this.getMembers(defc, null, null, matchFlags, lookupClass);
        }

        private static MemberName[] newMemberBuffer(int length) {
            MemberName[] buf = new MemberName[length];
            for (int i = 0; i < length; ++i) {
                buf[i] = new MemberName();
            }
            return buf;
        }
    }
}

