/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.Invokers;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import sun.misc.Cleaner;

class MethodHandleNatives {
    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native MemberName resolve(MemberName var0, Class<?> var1, boolean var2) throws LinkageError, ClassNotFoundException;

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native long objectFieldOffset(MemberName var0);

    static native long staticFieldOffset(MemberName var0);

    static native Object staticFieldBase(MemberName var0);

    static native Object getMemberVMInfo(MemberName var0);

    static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    static native void copyOutBootstrapArguments(Class<?> var0, int[] var1, int var2, int var3, Object[] var4, int var5, boolean var6, Object var7);

    private static native void clearCallSiteContext(CallSiteContext var0);

    private static native void registerNatives();

    static boolean refKindIsValid(int refKind) {
        return refKind > 0 && refKind < 10;
    }

    static boolean refKindIsField(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind <= 4;
    }

    static boolean refKindIsGetter(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind <= 2;
    }

    static boolean refKindIsSetter(byte refKind) {
        return MethodHandleNatives.refKindIsField(refKind) && !MethodHandleNatives.refKindIsGetter(refKind);
    }

    static boolean refKindIsMethod(byte refKind) {
        return !MethodHandleNatives.refKindIsField(refKind) && refKind != 8;
    }

    static boolean refKindIsConstructor(byte refKind) {
        return refKind == 8;
    }

    static boolean refKindHasReceiver(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return (refKind & 1) != 0;
    }

    static boolean refKindIsStatic(byte refKind) {
        return !MethodHandleNatives.refKindHasReceiver(refKind) && refKind != 8;
    }

    static boolean refKindDoesDispatch(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind == 5 || refKind == 9;
    }

    static String refKindName(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        switch (refKind) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
        }
        return "REF_???";
    }

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] box = new Object[]{null};
        int i = 0;
        while (true) {
            block4: {
                box[0] = null;
                int vmval = MethodHandleNatives.getNamedCon(i, box);
                if (box[0] == null) break;
                String name = (String)box[0];
                try {
                    Field con = Constants.class.getDeclaredField(name);
                    int jval = con.getInt(null);
                    if (jval == vmval) break block4;
                    String err = name + ": JVM has " + vmval + " while Java has " + jval;
                    if (name.equals("CONV_OP_LIMIT")) {
                        System.err.println("warning: " + err);
                        break block4;
                    }
                    throw new InternalError(err);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    String err = name + ": JVM has " + vmval + " which Java does not define";
                }
            }
            ++i;
        }
        return true;
    }

    static MemberName linkCallSite(Object callerObj, Object bootstrapMethodObj, Object nameObj, Object typeObj, Object staticArguments, Object[] appendixResult) {
        MethodHandle bootstrapMethod = (MethodHandle)bootstrapMethodObj;
        Class caller = (Class)callerObj;
        String name = nameObj.toString().intern();
        MethodType type = (MethodType)typeObj;
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkCallSiteImpl(caller, bootstrapMethod, name, type, staticArguments, appendixResult);
        }
        return MethodHandleNatives.linkCallSiteTracing(caller, bootstrapMethod, name, type, staticArguments, appendixResult);
    }

    static MemberName linkCallSiteImpl(Class<?> caller, MethodHandle bootstrapMethod, String name, MethodType type, Object staticArguments, Object[] appendixResult) {
        CallSite callSite = CallSite.makeSite(bootstrapMethod, name, type, staticArguments, caller);
        if (callSite instanceof ConstantCallSite) {
            appendixResult[0] = callSite.dynamicInvoker();
            return Invokers.linkToTargetMethod(type);
        }
        appendixResult[0] = callSite;
        return Invokers.linkToCallSiteMethod(type);
    }

    static MemberName linkCallSiteTracing(Class<?> caller, MethodHandle bootstrapMethod, String name, MethodType type, Object staticArguments, Object[] appendixResult) {
        Object bsmReference = bootstrapMethod.internalMemberName();
        if (bsmReference == null) {
            bsmReference = bootstrapMethod;
        }
        List<Object> staticArglist = staticArguments instanceof Object[] ? Arrays.asList((Object[])staticArguments) : staticArguments;
        System.out.println("linkCallSite " + caller.getName() + " " + bsmReference + " " + name + type + "/" + staticArglist);
        try {
            MemberName res = MethodHandleNatives.linkCallSiteImpl(caller, bootstrapMethod, name, type, staticArguments, appendixResult);
            System.out.println("linkCallSite => " + res + " + " + appendixResult[0]);
            return res;
        }
        catch (Throwable ex) {
            System.out.println("linkCallSite => throw " + ex);
            throw ex;
        }
    }

    static MethodType findMethodHandleType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, true);
    }

    static MemberName linkMethod(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkMethodImpl(callerClass, refKind, defc, name, type, appendixResult);
        }
        return MethodHandleNatives.linkMethodTracing(callerClass, refKind, defc, name, type, appendixResult);
    }

    static MemberName linkMethodImpl(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        try {
            if (defc == MethodHandle.class && refKind == 5) {
                return Invokers.methodHandleInvokeLinkerMethod(name, MethodHandleNatives.fixMethodType(callerClass, type), appendixResult);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof LinkageError) {
                throw (LinkageError)ex;
            }
            throw new LinkageError(ex.getMessage(), ex);
        }
        throw new LinkageError("no such method " + defc.getName() + "." + name + type);
    }

    private static MethodType fixMethodType(Class<?> callerClass, Object type) {
        if (type instanceof MethodType) {
            return (MethodType)type;
        }
        return MethodType.fromMethodDescriptorString((String)type, callerClass.getClassLoader());
    }

    static MemberName linkMethodTracing(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        System.out.println("linkMethod " + defc.getName() + "." + name + type + "/" + Integer.toHexString(refKind));
        try {
            MemberName res = MethodHandleNatives.linkMethodImpl(callerClass, refKind, defc, name, type, appendixResult);
            System.out.println("linkMethod => " + res + " + " + appendixResult[0]);
            return res;
        }
        catch (Throwable ex) {
            System.out.println("linkMethod => throw " + ex);
            throw ex;
        }
    }

    static MethodHandle linkMethodHandleConstant(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
            assert (MethodHandleNatives.refKindIsValid(refKind));
            return lookup.linkMethodHandleConstant((byte)refKind, defc, name, type);
        }
        catch (IllegalAccessException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof AbstractMethodError) {
                throw (AbstractMethodError)cause;
            }
            IllegalAccessError err = new IllegalAccessError(ex.getMessage());
            throw MethodHandleNatives.initCauseFrom(err, ex);
        }
        catch (NoSuchMethodException ex) {
            NoSuchMethodError err = new NoSuchMethodError(ex.getMessage());
            throw MethodHandleNatives.initCauseFrom(err, ex);
        }
        catch (NoSuchFieldException ex) {
            NoSuchFieldError err = new NoSuchFieldError(ex.getMessage());
            throw MethodHandleNatives.initCauseFrom(err, ex);
        }
        catch (ReflectiveOperationException ex) {
            IncompatibleClassChangeError err = new IncompatibleClassChangeError();
            throw MethodHandleNatives.initCauseFrom(err, ex);
        }
    }

    private static Error initCauseFrom(Error err, Exception ex) {
        Throwable th = ex.getCause();
        if (err.getClass().isInstance(th)) {
            return (Error)th;
        }
        err.initCause(th == null ? ex : th);
        return err;
    }

    static boolean isCallerSensitive(MemberName mem) {
        if (!mem.isInvocable()) {
            return false;
        }
        return mem.isCallerSensitive() || MethodHandleNatives.canBeCalledVirtual(mem);
    }

    static boolean canBeCalledVirtual(MemberName mem) {
        assert (mem.isInvocable());
        Class<?> defc = mem.getDeclaringClass();
        switch (mem.getName()) {
            case "checkMemberAccess": {
                return MethodHandleNatives.canBeCalledVirtual(mem, SecurityManager.class);
            }
            case "getContextClassLoader": {
                return MethodHandleNatives.canBeCalledVirtual(mem, Thread.class);
            }
        }
        return false;
    }

    static boolean canBeCalledVirtual(MemberName symbolicRef, Class<?> definingClass) {
        Class<?> symbolicRefClass = symbolicRef.getDeclaringClass();
        if (symbolicRefClass == definingClass) {
            return true;
        }
        if (symbolicRef.isStatic() || symbolicRef.isPrivate()) {
            return false;
        }
        return definingClass.isAssignableFrom(symbolicRefClass) || symbolicRefClass.isInterface();
    }

    static {
        MethodHandleNatives.registerNatives();
        MethodHandleImpl.initStatics();
        int HR_MASK = 682;
        for (byte refKind = 1; refKind < 10; refKind = (byte)(refKind + 1)) {
            assert (MethodHandleNatives.refKindHasReceiver(refKind) == ((1 << refKind & 0x2AA) != 0)) : refKind;
        }
        assert (MethodHandleNatives.verifyConstants());
    }

    static class Constants {
        static final int GC_COUNT_GWT = 4;
        static final int GC_LAMBDA_SUPPORT = 5;
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_CALLER_SENSITIVE = 0x100000;
        static final int MN_REFERENCE_KIND_SHIFT = 24;
        static final int MN_REFERENCE_KIND_MASK = 15;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final int T_BOOLEAN = 4;
        static final int T_CHAR = 5;
        static final int T_FLOAT = 6;
        static final int T_DOUBLE = 7;
        static final int T_BYTE = 8;
        static final int T_SHORT = 9;
        static final int T_INT = 10;
        static final int T_LONG = 11;
        static final int T_OBJECT = 12;
        static final int T_VOID = 14;
        static final int T_ILLEGAL = 99;
        static final byte CONSTANT_Utf8 = 1;
        static final byte CONSTANT_Integer = 3;
        static final byte CONSTANT_Float = 4;
        static final byte CONSTANT_Long = 5;
        static final byte CONSTANT_Double = 6;
        static final byte CONSTANT_Class = 7;
        static final byte CONSTANT_String = 8;
        static final byte CONSTANT_Fieldref = 9;
        static final byte CONSTANT_Methodref = 10;
        static final byte CONSTANT_InterfaceMethodref = 11;
        static final byte CONSTANT_NameAndType = 12;
        static final byte CONSTANT_MethodHandle = 15;
        static final byte CONSTANT_MethodType = 16;
        static final byte CONSTANT_InvokeDynamic = 18;
        static final byte CONSTANT_LIMIT = 19;
        static final char ACC_PUBLIC = '\u0001';
        static final char ACC_PRIVATE = '\u0002';
        static final char ACC_PROTECTED = '\u0004';
        static final char ACC_STATIC = '\b';
        static final char ACC_FINAL = '\u0010';
        static final char ACC_SYNCHRONIZED = ' ';
        static final char ACC_VOLATILE = '@';
        static final char ACC_TRANSIENT = '\u0080';
        static final char ACC_NATIVE = '\u0100';
        static final char ACC_INTERFACE = '\u0200';
        static final char ACC_ABSTRACT = '\u0400';
        static final char ACC_STRICT = '\u0800';
        static final char ACC_SYNTHETIC = '\u1000';
        static final char ACC_ANNOTATION = '\u2000';
        static final char ACC_ENUM = '\u4000';
        static final char ACC_SUPER = ' ';
        static final char ACC_BRIDGE = '@';
        static final char ACC_VARARGS = '\u0080';
        static final byte REF_NONE = 0;
        static final byte REF_getField = 1;
        static final byte REF_getStatic = 2;
        static final byte REF_putField = 3;
        static final byte REF_putStatic = 4;
        static final byte REF_invokeVirtual = 5;
        static final byte REF_invokeStatic = 6;
        static final byte REF_invokeSpecial = 7;
        static final byte REF_newInvokeSpecial = 8;
        static final byte REF_invokeInterface = 9;
        static final byte REF_LIMIT = 10;

        Constants() {
        }
    }

    static class CallSiteContext
    implements Runnable {
        CallSiteContext() {
        }

        static CallSiteContext make(CallSite cs) {
            CallSiteContext newContext = new CallSiteContext();
            Cleaner.create(cs, newContext);
            return newContext;
        }

        @Override
        public void run() {
            MethodHandleNatives.clearCallSiteContext(this);
        }
    }
}

