/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;
import sun.misc.JavaLangRefAccess;
import sun.misc.SharedSecrets;

public abstract class Reference<T> {
    private T referent;
    volatile ReferenceQueue<? super T> queue;
    volatile Reference next;
    private transient Reference<T> discovered;
    private static final Object processPendingLock;
    private static boolean processPendingActive;

    private static native Reference<Object> getAndClearReferencePendingList();

    private static native boolean hasReferencePendingList();

    private static native void waitForReferencePendingList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingReferences() {
        Reference<Object> pendingList;
        Reference.waitForReferencePendingList();
        Object object = processPendingLock;
        synchronized (object) {
            pendingList = Reference.getAndClearReferencePendingList();
            processPendingActive = true;
        }
        while (pendingList != null) {
            Reference<Object> ref = pendingList;
            pendingList = ref.discovered;
            ref.discovered = null;
            if (ref instanceof Cleaner) {
                ((Cleaner)ref).clean();
                Object object2 = processPendingLock;
                synchronized (object2) {
                    processPendingLock.notifyAll();
                    continue;
                }
            }
            ReferenceQueue<Object> q = ref.queue;
            if (q == ReferenceQueue.NULL) continue;
            q.enqueue(ref);
        }
        object = processPendingLock;
        synchronized (object) {
            processPendingActive = false;
            processPendingLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForReferenceProcessing() throws InterruptedException {
        Object object = processPendingLock;
        synchronized (object) {
            if (processPendingActive || Reference.hasReferencePendingList()) {
                processPendingLock.wait();
                return true;
            }
            return false;
        }
    }

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    public boolean isEnqueued() {
        return this.queue == ReferenceQueue.ENQUEUED;
    }

    public boolean enqueue() {
        this.referent = null;
        return this.queue.enqueue(this);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    Reference(T referent) {
        this(referent, null);
    }

    Reference(T referent, ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue == null ? ReferenceQueue.NULL : queue;
    }

    static {
        ThreadGroup tg;
        processPendingLock = new Object();
        processPendingActive = false;
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        ReferenceHandler handler = new ReferenceHandler(tg, "Reference Handler");
        handler.setPriority(10);
        handler.setDaemon(true);
        handler.start();
        SharedSecrets.setJavaLangRefAccess(new JavaLangRefAccess(){

            @Override
            public boolean waitForReferenceProcessing() throws InterruptedException {
                return Reference.waitForReferenceProcessing();
            }
        });
    }

    private static class ReferenceHandler
    extends Thread {
        private static void ensureClassInitialized(Class<?> clazz) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw (Error)new NoClassDefFoundError(e.getMessage()).initCause(e);
            }
        }

        ReferenceHandler(ThreadGroup g, String name) {
            super(g, name);
        }

        @Override
        public void run() {
            while (true) {
                Reference.processPendingReferences();
            }
        }

        static {
            ReferenceHandler.ensureClassInitialized(Cleaner.class);
        }
    }
}

