/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import sun.net.ExtendedSocketOptions;
import sun.net.ResourceManager;
import sun.security.action.GetPropertyAction;

abstract class AbstractPlainDatagramSocketImpl
extends DatagramSocketImpl {
    int timeout = 0;
    boolean connected = false;
    private int trafficClass = 0;
    protected InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private static final String os = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static final boolean connectDisabled = os.contains("OS X");
    static final ExtendedSocketOptions extendedOptions;
    private static final Set<SocketOption<?>> datagramSocketOptions;
    private static final Set<SocketOption<?>> multicastSocketOptions;

    AbstractPlainDatagramSocketImpl() {
    }

    @Override
    protected synchronized void create() throws SocketException {
        ResourceManager.beforeUdpCreate();
        this.fd = new FileDescriptor();
        try {
            this.datagramSocketCreate();
        }
        catch (SocketException ioe) {
            ResourceManager.afterUdpClose();
            this.fd = null;
            throw ioe;
        }
    }

    @Override
    protected synchronized void bind(int lport, InetAddress laddr) throws SocketException {
        this.bind0(lport, laddr);
    }

    protected abstract void bind0(int var1, InetAddress var2) throws SocketException;

    @Override
    protected abstract void send(DatagramPacket var1) throws IOException;

    @Override
    protected void connect(InetAddress address, int port) throws SocketException {
        this.connect0(address, port);
        this.connectedAddress = address;
        this.connectedPort = port;
        this.connected = true;
    }

    @Override
    protected void disconnect() {
        this.disconnect0(this.connectedAddress.holder().getFamily());
        this.connected = false;
        this.connectedAddress = null;
        this.connectedPort = -1;
    }

    @Override
    protected abstract int peek(InetAddress var1) throws IOException;

    @Override
    protected abstract int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized void receive(DatagramPacket p) throws IOException {
        this.receive0(p);
    }

    protected abstract void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected abstract void setTimeToLive(int var1) throws IOException;

    @Override
    protected abstract int getTimeToLive() throws IOException;

    @Override
    @Deprecated
    protected abstract void setTTL(byte var1) throws IOException;

    @Override
    @Deprecated
    protected abstract byte getTTL() throws IOException;

    @Override
    protected void join(InetAddress inetaddr) throws IOException {
        this.join(inetaddr, null);
    }

    @Override
    protected void leave(InetAddress inetaddr) throws IOException {
        this.leave(inetaddr, null);
    }

    @Override
    protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (mcastaddr == null || !(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.join(((InetSocketAddress)mcastaddr).getAddress(), netIf);
    }

    protected abstract void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (mcastaddr == null || !(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.leave(((InetSocketAddress)mcastaddr).getAddress(), netIf);
    }

    protected abstract void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void close() {
        if (this.fd != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
        }
    }

    protected boolean isClosed() {
        return this.fd == null;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public void setOption(int optID, Object o) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (optID) {
            case 4102: {
                if (o == null || !(o instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int tmp = (Integer)o;
                if (tmp < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = tmp;
                return;
            }
            case 3: {
                if (o == null || !(o instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)o;
                break;
            }
            case 4: {
                if (o != null && o instanceof Boolean) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 32: {
                if (o != null && o instanceof Boolean) break;
                throw new SocketException("bad argument for SO_BROADCAST");
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4097: 
            case 4098: {
                if (o != null && o instanceof Integer && (Integer)o >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (o != null && o instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            case 31: {
                if (o != null && o instanceof NetworkInterface) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF2");
            }
            case 18: {
                if (o != null && o instanceof Boolean) break;
                throw new SocketException("bad argument for IP_MULTICAST_LOOP");
            }
            default: {
                throw new SocketException("invalid option: " + optID);
            }
        }
        this.socketSetOption(optID, o);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        Object result;
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (optID) {
            case 4102: {
                result = new Integer(this.timeout);
                break;
            }
            case 3: {
                result = this.socketGetOption(optID);
                if ((Integer)result != -1) break;
                result = new Integer(this.trafficClass);
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 31: 
            case 32: 
            case 4097: 
            case 4098: {
                result = this.socketGetOption(optID);
                break;
            }
            default: {
                throw new SocketException("invalid option: " + optID);
            }
        }
        return result;
    }

    private static Set<SocketOption<?>> datagramSocketOptions() {
        HashSet options = new HashSet();
        options.add(StandardSocketOptions.SO_SNDBUF);
        options.add(StandardSocketOptions.SO_RCVBUF);
        options.add(StandardSocketOptions.SO_REUSEADDR);
        options.add(StandardSocketOptions.IP_TOS);
        options.addAll(ExtendedSocketOptions.datagramSocketOptions());
        return Collections.unmodifiableSet(options);
    }

    private static Set<SocketOption<?>> multicastSocketOptions() {
        HashSet options = new HashSet();
        options.add(StandardSocketOptions.SO_SNDBUF);
        options.add(StandardSocketOptions.SO_RCVBUF);
        options.add(StandardSocketOptions.SO_REUSEADDR);
        options.add(StandardSocketOptions.IP_TOS);
        options.add(StandardSocketOptions.IP_MULTICAST_IF);
        options.add(StandardSocketOptions.IP_MULTICAST_TTL);
        options.add(StandardSocketOptions.IP_MULTICAST_LOOP);
        options.addAll(ExtendedSocketOptions.datagramSocketOptions());
        return Collections.unmodifiableSet(options);
    }

    private Set<SocketOption<?>> supportedOptions() {
        if (this.getDatagramSocket() instanceof MulticastSocket) {
            return multicastSocketOptions;
        }
        return datagramSocketOptions;
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        if (!name.type().isInstance(value)) {
            throw new IllegalArgumentException("Invalid value '" + value + "'");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        if (name == StandardSocketOptions.SO_SNDBUF) {
            if ((Integer)value < 0) {
                throw new IllegalArgumentException("Invalid send buffer size:" + value);
            }
            this.setOption(4097, value);
        } else if (name == StandardSocketOptions.SO_RCVBUF) {
            if ((Integer)value < 0) {
                throw new IllegalArgumentException("Invalid recv buffer size:" + value);
            }
            this.setOption(4098, value);
        } else if (name == StandardSocketOptions.SO_REUSEADDR) {
            this.setOption(4, value);
        } else if (name == StandardSocketOptions.IP_TOS) {
            int i = (Integer)value;
            if (i < 0 || i > 255) {
                throw new IllegalArgumentException("Invalid IP_TOS value: " + value);
            }
            this.setOption(3, value);
        } else if (name == StandardSocketOptions.IP_MULTICAST_IF) {
            this.setOption(31, value);
        } else if (name == StandardSocketOptions.IP_MULTICAST_TTL) {
            int i = (Integer)value;
            if (i < 0 || i > 255) {
                throw new IllegalArgumentException("Invalid TTL/hop value: " + value);
            }
            this.setTimeToLive((Integer)value);
        } else if (name == StandardSocketOptions.IP_MULTICAST_LOOP) {
            this.setOption(18, value);
        } else if (extendedOptions.isOptionSupported(name)) {
            extendedOptions.setOption(this.fd, name, value);
        } else {
            throw new AssertionError((Object)("unknown option :" + name));
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        if (name == StandardSocketOptions.SO_SNDBUF) {
            return (T)this.getOption(4097);
        }
        if (name == StandardSocketOptions.SO_RCVBUF) {
            return (T)this.getOption(4098);
        }
        if (name == StandardSocketOptions.SO_REUSEADDR) {
            return (T)this.getOption(4);
        }
        if (name == StandardSocketOptions.IP_TOS) {
            return (T)this.getOption(3);
        }
        if (name == StandardSocketOptions.IP_MULTICAST_IF) {
            return (T)this.getOption(31);
        }
        if (name == StandardSocketOptions.IP_MULTICAST_TTL) {
            return (T)Integer.valueOf(this.getTimeToLive());
        }
        if (name == StandardSocketOptions.IP_MULTICAST_LOOP) {
            return (T)this.getOption(18);
        }
        if (extendedOptions.isOptionSupported(name)) {
            return (T)extendedOptions.getOption(this.fd, name);
        }
        throw new AssertionError((Object)("unknown option: " + name));
    }

    protected abstract void datagramSocketCreate() throws SocketException;

    protected abstract void datagramSocketClose();

    protected abstract void socketSetOption(int var1, Object var2) throws SocketException;

    protected abstract Object socketGetOption(int var1) throws SocketException;

    protected abstract void connect0(InetAddress var1, int var2) throws SocketException;

    protected abstract void disconnect0(int var1);

    protected boolean nativeConnectDisabled() {
        return connectDisabled;
    }

    @Override
    abstract int dataAvailable();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                return null;
            }
        });
        extendedOptions = ExtendedSocketOptions.getInstance();
        datagramSocketOptions = AbstractPlainDatagramSocketImpl.datagramSocketOptions();
        multicastSocketOptions = AbstractPlainDatagramSocketImpl.multicastSocketOptions();
    }
}

