/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.AbstractPlainSocketImpl;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class HttpConnectSocketImpl
extends PlainSocketImpl {
    private static final String httpURLClazzStr = "sun.net.www.protocol.http.HttpURLConnection";
    private static final String netClientClazzStr = "sun.net.NetworkClient";
    private static final String doTunnelingStr = "doTunneling";
    private static final Field httpField;
    private static final Field serverSocketField;
    private static final Method doTunneling;
    private final String server;
    private InetSocketAddress external_address;
    private HashMap<Integer, Object> optionsMap = new HashMap();

    HttpConnectSocketImpl(Proxy proxy) {
        super(false);
        SocketAddress a = proxy.address();
        if (!(a instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress ad = (InetSocketAddress)a;
        this.server = ad.getHostString();
        this.port = ad.getPort();
    }

    @Override
    protected void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint == null || !(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        String destHost = epoint.isUnresolved() ? epoint.getHostName() : epoint.getAddress().getHostAddress();
        int destPort = epoint.getPort();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(destHost, destPort);
        }
        String urlString = "http://" + destHost + ":" + destPort;
        Socket httpSocket = this.privilegedDoTunnel(urlString, timeout);
        this.external_address = epoint;
        this.close();
        AbstractPlainSocketImpl psi = (AbstractPlainSocketImpl)httpSocket.impl;
        this.getSocket().impl = psi;
        Set<Map.Entry<Integer, Object>> options = this.optionsMap.entrySet();
        try {
            for (Map.Entry<Integer, Object> entry : options) {
                psi.setOption(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setOption(int opt, Object val) throws SocketException {
        super.setOption(opt, val);
        if (this.external_address != null) {
            return;
        }
        this.optionsMap.put(opt, val);
    }

    private Socket privilegedDoTunnel(final String urlString, final int timeout) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException {
                    return HttpConnectSocketImpl.this.doTunnel(urlString, timeout);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private Socket doTunnel(String urlString, int connectTimeout) throws IOException {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.server, this.port));
        URL destURL = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)destURL.openConnection(proxy);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(this.timeout);
        conn.connect();
        this.doTunneling(conn);
        try {
            Object httpClient = httpField.get(conn);
            return (Socket)serverSocketField.get(httpClient);
        }
        catch (IllegalAccessException x) {
            throw new InternalError("Should not reach here", x);
        }
    }

    private void doTunneling(HttpURLConnection conn) {
        try {
            doTunneling.invoke(conn, new Object[0]);
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError("Should not reach here", x);
        }
    }

    @Override
    protected InetAddress getInetAddress() {
        if (this.external_address != null) {
            return this.external_address.getAddress();
        }
        return super.getInetAddress();
    }

    @Override
    protected int getPort() {
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getPort();
    }

    @Override
    protected int getLocalPort() {
        if (this.socket != null) {
            return super.getLocalPort();
        }
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getLocalPort();
    }

    static {
        try {
            Class<?> httpClazz = Class.forName(httpURLClazzStr, true, null);
            httpField = httpClazz.getDeclaredField("http");
            doTunneling = httpClazz.getDeclaredMethod(doTunnelingStr, new Class[0]);
            Class<?> netClientClazz = Class.forName(netClientClazzStr, true, null);
            serverSocketField = netClientClazz.getDeclaredField("serverSocket");
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    httpField.setAccessible(true);
                    serverSocketField.setAccessible(true);
                    return null;
                }
            });
        }
        catch (ReflectiveOperationException x) {
            throw new InternalError("Should not reach here", x);
        }
    }
}

