/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLDecoder {
    static String dfltEncName = URLEncoder.dfltEncName;

    @Deprecated
    public static String decode(String s) {
        String str = null;
        try {
            str = URLDecoder.decode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 1500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.isEmpty()) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            char ch1 = s.charAt(i + 1);
                            char ch2 = s.charAt(i + 2);
                            if (ch1 <= '\u007f' && ch2 <= '\u007f') {
                                int lb;
                                int hb;
                                if (ch1 >= '0' && ch1 <= '9') {
                                    hb = ch1 - 48;
                                } else if (ch1 >= 'a' && ch1 <= 'f') {
                                    hb = 10 + ch1 - 97;
                                } else if (ch1 >= 'A' && ch1 <= 'F') {
                                    hb = 10 + ch1 - 65;
                                } else {
                                    throw new NumberFormatException("For input string: \"" + s.substring(i + 1, i + 3) + "\"");
                                }
                                assert (hb <= 16 && hb >= 0);
                                if (ch2 >= '0' && ch2 <= '9') {
                                    lb = ch2 - 48;
                                } else if (ch2 >= 'a' && ch2 <= 'f') {
                                    lb = 10 + ch2 - 97;
                                } else if (ch2 >= 'A' && ch2 <= 'F') {
                                    lb = 10 + ch2 - 65;
                                } else {
                                    throw new NumberFormatException("For input string: \"" + s.substring(i + 1, i + 3) + "\"");
                                }
                                assert (lb <= 16 && lb >= 0);
                                bytes[pos++] = (byte)(hb << 4 | lb);
                            } else {
                                int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                                if (v < 0) {
                                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                                }
                                bytes[pos++] = (byte)v;
                            }
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }
}

