/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRS;
import java.nio.LongBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferS
extends LongBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(long[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 3;
        assert (off >= 0);
        return new DirectLongBufferS(this, -1, 0, rem, rem, off);
    }

    @Override
    public LongBuffer duplicate() {
        return new DirectLongBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 3);
    }

    @Override
    public long get() {
        return Bits.swap(unsafe.getLong(this.ix(this.nextGetIndex())));
    }

    @Override
    public long get(int i) {
        return Bits.swap(unsafe.getLong(this.ix(this.checkIndex(i))));
    }

    @Override
    public LongBuffer get(long[] dst, int offset, int length) {
        if ((long)length << 3 > 6L) {
            int rem;
            DirectLongBufferS.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(pos), dst, (long)offset << 3, (long)length << 3);
            } else {
                Bits.copyToArray(this.ix(pos), dst, arrayBaseOffset, (long)offset << 3, (long)length << 3);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public LongBuffer put(long x) {
        unsafe.putLong(this.ix(this.nextPutIndex()), Bits.swap(x));
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        unsafe.putLong(this.ix(this.checkIndex(i)), Bits.swap(x));
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        if (src instanceof DirectLongBufferS) {
            int rem;
            int slim;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferS sb = (DirectLongBufferS)src;
            int spos = sb.position();
            int srem = spos <= (slim = sb.limit()) ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), (long)srem << 3);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        if ((long)length << 3 > 6L) {
            int rem;
            DirectLongBufferS.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(src, (long)offset << 3, this.ix(pos), (long)length << 3);
            } else {
                Bits.copyFromArray(src, arrayBaseOffset, (long)offset << 3, this.ix(pos), (long)length << 3);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), (long)rem << 3);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

