/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectShortBufferRS;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectShortBufferS
extends ShortBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(short[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectShortBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public ShortBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 1;
        assert (off >= 0);
        return new DirectShortBufferS(this, -1, 0, rem, rem, off);
    }

    @Override
    public ShortBuffer duplicate() {
        return new DirectShortBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new DirectShortBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 1);
    }

    @Override
    public short get() {
        return Bits.swap(unsafe.getShort(this.ix(this.nextGetIndex())));
    }

    @Override
    public short get(int i) {
        return Bits.swap(unsafe.getShort(this.ix(this.checkIndex(i))));
    }

    @Override
    public ShortBuffer get(short[] dst, int offset, int length) {
        if ((long)length << 1 > 6L) {
            int rem;
            DirectShortBufferS.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToShortArray(this.ix(pos), dst, (long)offset << 1, (long)length << 1);
            } else {
                Bits.copyToArray(this.ix(pos), dst, arrayBaseOffset, (long)offset << 1, (long)length << 1);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public ShortBuffer put(short x) {
        unsafe.putShort(this.ix(this.nextPutIndex()), Bits.swap(x));
        return this;
    }

    @Override
    public ShortBuffer put(int i, short x) {
        unsafe.putShort(this.ix(this.checkIndex(i)), Bits.swap(x));
        return this;
    }

    @Override
    public ShortBuffer put(ShortBuffer src) {
        if (src instanceof DirectShortBufferS) {
            int rem;
            int slim;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectShortBufferS sb = (DirectShortBufferS)src;
            int spos = sb.position();
            int srem = spos <= (slim = sb.limit()) ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), (long)srem << 1);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public ShortBuffer put(short[] src, int offset, int length) {
        if ((long)length << 1 > 6L) {
            int rem;
            DirectShortBufferS.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromShortArray(src, (long)offset << 1, this.ix(pos), (long)length << 1);
            } else {
                Bits.copyFromArray(src, arrayBaseOffset, (long)offset << 1, this.ix(pos), (long)length << 1);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), (long)rem << 1);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

