/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRB;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteBufferAsDoubleBufferRB;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteBufferAsFloatBufferRB;
import java.nio.ByteBufferAsFloatBufferRL;
import java.nio.ByteBufferAsIntBufferRB;
import java.nio.ByteBufferAsIntBufferRL;
import java.nio.ByteBufferAsLongBufferRB;
import java.nio.ByteBufferAsLongBufferRL;
import java.nio.ByteBufferAsShortBufferRB;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

class HeapByteBufferR
extends HeapByteBuffer {
    HeapByteBufferR(int cap, int lim) {
        super(cap, lim);
        this.isReadOnly = true;
    }

    HeapByteBufferR(byte[] buf, int off, int len) {
        super(buf, off, len);
        this.isReadOnly = true;
    }

    protected HeapByteBufferR(byte[] buf, int mark, int pos, int lim, int cap, int off) {
        super(buf, mark, pos, lim, cap, off);
        this.isReadOnly = true;
    }

    @Override
    public ByteBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapByteBufferR(this.hb, -1, 0, rem, rem, pos + this.offset);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteBuffer put(byte x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    byte _get(int i) {
        return this.hb[i];
    }

    @Override
    void _put(int i, byte b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putChar(char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer asCharBuffer() {
        int size = this.remaining() >> 1;
        int off = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsCharBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsCharBufferRL(this, -1, 0, size, size, off);
    }

    @Override
    public ByteBuffer putShort(short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int size = this.remaining() >> 1;
        int off = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsShortBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsShortBufferRL(this, -1, 0, size, size, off);
    }

    @Override
    public ByteBuffer putInt(int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer asIntBuffer() {
        int size = this.remaining() >> 2;
        int off = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsIntBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsIntBufferRL(this, -1, 0, size, size, off);
    }

    @Override
    public ByteBuffer putLong(long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer asLongBuffer() {
        int size = this.remaining() >> 3;
        int off = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsLongBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsLongBufferRL(this, -1, 0, size, size, off);
    }

    @Override
    public ByteBuffer putFloat(float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int size = this.remaining() >> 2;
        int off = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsFloatBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsFloatBufferRL(this, -1, 0, size, size, off);
    }

    @Override
    public ByteBuffer putDouble(double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int size = this.remaining() >> 3;
        int off = this.offset + this.position();
        return this.bigEndian ? new ByteBufferAsDoubleBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsDoubleBufferRL(this, -1, 0, size, size, off);
    }
}

