/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.security.AccessController;
import java.time.Instant;
import java.time.LocalDate;
import sun.security.action.GetPropertyAction;

public class Date
extends java.util.Date {
    private static final boolean expectStrictDateFomat;
    static final long serialVersionUID = 1511598038487230103L;

    @Deprecated
    public Date(int year, int month, int day) {
        super(year, month, day);
    }

    public Date(long date) {
        super(date);
    }

    @Override
    public void setTime(long date) {
        super.setTime(date);
    }

    public static Date valueOf(String s) {
        if (expectStrictDateFomat) {
            return Date.strict_valueOf(s);
        }
        return Date.tolerant_valueOf(s);
    }

    private static Date strict_valueOf(String s) {
        int YEAR_LENGTH = 4;
        int MONTH_LENGTH = 2;
        int DAY_LENGTH = 2;
        int MAX_MONTH = 12;
        int MAX_DAY = 31;
        Date d = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int firstDash = s.indexOf(45);
        int secondDash = s.indexOf(45, firstDash + 1);
        if (firstDash > 0 && secondDash > 0 && secondDash < s.length() - 1) {
            String yyyy = s.substring(0, firstDash);
            String mm = s.substring(firstDash + 1, secondDash);
            String dd = s.substring(secondDash + 1);
            if (yyyy.length() == 4 && mm.length() >= 1 && mm.length() <= 2 && dd.length() >= 1 && dd.length() <= 2) {
                int year = Integer.parseInt(yyyy);
                int month = Integer.parseInt(mm);
                int day = Integer.parseInt(dd);
                if (month >= 1 && month <= 12 && day >= 1 && day <= 31) {
                    d = new Date(year - 1900, month - 1, day);
                }
            }
        }
        if (d == null) {
            throw new IllegalArgumentException();
        }
        return d;
    }

    private static Date tolerant_valueOf(String s) {
        int secondDash;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int firstDash = s.indexOf(45);
        if (!(firstDash > 0 & (secondDash = s.indexOf(45, firstDash + 1)) > 0 & secondDash < s.length() - 1)) {
            throw new IllegalArgumentException();
        }
        int year = Integer.parseInt(s.substring(0, firstDash)) - 1900;
        int month = Integer.parseInt(s.substring(firstDash + 1, secondDash)) - 1;
        int day = Integer.parseInt(s.substring(secondDash + 1));
        return new Date(year, month, day);
    }

    @Override
    public String toString() {
        int year = super.getYear() + 1900;
        int month = super.getMonth() + 1;
        int day = super.getDate();
        char[] buf = "2000-00-00".toCharArray();
        buf[0] = Character.forDigit(year / 1000, 10);
        buf[1] = Character.forDigit(year / 100 % 10, 10);
        buf[2] = Character.forDigit(year / 10 % 10, 10);
        buf[3] = Character.forDigit(year % 10, 10);
        buf[5] = Character.forDigit(month / 10, 10);
        buf[6] = Character.forDigit(month % 10, 10);
        buf[8] = Character.forDigit(day / 10, 10);
        buf[9] = Character.forDigit(day % 10, 10);
        return new String(buf);
    }

    @Override
    @Deprecated
    public int getHours() {
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public int getMinutes() {
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public int getSeconds() {
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public void setHours(int i) {
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public void setMinutes(int i) {
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public void setSeconds(int i) {
        throw new IllegalArgumentException();
    }

    public static Date valueOf(LocalDate date) {
        return new Date(date.getYear() - 1900, date.getMonthValue() - 1, date.getDayOfMonth());
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.getYear() + 1900, this.getMonth() + 1, this.getDate());
    }

    @Override
    public Instant toInstant() {
        throw new UnsupportedOperationException();
    }

    static {
        String propValue = AccessController.doPrivileged(new GetPropertyAction("com.sap.vm.strictsqldate", "true"));
        expectStrictDateFomat = propValue.length() == 0 ? true : Boolean.valueOf(propValue);
    }
}

