/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;
import sun.text.CollatorUtilities;
import sun.text.normalizer.NormalizerBase;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private NormalizerBase text = null;
    private int[] buffer = null;
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    CollationElementIterator(String sourceText, RuleBasedCollator owner) {
        this.owner = owner;
        this.ordering = owner.getTables();
        if (!sourceText.isEmpty()) {
            NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(owner.getDecomposition());
            this.text = new NormalizerBase(sourceText, mode);
        }
    }

    CollationElementIterator(CharacterIterator sourceText, RuleBasedCollator owner) {
        this.owner = owner;
        this.ordering = owner.getTables();
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(owner.getDecomposition());
        this.text = new NormalizerBase(sourceText, mode);
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition());
            this.text.setMode(mode);
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int next() {
        NormalizerBase.Mode ownerMode;
        if (this.text == null) {
            return -1;
        }
        NormalizerBase.Mode textMode = this.text.getMode();
        if (textMode != (ownerMode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(ownerMode);
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            if (Character.isSupplementaryCodePoint(this.swapOrder)) {
                char[] chars = Character.toChars(this.swapOrder);
                this.swapOrder = chars[1];
                return chars[0] << 16;
            }
            int order = this.swapOrder << 16;
            this.swapOrder = 0;
            return order;
        }
        int ch = this.text.next();
        if (ch == -1) {
            return -1;
        }
        int value = this.ordering.getUnicodeOrder(ch);
        if (value == -1) {
            this.swapOrder = ch;
            return 0x7FFF0000;
        }
        if (value >= 0x7F000000) {
            value = this.nextContractChar(ch);
        }
        if (value >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(value);
            this.expIndex = 0;
            value = this.buffer[this.expIndex++];
        }
        if (this.ordering.isSEAsianSwapping()) {
            int consonant;
            if (CollationElementIterator.isThaiPreVowel(ch)) {
                consonant = this.text.next();
                if (CollationElementIterator.isThaiBaseConsonant(consonant)) {
                    this.buffer = this.makeReorderedBuffer(consonant, value, this.buffer, true);
                    value = this.buffer[0];
                    this.expIndex = 1;
                } else if (consonant != -1) {
                    this.text.previous();
                }
            }
            if (CollationElementIterator.isLaoPreVowel(ch)) {
                consonant = this.text.next();
                if (CollationElementIterator.isLaoBaseConsonant(consonant)) {
                    this.buffer = this.makeReorderedBuffer(consonant, value, this.buffer, true);
                    value = this.buffer[0];
                    this.expIndex = 1;
                } else if (consonant != -1) {
                    this.text.previous();
                }
            }
        }
        return this.strengthOrder(value);
    }

    public int previous() {
        NormalizerBase.Mode ownerMode;
        if (this.text == null) {
            return -1;
        }
        NormalizerBase.Mode textMode = this.text.getMode();
        if (textMode != (ownerMode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(ownerMode);
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            if (Character.isSupplementaryCodePoint(this.swapOrder)) {
                char[] chars = Character.toChars(this.swapOrder);
                this.swapOrder = chars[1];
                return chars[0] << 16;
            }
            int order = this.swapOrder << 16;
            this.swapOrder = 0;
            return order;
        }
        int ch = this.text.previous();
        if (ch == -1) {
            return -1;
        }
        int value = this.ordering.getUnicodeOrder(ch);
        if (value == -1) {
            this.swapOrder = 0x7FFF0000;
            return ch;
        }
        if (value >= 0x7F000000) {
            value = this.prevContractChar(ch);
        }
        if (value >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(value);
            this.expIndex = this.buffer.length;
            value = this.buffer[--this.expIndex];
        }
        if (this.ordering.isSEAsianSwapping()) {
            int vowel;
            if (CollationElementIterator.isThaiBaseConsonant(ch)) {
                vowel = this.text.previous();
                if (CollationElementIterator.isThaiPreVowel(vowel)) {
                    this.buffer = this.makeReorderedBuffer(vowel, value, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    value = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
            if (CollationElementIterator.isLaoBaseConsonant(ch)) {
                vowel = this.text.previous();
                if (CollationElementIterator.isLaoPreVowel(vowel)) {
                    this.buffer = this.makeReorderedBuffer(vowel, value, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    value = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
        }
        return this.strengthOrder(value);
    }

    public static final int primaryOrder(int order) {
        return (order &= 0xFFFF0000) >>> 16;
    }

    public static final short secondaryOrder(int order) {
        return (short)((order &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int order) {
        return (short)(order &= 0xFF);
    }

    final int strengthOrder(int order) {
        int s = this.owner.getStrength();
        if (s == 0) {
            order &= 0xFFFF0000;
        } else if (s == 1) {
            order &= 0xFFFFFF00;
        }
        return order;
    }

    public void setOffset(int newOffset) {
        if (this.text != null) {
            if (newOffset < this.text.getBeginIndex() || newOffset >= this.text.getEndIndex()) {
                this.text.setIndexOnly(newOffset);
            } else {
                int c = this.text.setIndex(newOffset);
                if (this.ordering.usedInContractSeq(c)) {
                    while (this.ordering.usedInContractSeq(c)) {
                        c = this.text.previous();
                    }
                    int last = this.text.getIndex();
                    while (this.text.getIndex() <= newOffset) {
                        last = this.text.getIndex();
                        this.next();
                    }
                    this.text.setIndexOnly(last);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int getOffset() {
        return this.text != null ? this.text.getIndex() : 0;
    }

    public int getMaxExpansion(int order) {
        return this.ordering.getMaxExpansion(order);
    }

    public void setText(String source) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new NormalizerBase(source, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(source);
        }
    }

    public void setText(CharacterIterator source) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new NormalizerBase(source, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(source);
        }
    }

    private static final boolean isThaiPreVowel(int ch) {
        return ch >= 3648 && ch <= 3652;
    }

    private static final boolean isThaiBaseConsonant(int ch) {
        return ch >= 3585 && ch <= 3630;
    }

    private static final boolean isLaoPreVowel(int ch) {
        return ch >= 3776 && ch <= 3780;
    }

    private static final boolean isLaoBaseConsonant(int ch) {
        return ch >= 3713 && ch <= 3758;
    }

    private int[] makeReorderedBuffer(int colFirst, int lastValue, int[] lastExpansion, boolean forward) {
        int[] result;
        int firstValue = this.ordering.getUnicodeOrder(colFirst);
        if (firstValue >= 0x7F000000) {
            firstValue = forward ? this.nextContractChar(colFirst) : this.prevContractChar(colFirst);
        }
        int[] firstExpansion = null;
        if (firstValue >= 0x7E000000) {
            firstExpansion = this.ordering.getExpandValueList(firstValue);
        }
        if (!forward) {
            int temp1 = firstValue;
            firstValue = lastValue;
            lastValue = temp1;
            int[] temp2 = firstExpansion;
            firstExpansion = lastExpansion;
            lastExpansion = temp2;
        }
        if (firstExpansion == null && lastExpansion == null) {
            result = new int[]{firstValue, lastValue};
        } else {
            int firstLength = firstExpansion == null ? 1 : firstExpansion.length;
            int lastLength = lastExpansion == null ? 1 : lastExpansion.length;
            result = new int[firstLength + lastLength];
            if (firstExpansion == null) {
                result[0] = firstValue;
            } else {
                System.arraycopy(firstExpansion, 0, result, 0, firstLength);
            }
            if (lastExpansion == null) {
                result[firstLength] = lastValue;
            } else {
                System.arraycopy(lastExpansion, 0, result, firstLength, lastLength);
            }
        }
        return result;
    }

    static final boolean isIgnorable(int order) {
        return CollationElementIterator.primaryOrder(order) == 0;
    }

    private int nextContractChar(int ch) {
        Vector<EntryPair> list = this.ordering.getContractValues(ch);
        EntryPair pair = list.firstElement();
        int order = pair.value;
        pair = list.lastElement();
        int maxLength = pair.entryName.length();
        NormalizerBase tempText = (NormalizerBase)this.text.clone();
        tempText.previous();
        this.key.setLength(0);
        int c = tempText.next();
        while (maxLength > 0 && c != -1) {
            if (Character.isSupplementaryCodePoint(c)) {
                this.key.append(Character.toChars(c));
                maxLength -= 2;
            } else {
                this.key.append((char)c);
                --maxLength;
            }
            c = tempText.next();
        }
        String fragment = this.key.toString();
        maxLength = 1;
        for (int i = list.size() - 1; i > 0; --i) {
            pair = list.elementAt(i);
            if (!pair.fwd || !fragment.startsWith(pair.entryName) || pair.entryName.length() <= maxLength) continue;
            maxLength = pair.entryName.length();
            order = pair.value;
        }
        while (maxLength > 1) {
            c = this.text.next();
            maxLength -= Character.charCount(c);
        }
        return order;
    }

    private int prevContractChar(int ch) {
        Vector<EntryPair> list = this.ordering.getContractValues(ch);
        EntryPair pair = list.firstElement();
        int order = pair.value;
        pair = list.lastElement();
        int maxLength = pair.entryName.length();
        NormalizerBase tempText = (NormalizerBase)this.text.clone();
        tempText.next();
        this.key.setLength(0);
        int c = tempText.previous();
        while (maxLength > 0 && c != -1) {
            if (Character.isSupplementaryCodePoint(c)) {
                this.key.append(Character.toChars(c));
                maxLength -= 2;
            } else {
                this.key.append((char)c);
                --maxLength;
            }
            c = tempText.previous();
        }
        String fragment = this.key.toString();
        maxLength = 1;
        for (int i = list.size() - 1; i > 0; --i) {
            pair = list.elementAt(i);
            if (pair.fwd || !fragment.startsWith(pair.entryName) || pair.entryName.length() <= maxLength) continue;
            maxLength = pair.entryName.length();
            order = pair.value;
        }
        while (maxLength > 1) {
            c = this.text.previous();
            maxLength -= Character.charCount(c);
        }
        return order;
    }
}

