/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ParseException;

class PatternEntry {
    static final int RESET = -2;
    static final int UNSET = -1;
    int strength = -1;
    String chars = "";
    String extension = "";

    public void appendQuotedExtension(StringBuffer toAddTo) {
        PatternEntry.appendQuoted(this.extension, toAddTo);
    }

    public void appendQuotedChars(StringBuffer toAddTo) {
        PatternEntry.appendQuoted(this.chars, toAddTo);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        PatternEntry other = (PatternEntry)obj;
        boolean result = this.chars.equals(other.chars);
        return result;
    }

    public int hashCode() {
        return this.chars.hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.addToBuffer(result, true, false, null);
        return result.toString();
    }

    final int getStrength() {
        return this.strength;
    }

    final String getExtension() {
        return this.extension;
    }

    final String getChars() {
        return this.chars;
    }

    void addToBuffer(StringBuffer toAddTo, boolean showExtension, boolean showWhiteSpace, PatternEntry lastEntry) {
        if (showWhiteSpace && toAddTo.length() > 0) {
            if (this.strength == 0 || lastEntry != null) {
                toAddTo.append('\n');
            } else {
                toAddTo.append(' ');
            }
        }
        if (lastEntry != null) {
            toAddTo.append('&');
            if (showWhiteSpace) {
                toAddTo.append(' ');
            }
            lastEntry.appendQuotedChars(toAddTo);
            this.appendQuotedExtension(toAddTo);
            if (showWhiteSpace) {
                toAddTo.append(' ');
            }
        }
        switch (this.strength) {
            case 3: {
                toAddTo.append('=');
                break;
            }
            case 2: {
                toAddTo.append(',');
                break;
            }
            case 1: {
                toAddTo.append(';');
                break;
            }
            case 0: {
                toAddTo.append('<');
                break;
            }
            case -2: {
                toAddTo.append('&');
                break;
            }
            case -1: {
                toAddTo.append('?');
            }
        }
        if (showWhiteSpace) {
            toAddTo.append(' ');
        }
        PatternEntry.appendQuoted(this.chars, toAddTo);
        if (showExtension && !this.extension.isEmpty()) {
            toAddTo.append('/');
            PatternEntry.appendQuoted(this.extension, toAddTo);
        }
    }

    static void appendQuoted(String chars, StringBuffer toAddTo) {
        boolean inQuote = false;
        char ch = chars.charAt(0);
        if (Character.isSpaceChar(ch)) {
            inQuote = true;
            toAddTo.append('\'');
        } else if (PatternEntry.isSpecialChar(ch)) {
            inQuote = true;
            toAddTo.append('\'');
        } else {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\u0010': 
                case '@': {
                    inQuote = true;
                    toAddTo.append('\'');
                    break;
                }
                case '\'': {
                    inQuote = true;
                    toAddTo.append('\'');
                    break;
                }
                default: {
                    if (!inQuote) break;
                    inQuote = false;
                    toAddTo.append('\'');
                }
            }
        }
        toAddTo.append(chars);
        if (inQuote) {
            toAddTo.append('\'');
        }
    }

    PatternEntry(int strength, StringBuffer chars, StringBuffer extension) {
        this.strength = strength;
        this.chars = chars.toString();
        this.extension = extension.length() > 0 ? extension.toString() : "";
    }

    static boolean isSpecialChar(char ch) {
        return ch == ' ' || ch <= '/' && ch >= '\"' || ch <= '?' && ch >= ':' || ch <= '`' && ch >= '[' || ch <= '~' && ch >= '{';
    }

    static class Parser {
        private String pattern;
        private int i;
        private StringBuffer newChars = new StringBuffer();
        private StringBuffer newExtension = new StringBuffer();

        public Parser(String pattern) {
            this.pattern = pattern;
            this.i = 0;
        }

        public PatternEntry next() throws ParseException {
            int newStrength = -1;
            this.newChars.setLength(0);
            this.newExtension.setLength(0);
            boolean inChars = true;
            boolean inQuote = false;
            block10: while (this.i < this.pattern.length()) {
                char ch = this.pattern.charAt(this.i);
                if (inQuote) {
                    if (ch == '\'') {
                        inQuote = false;
                    } else if (this.newChars.length() == 0) {
                        this.newChars.append(ch);
                    } else if (inChars) {
                        this.newChars.append(ch);
                    } else {
                        this.newExtension.append(ch);
                    }
                } else {
                    switch (ch) {
                        case '=': {
                            if (newStrength != -1) break block10;
                            newStrength = 3;
                            break;
                        }
                        case ',': {
                            if (newStrength != -1) break block10;
                            newStrength = 2;
                            break;
                        }
                        case ';': {
                            if (newStrength != -1) break block10;
                            newStrength = 1;
                            break;
                        }
                        case '<': {
                            if (newStrength != -1) break block10;
                            newStrength = 0;
                            break;
                        }
                        case '&': {
                            if (newStrength != -1) break block10;
                            newStrength = -2;
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case '/': {
                            inChars = false;
                            break;
                        }
                        case '\'': {
                            inQuote = true;
                            ch = this.pattern.charAt(++this.i);
                            if (this.newChars.length() == 0) {
                                this.newChars.append(ch);
                                break;
                            }
                            if (inChars) {
                                this.newChars.append(ch);
                                break;
                            }
                            this.newExtension.append(ch);
                            break;
                        }
                        default: {
                            if (newStrength == -1) {
                                throw new ParseException("missing char (=,;<&) : " + this.pattern.substring(this.i, this.i + 10 < this.pattern.length() ? this.i + 10 : this.pattern.length()), this.i);
                            }
                            if (PatternEntry.isSpecialChar(ch) && !inQuote) {
                                throw new ParseException("Unquoted punctuation character : " + Integer.toString(ch, 16), this.i);
                            }
                            if (inChars) {
                                this.newChars.append(ch);
                                break;
                            }
                            this.newExtension.append(ch);
                        }
                    }
                }
                ++this.i;
            }
            if (newStrength == -1) {
                return null;
            }
            if (this.newChars.length() == 0) {
                throw new ParseException("missing chars (=,;<&): " + this.pattern.substring(this.i, this.i + 10 < this.pattern.length() ? this.i + 10 : this.pattern.length()), this.i);
            }
            return new PatternEntry(newStrength, this.newChars, this.newExtension);
        }
    }
}

