/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public Vector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public Vector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public Vector() {
        this(10);
    }

    public Vector(Collection<? extends E> c) {
        Object[] a = c.toArray();
        this.elementCount = a.length;
        this.elementData = c.getClass() == ArrayList.class ? a : Arrays.copyOf(a, this.elementCount, Object[].class);
    }

    public synchronized void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount);
        }
    }

    public synchronized void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            ++this.modCount;
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (this.capacityIncrement > 0 ? this.capacityIncrement : oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = Vector.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public synchronized void setSize(int newSize) {
        ++this.modCount;
        if (newSize > this.elementCount) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.count < Vector.this.elementCount) {
                        return Vector.this.elementData(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o, 0) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    public synchronized int indexOf(Object o, int index) {
        if (o == null) {
            for (int i = index; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < this.elementCount; ++i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.lastIndexOf(o, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object o, int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized E elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData(index);
    }

    public synchronized E firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(0);
    }

    public synchronized E lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(this.elementCount - 1);
    }

    public synchronized void setElementAt(E obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public synchronized void removeElementAt(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public synchronized void insertElementAt(E obj, int index) {
        ++this.modCount;
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public synchronized void addElement(E obj) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    public synchronized boolean removeElement(Object obj) {
        ++this.modCount;
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            Vector v = (Vector)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.elementCount);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public synchronized Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.elementCount);
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        if (a.length < this.elementCount) {
            return Arrays.copyOf(this.elementData, this.elementCount, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        if (a.length > this.elementCount) {
            a[this.elementCount] = null;
        }
        return a;
    }

    E elementData(int index) {
        return (E)this.elementData[index];
    }

    @Override
    public synchronized E get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData(index);
    }

    @Override
    public synchronized E set(int index, E element) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public synchronized boolean add(E e) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = e;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeElement(o);
    }

    @Override
    public void add(int index, E element) {
        this.insertElementAt(element, index);
    }

    @Override
    public synchronized E remove(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        E oldValue = this.elementData(index);
        int numMoved = this.elementCount - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.elementCount] = null;
        return oldValue;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        ++this.modCount;
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        System.arraycopy(a, 0, this.elementData, this.elementCount, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        ++this.modCount;
        if (index < 0 || index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        int numMoved = this.elementCount - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized String toString() {
        return super.toString();
    }

    @Override
    public synchronized List<E> subList(int fromIndex, int toIndex) {
        return Collections.synchronizedList(super.subList(fromIndex, toIndex), this);
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.elementCount - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newElementCount = this.elementCount - (toIndex - fromIndex);
        while (this.elementCount != newElementCount) {
            this.elementData[--this.elementCount] = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        int count = gfields.get("elementCount", 0);
        Object[] data = (Object[])gfields.get("elementData", null);
        if (data == null && !gfields.defaulted("elementData") && count > 0) {
            throw new ClassNotFoundException("elementData is null");
        }
        if (count < 0 || data == null || count > data.length) {
            throw new StreamCorruptedException("Inconsistent vector internals");
        }
        this.elementCount = count;
        this.elementData = (Object[])data.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] data;
        ObjectOutputStream.PutField fields = s.putFields();
        Vector vector = this;
        synchronized (vector) {
            fields.put("capacityIncrement", this.capacityIncrement);
            fields.put("elementCount", this.elementCount);
            data = (Object[])this.elementData.clone();
        }
        fields.put("elementData", data);
        s.writeFields();
    }

    @Override
    public synchronized ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public synchronized void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] elementData = this.elementData;
        int elementCount = this.elementCount;
        for (int i = 0; this.modCount == expectedModCount && i < elementCount; ++i) {
            action.accept(elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public synchronized boolean removeIf(Predicate<? super E> filter) {
        boolean anyToRemove;
        Objects.requireNonNull(filter);
        int removeCount = 0;
        int size = this.elementCount;
        BitSet removeSet = new BitSet(size);
        int expectedModCount = this.modCount;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            Object element = this.elementData[i];
            if (!filter.test(element)) continue;
            removeSet.set(i);
            ++removeCount;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        boolean bl = anyToRemove = removeCount > 0;
        if (anyToRemove) {
            int newSize = size - removeCount;
            int i = 0;
            for (int j = 0; i < size && j < newSize; ++i, ++j) {
                i = removeSet.nextClearBit(i);
                this.elementData[j] = this.elementData[i];
            }
            for (int k = newSize; k < size; ++k) {
                this.elementData[k] = null;
            }
            this.elementCount = newSize;
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return anyToRemove;
    }

    @Override
    public synchronized void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        int expectedModCount = this.modCount;
        int size = this.elementCount;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            this.elementData[i] = operator.apply(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public synchronized void sort(Comparator<? super E> c) {
        int expectedModCount = this.modCount;
        Arrays.sort(this.elementData, 0, this.elementCount, c);
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public Spliterator<E> spliterator() {
        return new VectorSpliterator(this, null, 0, -1, 0);
    }

    static final class VectorSpliterator<E>
    implements Spliterator<E> {
        private final Vector<E> list;
        private Object[] array;
        private int index;
        private int fence;
        private int expectedModCount;

        VectorSpliterator(Vector<E> list, Object[] array, int origin, int fence, int expectedModCount) {
            this.list = list;
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                Vector<E> vector = this.list;
                synchronized (vector) {
                    this.array = this.list.elementData;
                    this.expectedModCount = this.list.modCount;
                    hi = this.fence = this.list.elementCount;
                }
            }
            return hi;
        }

        @Override
        public Spliterator<E> trySplit() {
            VectorSpliterator<E> vectorSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                vectorSpliterator = null;
            } else {
                this.index = mid;
                VectorSpliterator<E> vectorSpliterator2 = new VectorSpliterator<E>(this.list, this.array, lo, this.index, this.expectedModCount);
                vectorSpliterator = vectorSpliterator2;
            }
            return vectorSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            if (this.getFence() > i) {
                this.index = i + 1;
                action.accept(this.array[i]);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Vector<E> lst = this.list;
            if (lst != null) {
                int i;
                Object[] a;
                int hi = this.fence;
                if (hi < 0) {
                    Vector<E> vector = lst;
                    synchronized (vector) {
                        this.expectedModCount = lst.modCount;
                        this.array = lst.elementData;
                        a = lst.elementData;
                        hi = this.fence = lst.elementCount;
                    }
                } else {
                    a = this.array;
                }
                if (a != null && (i = this.index) >= 0 && (this.index = hi) <= a.length) {
                    while (i < hi) {
                        action.accept(a[i++]);
                    }
                    if (lst.modCount == this.expectedModCount) {
                        return;
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor - 1;
                if (i < 0) {
                    throw new NoSuchElementException();
                }
                this.cursor = i;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(E e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.set(this.lastRet, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(E e) {
            int i = this.cursor;
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.add(i, e);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = i + 1;
            this.lastRet = -1;
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = Vector.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Vector.this.elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                int i = this.cursor;
                if (i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                this.lastRet = i;
                return Vector.this.elementData(this.lastRet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            Vector vector = Vector.this;
            synchronized (vector) {
                this.checkForComodification();
                Vector.this.remove(this.lastRet);
                this.expectedModCount = Vector.this.modCount;
            }
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Vector vector = Vector.this;
            synchronized (vector) {
                int size = Vector.this.elementCount;
                int i = this.cursor;
                if (i >= size) {
                    return;
                }
                Object[] elementData = Vector.this.elementData;
                if (i >= elementData.length) {
                    throw new ConcurrentModificationException();
                }
                while (i != size && Vector.this.modCount == this.expectedModCount) {
                    action.accept(elementData[i++]);
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (Vector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

