/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipConstants;
import java.util.zip.ZipUtils;
import jdk.internal.misc.JavaUtilZipEntryAccess;
import jdk.internal.misc.SharedSecrets;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    long xdostime = -1L;
    FileTime mtime;
    FileTime atime;
    FileTime ctime;
    long crc = -1L;
    long size = -1L;
    long csize = -1L;
    int method = -1;
    int flag = 0;
    byte[] extra;
    String comment;
    int unixMode = 0;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    static final long DOSTIME_BEFORE_1980 = 0x210000L;
    private static final long UPPER_DOSTIME_BOUND = 4036608000000L;

    public ZipEntry(String name) {
        Objects.requireNonNull(name, "name");
        if (name.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry e) {
        Objects.requireNonNull(e, "entry");
        this.name = e.name;
        this.xdostime = e.xdostime;
        this.mtime = e.mtime;
        this.atime = e.atime;
        this.ctime = e.ctime;
        this.crc = e.crc;
        this.size = e.size;
        this.csize = e.csize;
        this.method = e.method;
        this.flag = e.flag;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    ZipEntry() {
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long time) {
        this.xdostime = ZipUtils.javaToExtendedDosTime(time);
        this.mtime = this.xdostime != 0x210000L && time <= 4036608000000L ? null : FileTime.from(time, TimeUnit.MILLISECONDS);
    }

    public long getTime() {
        if (this.mtime != null) {
            return this.mtime.toMillis();
        }
        return this.xdostime != -1L ? ZipUtils.extendedDosToJavaTime(this.xdostime) : -1L;
    }

    public ZipEntry setLastModifiedTime(FileTime time) {
        this.mtime = Objects.requireNonNull(time, "lastModifiedTime");
        this.xdostime = ZipUtils.javaToExtendedDosTime(time.to(TimeUnit.MILLISECONDS));
        return this;
    }

    public FileTime getLastModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        if (this.xdostime == -1L) {
            return null;
        }
        return FileTime.from(this.getTime(), TimeUnit.MILLISECONDS);
    }

    public ZipEntry setLastAccessTime(FileTime time) {
        this.atime = Objects.requireNonNull(time, "lastAccessTime");
        return this;
    }

    public FileTime getLastAccessTime() {
        return this.atime;
    }

    public ZipEntry setCreationTime(FileTime time) {
        this.ctime = Objects.requireNonNull(time, "creationTime");
        return this;
    }

    public FileTime getCreationTime() {
        return this.ctime;
    }

    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long csize) {
        this.csize = csize;
    }

    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] extra) {
        this.setExtra0(extra, false);
    }

    void setExtra0(byte[] extra, boolean doZIP64) {
        if (extra != null) {
            if (extra.length > 65535) {
                throw new IllegalArgumentException("invalid extra field length");
            }
            int off = 0;
            int len = extra.length;
            while (off + 4 < len) {
                int sz;
                int tag = ZipUtils.get16(extra, off);
                if ((off += 4) + (sz = ZipUtils.get16(extra, off + 2)) > len) break;
                switch (tag) {
                    case 1: {
                        if (!doZIP64 || sz < 16) break;
                        this.size = ZipUtils.get64(extra, off);
                        this.csize = ZipUtils.get64(extra, off + 8);
                        break;
                    }
                    case 10: {
                        int pos;
                        if (sz < 32 || ZipUtils.get16(extra, pos = off + 4) != 1 || ZipUtils.get16(extra, pos + 2) != 24) break;
                        this.mtime = ZipUtils.winTimeToFileTime(ZipUtils.get64(extra, pos + 4));
                        this.atime = ZipUtils.winTimeToFileTime(ZipUtils.get64(extra, pos + 12));
                        this.ctime = ZipUtils.winTimeToFileTime(ZipUtils.get64(extra, pos + 20));
                        break;
                    }
                    case 21589: {
                        int flag = Byte.toUnsignedInt(extra[off]);
                        int sz0 = 1;
                        if ((flag & 1) != 0 && sz0 + 4 <= sz) {
                            this.mtime = ZipUtils.unixTimeToFileTime(ZipUtils.get32(extra, off + sz0));
                            sz0 += 4;
                        }
                        if ((flag & 2) != 0 && sz0 + 4 <= sz) {
                            this.atime = ZipUtils.unixTimeToFileTime(ZipUtils.get32(extra, off + sz0));
                            sz0 += 4;
                        }
                        if ((flag & 4) == 0 || sz0 + 4 > sz) break;
                        this.ctime = ZipUtils.unixTimeToFileTime(ZipUtils.get32(extra, off + sz0));
                        sz0 += 4;
                        break;
                    }
                }
                off += sz;
            }
        }
        this.extra = extra;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Object clone() {
        try {
            ZipEntry e = (ZipEntry)super.clone();
            e.extra = this.extra == null ? null : (byte[])this.extra.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    static {
        SharedSecrets.setJavaUtilZipEntryAccess(new JavaUtilZipEntryAccess(){

            @Override
            public void setUnixMode(ZipEntry entry, int unixMode) {
                entry.unixMode = unixMode << 16 | ((unixMode & 0x80) != 0 ? 0 : 1) | (entry.isDirectory() ? 16 : 0);
            }

            @Override
            public int getUnixMode(ZipEntry entry) {
                return entry.unixMode >> 16 & 0xFFFF;
            }
        });
    }
}

