/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipUtils;
import sun.security.action.GetPropertyAction;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private static final boolean inhibitZip64 = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("jdk.util.zip.inhibitZip64", "false")));
    private XEntry current;
    private Vector<XEntry> xentries = new Vector();
    private HashSet<String> names = new HashSet();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long locoff = 0L;
    private byte[] comment;
    private int method = 8;
    private boolean finished;
    private boolean closed = false;
    private final ZipCoder zc;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private static int version(ZipEntry e) throws ZipException {
        switch (e.method) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        throw new ZipException("unsupported compression method");
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipOutputStream(OutputStream out) {
        this(out, StandardCharsets.UTF_8);
    }

    public ZipOutputStream(OutputStream out, Charset charset) {
        super(out, new Deflater(-1, true));
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
        this.usesDefaultDeflater = true;
    }

    public void setComment(String comment) {
        if (comment != null) {
            this.comment = this.zc.getBytes(comment);
            if (this.comment.length > 65535) {
                throw new IllegalArgumentException("ZIP file comment too long.");
            }
        }
    }

    public void setMethod(int method) {
        if (method != 8 && method != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = method;
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public void putNextEntry(ZipEntry e) throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            this.closeEntry();
        }
        if (e.xdostime == -1L) {
            e.setTime(System.currentTimeMillis());
        }
        if (e.method == -1) {
            e.method = this.method;
        }
        e.flag = 0;
        switch (e.method) {
            case 8: {
                if (e.size != -1L && e.csize != -1L && e.crc != -1L) break;
                e.flag = 8;
                break;
            }
            case 0: {
                if (e.size == -1L) {
                    e.size = e.csize;
                } else if (e.csize == -1L) {
                    e.csize = e.size;
                } else if (e.size != e.csize) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (e.size != -1L && e.crc != -1L) break;
                throw new ZipException("STORED entry missing size, compressed size, or crc-32");
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        if (!this.names.add(e.name)) {
            throw new ZipException("duplicate entry: " + e.name);
        }
        if (this.zc.isUTF8()) {
            e.flag |= 0x800;
        }
        this.current = new XEntry(e, this.written);
        this.xentries.add(this.current);
        this.writeLOC(this.current);
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            try {
                ZipEntry e = this.current.entry;
                switch (e.method) {
                    case 8: {
                        this.def.finish();
                        while (!this.def.finished()) {
                            this.deflate();
                        }
                        if ((e.flag & 8) == 0) {
                            if (e.size != this.def.getBytesRead()) {
                                throw new ZipException("invalid entry size (expected " + e.size + " but got " + this.def.getBytesRead() + " bytes)");
                            }
                            if (e.csize != this.def.getBytesWritten()) {
                                throw new ZipException("invalid entry compressed size (expected " + e.csize + " but got " + this.def.getBytesWritten() + " bytes)");
                            }
                            if (e.crc != this.crc.getValue()) {
                                throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                            }
                        } else {
                            e.size = this.def.getBytesRead();
                            e.csize = this.def.getBytesWritten();
                            e.crc = this.crc.getValue();
                            this.writeEXT(e);
                        }
                        this.def.reset();
                        this.written += e.csize;
                        break;
                    }
                    case 0: {
                        if (e.size != this.written - this.locoff) {
                            throw new ZipException("invalid entry size (expected " + e.size + " but got " + (this.written - this.locoff) + " bytes)");
                        }
                        if (e.crc == this.crc.getValue()) break;
                        throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                    }
                    default: {
                        throw new ZipException("invalid compression method");
                    }
                }
                this.crc.reset();
                this.current = null;
            }
            catch (IOException e) {
                if (this.def.shouldFinish() && this.usesDefaultDeflater && !(e instanceof ZipException)) {
                    this.def.end();
                }
                throw e;
            }
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.current == null) {
            throw new ZipException("no current ZIP entry");
        }
        ZipEntry entry = this.current.entry;
        switch (entry.method) {
            case 8: {
                super.write(b, off, len);
                break;
            }
            case 0: {
                this.written += (long)len;
                if (this.written - this.locoff > entry.size) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(b, off, len);
                break;
            }
            default: {
                throw new ZipException("invalid compression method");
            }
        }
        this.crc.update(b, off, len);
    }

    @Override
    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        long off = this.written;
        for (XEntry xentry : this.xentries) {
            this.writeCEN(xentry);
        }
        this.writeEND(off, this.written - off);
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private void writeLOC(XEntry xentry) throws IOException {
        ZipEntry e = xentry.entry;
        int flag = e.flag;
        boolean hasZip64 = false;
        int elen = this.getExtraLen(e.extra);
        this.writeInt(67324752L);
        if ((flag & 8) == 8) {
            this.writeShort(ZipOutputStream.version(e));
            this.writeShort(flag);
            this.writeShort(e.method);
            this.writeInt(e.xdostime);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            if (e.csize >= 0xFFFFFFFFL || e.size >= 0xFFFFFFFFL) {
                hasZip64 = true;
                this.writeShort(45);
            } else {
                this.writeShort(ZipOutputStream.version(e));
            }
            this.writeShort(flag);
            this.writeShort(e.method);
            this.writeInt(e.xdostime);
            this.writeInt(e.crc);
            if (hasZip64) {
                this.writeInt(0xFFFFFFFFL);
                this.writeInt(0xFFFFFFFFL);
                elen += 20;
            } else {
                this.writeInt(e.csize);
                this.writeInt(e.size);
            }
        }
        byte[] nameBytes = this.zc.getBytes(e.name);
        this.writeShort(nameBytes.length);
        int elenEXTT = 0;
        int flagEXTT = 0;
        if (e.mtime != null) {
            elenEXTT += 4;
            flagEXTT |= 1;
        }
        if (e.atime != null) {
            elenEXTT += 4;
            flagEXTT |= 2;
        }
        if (e.ctime != null) {
            elenEXTT += 4;
            flagEXTT |= 4;
        }
        if (flagEXTT != 0) {
            elen += elenEXTT + 5;
        }
        this.writeShort(elen);
        this.writeBytes(nameBytes, 0, nameBytes.length);
        if (hasZip64) {
            this.writeShort(1);
            this.writeShort(16);
            this.writeLong(e.size);
            this.writeLong(e.csize);
        }
        if (flagEXTT != 0) {
            this.writeShort(21589);
            this.writeShort(elenEXTT + 1);
            this.writeByte(flagEXTT);
            if (e.mtime != null) {
                this.writeInt(ZipUtils.fileTimeToUnixTime(e.mtime));
            }
            if (e.atime != null) {
                this.writeInt(ZipUtils.fileTimeToUnixTime(e.atime));
            }
            if (e.ctime != null) {
                this.writeInt(ZipUtils.fileTimeToUnixTime(e.ctime));
            }
        }
        this.writeExtra(e.extra);
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry e) throws IOException {
        this.writeInt(134695760L);
        this.writeInt(e.crc);
        if (e.csize >= 0xFFFFFFFFL || e.size >= 0xFFFFFFFFL) {
            this.writeLong(e.csize);
            this.writeLong(e.size);
        } else {
            this.writeInt(e.csize);
            this.writeInt(e.size);
        }
    }

    private void writeCEN(XEntry xentry) throws IOException {
        byte[] commentBytes;
        ZipEntry e = xentry.entry;
        int flag = e.flag;
        int version = ZipOutputStream.version(e);
        long csize = e.csize;
        long size = e.size;
        long offset = xentry.offset;
        int elenZIP64 = 0;
        boolean hasZip64 = false;
        if (e.csize >= 0xFFFFFFFFL) {
            csize = 0xFFFFFFFFL;
            elenZIP64 += 8;
            hasZip64 = true;
        }
        if (e.size >= 0xFFFFFFFFL) {
            size = 0xFFFFFFFFL;
            elenZIP64 += 8;
            hasZip64 = true;
        }
        if (xentry.offset >= 0xFFFFFFFFL) {
            offset = 0xFFFFFFFFL;
            elenZIP64 += 8;
            hasZip64 = true;
        }
        this.writeInt(33639248L);
        if (hasZip64) {
            this.writeShort(45);
            this.writeShort(45);
        } else if (e.unixMode != 0) {
            this.writeShort(788);
            this.writeShort(version);
        } else {
            this.writeShort(version);
            this.writeShort(version);
        }
        this.writeShort(flag);
        this.writeShort(e.method);
        this.writeInt(e.xdostime);
        this.writeInt(e.crc);
        this.writeInt(csize);
        this.writeInt(size);
        byte[] nameBytes = this.zc.getBytes(e.name);
        this.writeShort(nameBytes.length);
        int elen = this.getExtraLen(e.extra);
        if (hasZip64) {
            elen += elenZIP64 + 4;
        }
        int flagEXTT = 0;
        if (e.mtime != null) {
            elen += 4;
            flagEXTT |= 1;
        }
        if (e.atime != null) {
            flagEXTT |= 2;
        }
        if (e.ctime != null) {
            flagEXTT |= 4;
        }
        if (flagEXTT != 0) {
            elen += 5;
        }
        this.writeShort(elen);
        if (e.comment != null) {
            commentBytes = this.zc.getBytes(e.comment);
            this.writeShort(Math.min(commentBytes.length, 65535));
        } else {
            commentBytes = null;
            this.writeShort(0);
        }
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(e.unixMode);
        this.writeInt(offset);
        this.writeBytes(nameBytes, 0, nameBytes.length);
        if (hasZip64) {
            this.writeShort(1);
            this.writeShort(elenZIP64);
            if (size == 0xFFFFFFFFL) {
                this.writeLong(e.size);
            }
            if (csize == 0xFFFFFFFFL) {
                this.writeLong(e.csize);
            }
            if (offset == 0xFFFFFFFFL) {
                this.writeLong(xentry.offset);
            }
        }
        if (flagEXTT != 0) {
            this.writeShort(21589);
            if (e.mtime != null) {
                this.writeShort(5);
                this.writeByte(flagEXTT);
                this.writeInt(ZipUtils.fileTimeToUnixTime(e.mtime));
            } else {
                this.writeShort(1);
                this.writeByte(flagEXTT);
            }
        }
        this.writeExtra(e.extra);
        if (commentBytes != null) {
            this.writeBytes(commentBytes, 0, Math.min(commentBytes.length, 65535));
        }
    }

    private void writeEND(long off, long len) throws IOException {
        int count;
        boolean hasZip64 = false;
        long xlen = len;
        long xoff = off;
        if (xlen >= 0xFFFFFFFFL) {
            xlen = 0xFFFFFFFFL;
            hasZip64 = true;
        }
        if (xoff >= 0xFFFFFFFFL) {
            xoff = 0xFFFFFFFFL;
            hasZip64 = true;
        }
        if ((count = this.xentries.size()) >= 65535 && (hasZip64 |= !inhibitZip64)) {
            count = 65535;
        }
        if (hasZip64) {
            long off64 = this.written;
            this.writeInt(101075792L);
            this.writeLong(44L);
            this.writeShort(45);
            this.writeShort(45);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeLong(this.xentries.size());
            this.writeLong(this.xentries.size());
            this.writeLong(len);
            this.writeLong(off);
            this.writeInt(117853008L);
            this.writeInt(0L);
            this.writeLong(off64);
            this.writeInt(1L);
        }
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(count);
        this.writeShort(count);
        this.writeInt(xlen);
        this.writeInt(xoff);
        if (this.comment != null) {
            this.writeShort(this.comment.length);
            this.writeBytes(this.comment, 0, this.comment.length);
        } else {
            this.writeShort(0);
        }
    }

    private int getExtraLen(byte[] extra) {
        if (extra == null) {
            return 0;
        }
        int skipped = 0;
        int len = extra.length;
        int off = 0;
        while (off + 4 <= len) {
            int tag = ZipUtils.get16(extra, off);
            int sz = ZipUtils.get16(extra, off + 2);
            if (sz < 0 || off + 4 + sz > len) break;
            if (tag == 21589 || tag == 1) {
                skipped += sz + 4;
            }
            off += sz + 4;
        }
        return len - skipped;
    }

    private void writeExtra(byte[] extra) throws IOException {
        if (extra != null) {
            int len = extra.length;
            int off = 0;
            while (off + 4 <= len) {
                int tag = ZipUtils.get16(extra, off);
                int sz = ZipUtils.get16(extra, off + 2);
                if (sz < 0 || off + 4 + sz > len) {
                    this.writeBytes(extra, off, len - off);
                    return;
                }
                if (tag != 21589 && tag != 1) {
                    this.writeBytes(extra, off, sz + 4);
                }
                off += sz + 4;
            }
            if (off < len) {
                this.writeBytes(extra, off, len - off);
            }
        }
    }

    private void writeByte(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v & 0xFF);
        ++this.written;
    }

    private void writeShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.written += 2L;
    }

    private void writeInt(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0 & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
        this.written += 4L;
    }

    private void writeLong(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0 & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
        out.write((int)(v >>> 32 & 0xFFL));
        out.write((int)(v >>> 40 & 0xFFL));
        out.write((int)(v >>> 48 & 0xFFL));
        out.write((int)(v >>> 56 & 0xFFL));
        this.written += 8L;
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += (long)len;
    }

    private static class XEntry {
        final ZipEntry entry;
        final long offset;

        public XEntry(ZipEntry entry, long offset) {
            this.entry = entry;
            this.offset = offset;
        }
    }
}

