/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

public class ObjectName
implements Comparable<ObjectName>,
QueryExp {
    private static final long oldSerialVersionUID = -5467795090068647408L;
    private static final long newSerialVersionUID = 1081892073854801359L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", String.class), new ObjectStreamField("propertyList", Hashtable.class), new ObjectStreamField("propertyListString", String.class), new ObjectStreamField("canonicalName", String.class), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private static final Property[] _Empty_property_array;
    private transient String _canonicalName;
    private transient Property[] _kp_array;
    private transient Property[] _ca_array;
    private transient int _domain_length = 0;
    private transient Map<String, String> _propertyList;
    private transient boolean _domain_pattern = false;
    private transient boolean _property_list_pattern = false;
    private transient boolean _property_value_pattern = false;
    public static final ObjectName WILDCARD;

    private void construct(String name) throws MalformedObjectNameException {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (name.length() == 0) {
            this._canonicalName = "*:*";
            this._kp_array = _Empty_property_array;
            this._ca_array = _Empty_property_array;
            this._domain_length = 1;
            this._propertyList = null;
            this._domain_pattern = true;
            this._property_list_pattern = true;
            this._property_value_pattern = false;
            return;
        }
        char[] name_chars = name.toCharArray();
        int len = name_chars.length;
        char[] canonical_chars = new char[len];
        int cname_index = 0;
        int index = 0;
        block19: while (index < len) {
            switch (name_chars[index]) {
                case ':': {
                    this._domain_length = index++;
                    break block19;
                }
                case '=': {
                    int i = ++index;
                    while (i < len && name_chars[i++] != ':') {
                        if (i != len) continue;
                        throw new MalformedObjectNameException("Domain part must be specified");
                    }
                    continue block19;
                }
                case '\n': {
                    throw new MalformedObjectNameException("Invalid character '\\n' in domain name");
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                    ++index;
                    continue block19;
                }
                default: {
                    ++index;
                    continue block19;
                }
            }
        }
        if (index == len) {
            throw new MalformedObjectNameException("Key properties cannot be empty");
        }
        System.arraycopy(name_chars, 0, canonical_chars, 0, this._domain_length);
        canonical_chars[this._domain_length] = 58;
        cname_index = this._domain_length + 1;
        HashMap<String, Property> keys_map = new HashMap<String, Property>();
        int property_index = 0;
        String[] keys = new String[10];
        this._kp_array = new Property[10];
        this._property_list_pattern = false;
        this._property_value_pattern = false;
        while (index < len) {
            Property prop;
            int value_length;
            boolean quoted_value;
            char c1;
            int in_index;
            char c = name_chars[index];
            if (c == '*') {
                if (this._property_list_pattern) {
                    throw new MalformedObjectNameException("Cannot have several '*' characters in pattern property list");
                }
                this._property_list_pattern = true;
                if (++index < len && name_chars[index] != ',') {
                    throw new MalformedObjectNameException("Invalid character found after '*': end of name or ',' expected");
                }
                if (index == len) {
                    if (property_index != 0) break;
                    this._kp_array = _Empty_property_array;
                    this._ca_array = _Empty_property_array;
                    this._propertyList = Collections.emptyMap();
                    break;
                }
                ++index;
                continue;
            }
            int key_index = in_index = index;
            if (name_chars[in_index] == '=') {
                throw new MalformedObjectNameException("Invalid key (empty)");
            }
            while (in_index < len && (c1 = name_chars[in_index++]) != '=') {
                switch (c1) {
                    case '\n': 
                    case '*': 
                    case ',': 
                    case ':': 
                    case '?': {
                        String ichar = c1 == '\n' ? "\\n" : "" + c1;
                        throw new MalformedObjectNameException("Invalid character '" + ichar + "' in key part of property");
                    }
                }
            }
            if (name_chars[in_index - 1] != '=') {
                throw new MalformedObjectNameException("Unterminated key property part");
            }
            int value_index = in_index;
            int key_length = value_index - key_index - 1;
            boolean value_pattern = false;
            if (in_index < len && name_chars[in_index] == '\"') {
                quoted_value = true;
                block23: while (++in_index < len && (c1 = name_chars[in_index]) != '\"') {
                    if (c1 == '\\') {
                        if (++in_index == len) {
                            throw new MalformedObjectNameException("Unterminated quoted value");
                        }
                        c1 = name_chars[in_index];
                        switch (c1) {
                            case '\"': 
                            case '*': 
                            case '?': 
                            case '\\': 
                            case 'n': {
                                continue block23;
                            }
                        }
                        throw new MalformedObjectNameException("Invalid escape sequence '\\" + c1 + "' in quoted value");
                    }
                    if (c1 == '\n') {
                        throw new MalformedObjectNameException("Newline in quoted value");
                    }
                    switch (c1) {
                        case '*': 
                        case '?': {
                            value_pattern = true;
                        }
                    }
                }
                if (in_index == len) {
                    throw new MalformedObjectNameException("Unterminated quoted value");
                }
                value_length = ++in_index - value_index;
            } else {
                quoted_value = false;
                block24: while (in_index < len && (c1 = name_chars[in_index]) != ',') {
                    switch (c1) {
                        case '*': 
                        case '?': {
                            value_pattern = true;
                            ++in_index;
                            continue block24;
                        }
                        case '\n': 
                        case '\"': 
                        case ':': 
                        case '=': {
                            String ichar = c1 == '\n' ? "\\n" : "" + c1;
                            throw new MalformedObjectNameException("Invalid character '" + ichar + "' in value part of property");
                        }
                    }
                    ++in_index;
                }
                value_length = in_index - value_index;
            }
            if (in_index == len - 1) {
                if (quoted_value) {
                    throw new MalformedObjectNameException("Invalid ending character `" + name_chars[in_index] + "'");
                }
                throw new MalformedObjectNameException("Invalid ending comma");
            }
            ++in_index;
            if (!value_pattern) {
                prop = new Property(key_index, key_length, value_length);
            } else {
                this._property_value_pattern = true;
                prop = new PatternProperty(key_index, key_length, value_length);
            }
            String key_name = name.substring(key_index, key_index + key_length).intern();
            if (property_index == keys.length) {
                String[] tmp_string_array = new String[property_index + 10];
                System.arraycopy(keys, 0, tmp_string_array, 0, property_index);
                keys = tmp_string_array;
            }
            keys[property_index] = key_name;
            this.addProperty(prop, property_index, keys_map, key_name);
            ++property_index;
            index = in_index;
        }
        this.setCanonicalName(name_chars, canonical_chars, keys, keys_map, cname_index, property_index);
    }

    private void construct(String domain, Map<String, String> props) throws MalformedObjectNameException {
        if (domain == null) {
            throw new NullPointerException("domain cannot be null");
        }
        if (props == null) {
            throw new NullPointerException("key property list cannot be null");
        }
        if (props.isEmpty()) {
            throw new MalformedObjectNameException("key property list cannot be empty");
        }
        if (!this.isDomain(domain)) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(domain).append(':');
        this._domain_length = domain.length();
        int nb_props = props.size();
        this._kp_array = new Property[nb_props];
        String[] keys = new String[nb_props];
        HashMap<String, Property> keys_map = new HashMap<String, Property>();
        int i = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Property prop;
            String value;
            if (sb.length() > 0) {
                sb.append(",");
            }
            String key = entry.getKey();
            try {
                value = entry.getValue();
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException(e.getMessage());
            }
            int key_index = sb.length();
            ObjectName.checkKey(key);
            sb.append(key);
            keys[i] = key;
            sb.append("=");
            boolean value_pattern = ObjectName.checkValue(value);
            sb.append(value);
            if (!value_pattern) {
                prop = new Property(key_index, key.length(), value.length());
            } else {
                this._property_value_pattern = true;
                prop = new PatternProperty(key_index, key.length(), value.length());
            }
            this.addProperty(prop, i, keys_map, key);
            ++i;
        }
        int len = sb.length();
        char[] initial_chars = new char[len];
        sb.getChars(0, len, initial_chars, 0);
        char[] canonical_chars = new char[len];
        System.arraycopy(initial_chars, 0, canonical_chars, 0, this._domain_length + 1);
        this.setCanonicalName(initial_chars, canonical_chars, keys, keys_map, this._domain_length + 1, this._kp_array.length);
    }

    private void addProperty(Property prop, int index, Map<String, Property> keys_map, String key_name) throws MalformedObjectNameException {
        if (keys_map.containsKey(key_name)) {
            throw new MalformedObjectNameException("key `" + key_name + "' already defined");
        }
        if (index == this._kp_array.length) {
            Property[] tmp_prop_array = new Property[index + 10];
            System.arraycopy(this._kp_array, 0, tmp_prop_array, 0, index);
            this._kp_array = tmp_prop_array;
        }
        this._kp_array[index] = prop;
        keys_map.put(key_name, prop);
    }

    private void setCanonicalName(char[] specified_chars, char[] canonical_chars, String[] keys, Map<String, Property> keys_map, int prop_index, int nb_props) {
        if (this._kp_array != _Empty_property_array) {
            Object[] tmp_keys = new String[nb_props];
            Property[] tmp_props = new Property[nb_props];
            System.arraycopy(keys, 0, tmp_keys, 0, nb_props);
            Arrays.sort(tmp_keys);
            keys = tmp_keys;
            System.arraycopy(this._kp_array, 0, tmp_props, 0, nb_props);
            this._kp_array = tmp_props;
            this._ca_array = new Property[nb_props];
            for (int i = 0; i < nb_props; ++i) {
                this._ca_array[i] = keys_map.get(keys[i]);
            }
            int last_index = nb_props - 1;
            for (int i = 0; i <= last_index; ++i) {
                Property prop = this._ca_array[i];
                int prop_len = prop._key_length + prop._value_length + 1;
                System.arraycopy(specified_chars, prop._key_index, canonical_chars, prop_index, prop_len);
                prop.setKeyIndex(prop_index);
                prop_index += prop_len;
                if (i == last_index) continue;
                canonical_chars[prop_index] = 44;
                ++prop_index;
            }
        }
        if (this._property_list_pattern) {
            if (this._kp_array != _Empty_property_array) {
                canonical_chars[prop_index++] = 44;
            }
            canonical_chars[prop_index++] = 42;
        }
        this._canonicalName = new String(canonical_chars, 0, prop_index).intern();
    }

    private static int parseKey(char[] s, int startKey) throws MalformedObjectNameException {
        int next = startKey;
        int endKey = startKey;
        int len = s.length;
        block4: while (next < len) {
            char k = s[next++];
            switch (k) {
                case '\n': 
                case '*': 
                case ',': 
                case ':': 
                case '?': {
                    String ichar = k == '\n' ? "\\n" : "" + k;
                    throw new MalformedObjectNameException("Invalid character in key: `" + ichar + "'");
                }
                case '=': {
                    endKey = next - 1;
                    break block4;
                }
                default: {
                    if (next < len) continue block4;
                    endKey = next;
                    break block4;
                }
            }
        }
        return endKey;
    }

    private static int[] parseValue(char[] s, int startValue) throws MalformedObjectNameException {
        int endValue;
        boolean value_pattern;
        block23: {
            int len;
            int next;
            block20: {
                value_pattern = false;
                next = startValue;
                endValue = startValue;
                len = s.length;
                char q = s[startValue];
                if (q != '\"') break block20;
                if (++next == len) {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                while (next < len) {
                    char last;
                    block22: {
                        block21: {
                            last = s[next];
                            if (last != '\\') break block21;
                            if (++next == len) {
                                throw new MalformedObjectNameException("Invalid unterminated quoted character sequence");
                            }
                            last = s[next];
                            switch (last) {
                                case '*': 
                                case '?': 
                                case '\\': 
                                case 'n': {
                                    break block22;
                                }
                                case '\"': {
                                    if (next + 1 == len) {
                                        throw new MalformedObjectNameException("Missing termination quote");
                                    }
                                    break block22;
                                }
                                default: {
                                    throw new MalformedObjectNameException("Invalid quoted character sequence '\\" + last + "'");
                                }
                            }
                        }
                        if (last == '\n') {
                            throw new MalformedObjectNameException("Newline in quoted value");
                        }
                        if (last == '\"') {
                            ++next;
                            break;
                        }
                        switch (last) {
                            case '*': 
                            case '?': {
                                value_pattern = true;
                            }
                        }
                    }
                    if (++next < len || last == '\"') continue;
                    throw new MalformedObjectNameException("Missing termination quote");
                }
                endValue = next;
                if (next < len && s[next++] != ',') {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                break block23;
            }
            block13: while (next < len) {
                char v = s[next++];
                switch (v) {
                    case '*': 
                    case '?': {
                        value_pattern = true;
                        if (next < len) continue block13;
                        endValue = next;
                        break block13;
                    }
                    case '\n': 
                    case ':': 
                    case '=': {
                        String ichar = v == '\n' ? "\\n" : "" + v;
                        throw new MalformedObjectNameException("Invalid character `" + ichar + "' in value");
                    }
                    case ',': {
                        endValue = next - 1;
                        break block13;
                    }
                    default: {
                        if (next < len) continue block13;
                        endValue = next;
                        break block13;
                    }
                }
            }
        }
        return new int[]{endValue, value_pattern ? 1 : 0};
    }

    private static boolean checkValue(String val) throws MalformedObjectNameException {
        boolean value_pattern;
        if (val == null) {
            throw new NullPointerException("Invalid value (null)");
        }
        int len = val.length();
        if (len == 0) {
            return false;
        }
        char[] s = val.toCharArray();
        int[] result = ObjectName.parseValue(s, 0);
        int endValue = result[0];
        boolean bl = value_pattern = result[1] == 1;
        if (endValue < len) {
            throw new MalformedObjectNameException("Invalid character in value: `" + s[endValue] + "'");
        }
        return value_pattern;
    }

    private static void checkKey(String key) throws MalformedObjectNameException {
        if (key == null) {
            throw new NullPointerException("Invalid key (null)");
        }
        int len = key.length();
        if (len == 0) {
            throw new MalformedObjectNameException("Invalid key (empty)");
        }
        char[] k = key.toCharArray();
        int endKey = ObjectName.parseKey(k, 0);
        if (endKey < len) {
            throw new MalformedObjectNameException("Invalid character in value: `" + k[endKey] + "'");
        }
    }

    private boolean isDomain(String domain) {
        if (domain == null) {
            return true;
        }
        int len = domain.length();
        int next = 0;
        while (next < len) {
            char c = domain.charAt(next++);
            switch (c) {
                case '\n': 
                case ':': {
                    return false;
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String cn;
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            String propListString = (String)fields.get("propertyListString", "");
            boolean propPattern = fields.get("propertyPattern", false);
            if (propPattern) {
                propListString = propListString.length() == 0 ? "*" : propListString + ",*";
            }
            cn = (String)fields.get("domain", "default") + ":" + propListString;
        } else {
            in.defaultReadObject();
            cn = (String)in.readObject();
        }
        try {
            this.construct(cn);
        }
        catch (NullPointerException e) {
            throw new InvalidObjectException(e.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidObjectException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("domain", this._canonicalName.substring(0, this._domain_length));
            fields.put("propertyList", this.getKeyPropertyList());
            fields.put("propertyListString", this.getKeyPropertyListString());
            fields.put("canonicalName", this._canonicalName);
            fields.put("pattern", this._domain_pattern || this._property_list_pattern);
            fields.put("propertyPattern", this._property_list_pattern);
            out.writeFields();
        } else {
            out.defaultWriteObject();
            out.writeObject(this.getSerializedNameString());
        }
    }

    public static ObjectName getInstance(String name) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException {
        return new ObjectName(domain, key, value);
    }

    public static ObjectName getInstance(String domain, Hashtable<String, String> table) throws MalformedObjectNameException {
        return new ObjectName(domain, table);
    }

    public static ObjectName getInstance(ObjectName name) {
        if (name.getClass().equals(ObjectName.class)) {
            return name;
        }
        return Util.newObjectName(name.getSerializedNameString());
    }

    public ObjectName(String name) throws MalformedObjectNameException {
        this.construct(name);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        Map<String, String> table = Collections.singletonMap(key, value);
        this.construct(domain, table);
    }

    public ObjectName(String domain, Hashtable<String, String> table) throws MalformedObjectNameException {
        this.construct(domain, table);
    }

    public boolean isPattern() {
        return this._domain_pattern || this._property_list_pattern || this._property_value_pattern;
    }

    public boolean isDomainPattern() {
        return this._domain_pattern;
    }

    public boolean isPropertyPattern() {
        return this._property_list_pattern || this._property_value_pattern;
    }

    public boolean isPropertyListPattern() {
        return this._property_list_pattern;
    }

    public boolean isPropertyValuePattern() {
        return this._property_value_pattern;
    }

    public boolean isPropertyValuePattern(String property) {
        if (property == null) {
            throw new NullPointerException("key property can't be null");
        }
        for (int i = 0; i < this._ca_array.length; ++i) {
            Property prop = this._ca_array[i];
            String key = prop.getKeyString(this._canonicalName);
            if (!key.equals(property)) continue;
            return prop instanceof PatternProperty;
        }
        throw new IllegalArgumentException("key property not found");
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public String getDomain() {
        return this._canonicalName.substring(0, this._domain_length).intern();
    }

    public String getKeyProperty(String property) {
        return this._getKeyPropertyList().get(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> _getKeyPropertyList() {
        ObjectName objectName = this;
        synchronized (objectName) {
            if (this._propertyList == null) {
                this._propertyList = new HashMap<String, String>();
                int len = this._ca_array.length;
                for (int i = len - 1; i >= 0; --i) {
                    Property prop = this._ca_array[i];
                    this._propertyList.put(prop.getKeyString(this._canonicalName), prop.getValueString(this._canonicalName));
                }
            }
        }
        return this._propertyList;
    }

    public Hashtable<String, String> getKeyPropertyList() {
        return new Hashtable<String, String>(this._getKeyPropertyList());
    }

    public String getKeyPropertyListString() {
        if (this._kp_array.length == 0) {
            return "";
        }
        int total_size = this._canonicalName.length() - this._domain_length - 1 - (this._property_list_pattern ? 2 : 0);
        char[] dest_chars = new char[total_size];
        char[] value = this._canonicalName.toCharArray();
        this.writeKeyPropertyListString(value, dest_chars, 0);
        return new String(dest_chars);
    }

    private String getSerializedNameString() {
        int total_size = this._canonicalName.length();
        char[] dest_chars = new char[total_size];
        char[] value = this._canonicalName.toCharArray();
        int offset = this._domain_length + 1;
        System.arraycopy(value, 0, dest_chars, 0, offset);
        int end = this.writeKeyPropertyListString(value, dest_chars, offset);
        if (this._property_list_pattern) {
            if (end == offset) {
                dest_chars[end] = 42;
            } else {
                dest_chars[end] = 44;
                dest_chars[end + 1] = 42;
            }
        }
        return new String(dest_chars);
    }

    private int writeKeyPropertyListString(char[] canonicalChars, char[] data, int offset) {
        if (this._kp_array.length == 0) {
            return offset;
        }
        char[] dest_chars = data;
        char[] value = canonicalChars;
        int index = offset;
        int len = this._kp_array.length;
        int last = len - 1;
        for (int i = 0; i < len; ++i) {
            Property prop = this._kp_array[i];
            int prop_len = prop._key_length + prop._value_length + 1;
            System.arraycopy(value, prop._key_index, dest_chars, index, prop_len);
            index += prop_len;
            if (i >= last) continue;
            dest_chars[index++] = 44;
        }
        return index;
    }

    public String getCanonicalKeyPropertyListString() {
        if (this._ca_array.length == 0) {
            return "";
        }
        int len = this._canonicalName.length();
        if (this._property_list_pattern) {
            len -= 2;
        }
        return this._canonicalName.substring(this._domain_length + 1, len);
    }

    public String toString() {
        return this.getSerializedNameString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName on = (ObjectName)object;
        String on_string = on._canonicalName;
        return this._canonicalName == on_string;
    }

    public int hashCode() {
        return this._canonicalName.hashCode();
    }

    public static String quote(String s) {
        StringBuilder buf = new StringBuilder("\"");
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                    buf.append('\\');
                    break;
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    buf.append('\\');
                }
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String unquote(String q) {
        StringBuilder buf = new StringBuilder();
        int len = q.length();
        if (len < 2 || q.charAt(0) != '\"' || q.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException("Argument not quoted");
        }
        for (int i = 1; i < len - 1; ++i) {
            char c;
            block11: {
                block10: {
                    c = q.charAt(i);
                    if (c != '\\') break block10;
                    if (i == len - 2) {
                        throw new IllegalArgumentException("Trailing backslash");
                    }
                    c = q.charAt(++i);
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break block11;
                        }
                        case '\"': 
                        case '*': 
                        case '?': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad character '" + c + "' after backslash");
                        }
                    }
                }
                switch (c) {
                    case '\n': 
                    case '\"': 
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("Invalid unescaped character '" + c + "' in the string to unquote");
                    }
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    public boolean apply(ObjectName name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name._domain_pattern || name._property_list_pattern || name._property_value_pattern) {
            return false;
        }
        if (!(this._domain_pattern || this._property_list_pattern || this._property_value_pattern)) {
            return this._canonicalName.equals(name._canonicalName);
        }
        return this.matchDomains(name) && this.matchKeys(name);
    }

    private final boolean matchDomains(ObjectName name) {
        if (this._domain_pattern) {
            return Util.wildmatch(name.getDomain(), this.getDomain());
        }
        return this.getDomain().equals(name.getDomain());
    }

    private final boolean matchKeys(ObjectName name) {
        if (this._property_value_pattern && !this._property_list_pattern && name._ca_array.length != this._ca_array.length) {
            return false;
        }
        if (this._property_value_pattern || this._property_list_pattern) {
            Map<String, String> nameProps = name._getKeyPropertyList();
            Property[] props = this._ca_array;
            String cn = this._canonicalName;
            for (int i = props.length - 1; i >= 0; --i) {
                Property p = props[i];
                String k = p.getKeyString(cn);
                String v = nameProps.get(k);
                if (v == null) {
                    return false;
                }
                if (this._property_value_pattern && p instanceof PatternProperty) {
                    if (Util.wildmatch(v, p.getValueString(cn))) continue;
                    return false;
                }
                if (v.equals(p.getValueString(cn))) continue;
                return false;
            }
            return true;
        }
        String p1 = name.getCanonicalKeyPropertyListString();
        String p2 = this.getCanonicalKeyPropertyListString();
        return p1.equals(p2);
    }

    @Override
    public void setMBeanServer(MBeanServer mbs) {
    }

    @Override
    public int compareTo(ObjectName name) {
        int typeKeyValue;
        if (name == this) {
            return 0;
        }
        int domainValue = this.getDomain().compareTo(name.getDomain());
        if (domainValue != 0) {
            return domainValue;
        }
        String thisTypeKey = this.getKeyProperty("type");
        String anotherTypeKey = name.getKeyProperty("type");
        if (thisTypeKey == null) {
            thisTypeKey = "";
        }
        if (anotherTypeKey == null) {
            anotherTypeKey = "";
        }
        if ((typeKeyValue = thisTypeKey.compareTo(anotherTypeKey)) != 0) {
            return typeKeyValue;
        }
        return this.getCanonicalName().compareTo(name.getCanonicalName());
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5467795090068647408L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 1081892073854801359L;
        }
        _Empty_property_array = new Property[0];
        WILDCARD = Util.newObjectName("*:*");
    }

    private static class PatternProperty
    extends Property {
        PatternProperty(int key_index, int key_length, int value_length) {
            super(key_index, key_length, value_length);
        }
    }

    private static class Property {
        int _key_index;
        int _key_length;
        int _value_length;

        Property(int key_index, int key_length, int value_length) {
            this._key_index = key_index;
            this._key_length = key_length;
            this._value_length = value_length;
        }

        void setKeyIndex(int key_index) {
            this._key_index = key_index;
        }

        String getKeyString(String name) {
            return name.substring(this._key_index, this._key_index + this._key_length).intern();
        }

        String getValueString(String name) {
            int in_begin = this._key_index + this._key_length + 1;
            int out_end = in_begin + this._value_length;
            return name.substring(in_begin, out_end).intern();
        }
    }
}

