/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import javax.management.loading.MLetObjectInputStream;
import javax.management.loading.MLetParser;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private static final long serialVersionUID = 3636148327800330130L;
    private MBeanServer server = null;
    private List<MLetContent> mletList = new ArrayList<MLetContent>();
    private String libraryDirectory;
    private ObjectName mletObjectName = null;
    private URL[] myUrls = null;
    private transient ClassLoaderRepository currentClr;
    private transient boolean delegateToCLR;
    private Map<String, Class<?>> primitiveClasses = new HashMap(8);

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] urls) {
        this(urls, true);
    }

    public MLet(URL[] urls, ClassLoader parent) {
        this(urls, parent, true);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(urls, parent, factory, true);
    }

    public MLet(URL[] urls, boolean delegateToCLR) {
        super(urls);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(delegateToCLR);
    }

    public MLet(URL[] urls, ClassLoader parent, boolean delegateToCLR) {
        super(urls, parent);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(delegateToCLR);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory, boolean delegateToCLR) {
        super(urls, parent, factory);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(delegateToCLR);
    }

    private void init(boolean delegateToCLR) {
        this.delegateToCLR = delegateToCLR;
        try {
            this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
            if (this.libraryDirectory == null) {
                this.libraryDirectory = this.getTmpDir();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void addURL(URL url) {
        if (!Arrays.asList(this.getURLs()).contains(url)) {
            super.addURL(url);
        }
    }

    @Override
    public void addURL(String url) throws ServiceNotFoundException {
        try {
            URL ur = new URL(url);
            if (!Arrays.asList(this.getURLs()).contains(ur)) {
                super.addURL(ur);
            }
        }
        catch (MalformedURLException e) {
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "addUrl", "Malformed URL: " + url, e);
            }
            throw new ServiceNotFoundException("The specified URL is malformed");
        }
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    @Override
    public Set<Object> getMBeansFromURL(URL url) throws ServiceNotFoundException {
        if (url == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        return this.getMBeansFromURL(url.toString());
    }

    @Override
    public Set<Object> getMBeansFromURL(String url) throws ServiceNotFoundException {
        String mth = "getMBeansFromURL";
        if (this.server == null) {
            throw new IllegalStateException("This MLet MBean is not registered with an MBeanServer.");
        }
        if (url == null) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "URL is null");
            throw new ServiceNotFoundException("The specified URL is null");
        }
        url = url.replace(File.separatorChar, '/');
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "<URL = " + url + ">");
        }
        try {
            MLetParser parser = new MLetParser();
            this.mletList = parser.parseURL(url);
        }
        catch (Exception e) {
            String msg = "Problems while parsing URL [" + url + "], got exception [" + e.toString() + "]";
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, msg);
            throw EnvHelp.initCause(new ServiceNotFoundException(msg), e);
        }
        if (this.mletList.size() == 0) {
            String msg = "File " + url + " not found or MLET tag not defined in file";
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, msg);
            throw new ServiceNotFoundException(msg);
        }
        HashSet<Object> mbeans = new HashSet<Object>();
        for (MLetContent elmt : this.mletList) {
            ObjectInstance objInst;
            String msg;
            String code = elmt.getCode();
            if (code != null && code.endsWith(".class")) {
                code = code.substring(0, code.length() - 6);
            }
            String name = elmt.getName();
            URL codebase = elmt.getCodeBase();
            String version = elmt.getVersion();
            String serName = elmt.getSerializedObject();
            String jarFiles = elmt.getJarFiles();
            URL documentBase = elmt.getDocumentBase();
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                StringBuilder strb = new StringBuilder().append("\n\tMLET TAG     = ").append(elmt.getAttributes()).append("\n\tCODEBASE     = ").append(codebase).append("\n\tARCHIVE      = ").append(jarFiles).append("\n\tCODE         = ").append(code).append("\n\tOBJECT       = ").append(serName).append("\n\tNAME         = ").append(name).append("\n\tVERSION      = ").append(version).append("\n\tDOCUMENT URL = ").append(documentBase);
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, strb.toString());
            }
            StringTokenizer st = new StringTokenizer(jarFiles, ",", false);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "Load archive for codebase <" + codebase + ">, file <" + tok + ">");
                }
                try {
                    codebase = this.check(version, codebase, tok, elmt);
                }
                catch (Exception ex) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), mth, "Got unexpected exception", ex);
                    mbeans.add(ex);
                    continue;
                }
                try {
                    if (Arrays.asList(this.getURLs()).contains(new URL(codebase.toString() + tok))) continue;
                    this.addURL(codebase + tok);
                }
                catch (MalformedURLException ex) {}
            }
            if (code != null && serName != null) {
                msg = "CODE and OBJECT parameters cannot be specified at the same time in tag MLET";
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "CODE and OBJECT parameters cannot be specified at the same time in tag MLET");
                mbeans.add(new Error("CODE and OBJECT parameters cannot be specified at the same time in tag MLET"));
                continue;
            }
            if (code == null && serName == null) {
                msg = "Either CODE or OBJECT parameter must be specified in tag MLET";
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "Either CODE or OBJECT parameter must be specified in tag MLET");
                mbeans.add(new Error("Either CODE or OBJECT parameter must be specified in tag MLET"));
                continue;
            }
            try {
                if (code != null) {
                    List<String> signat = elmt.getParameterTypes();
                    List<String> stringPars = elmt.getParameterValues();
                    ArrayList<Object> objectPars = new ArrayList<Object>();
                    for (int i = 0; i < signat.size(); ++i) {
                        objectPars.add(this.constructParameter(stringPars.get(i), signat.get(i)));
                    }
                    if (signat.isEmpty()) {
                        objInst = name == null ? this.server.createMBean(code, null, this.mletObjectName) : this.server.createMBean(code, new ObjectName(name), this.mletObjectName);
                    } else {
                        Object[] parms = objectPars.toArray();
                        String[] signature = new String[signat.size()];
                        signat.toArray(signature);
                        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                            StringBuilder strb = new StringBuilder();
                            for (int i = 0; i < signature.length; ++i) {
                                strb.append("\n\tSignature     = ").append(signature[i]).append("\t\nParams        = ").append(parms[i]);
                            }
                            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), mth, strb.toString());
                        }
                        objInst = name == null ? this.server.createMBean(code, null, this.mletObjectName, parms, signature) : this.server.createMBean(code, new ObjectName(name), this.mletObjectName, parms, signature);
                    }
                } else {
                    Object o = this.loadSerializedObject(codebase, serName);
                    if (name == null) {
                        this.server.registerMBean(o, null);
                    } else {
                        this.server.registerMBean(o, new ObjectName(name));
                    }
                    objInst = new ObjectInstance(name, o.getClass().getName());
                }
            }
            catch (ReflectionException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "ReflectionException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (InstanceAlreadyExistsException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "InstanceAlreadyExistsException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (MBeanRegistrationException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "MBeanRegistrationException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (MBeanException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "MBeanException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (NotCompliantMBeanException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "NotCompliantMBeanException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (InstanceNotFoundException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "InstanceNotFoundException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (IOException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "IOException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (SecurityException ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "SecurityException", ex);
                mbeans.add(ex);
                continue;
            }
            catch (Exception ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "Exception", ex);
                mbeans.add(ex);
                continue;
            }
            catch (Error ex) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "Error", ex);
                mbeans.add(ex);
                continue;
            }
            mbeans.add(objInst);
        }
        return mbeans;
    }

    @Override
    public synchronized String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    @Override
    public synchronized void setLibraryDirectory(String libdir) {
        this.libraryDirectory = libdir;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.setMBeanServer(server);
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":" + "type=MLet");
        }
        this.mletObjectName = name;
        return this.mletObjectName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class<?> loadClass(String name, ClassLoaderRepository clr) throws ClassNotFoundException {
        ClassLoaderRepository before = this.currentClr;
        try {
            this.currentClr = clr;
            Class<?> clazz = this.loadClass(name);
            return clazz;
        }
        finally {
            this.currentClr = before;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, this.currentClr);
    }

    Class<?> findClass(String name, ClassLoaderRepository clr) throws ClassNotFoundException {
        Class<?> c;
        block10: {
            block9: {
                c = null;
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "findClass", name);
                try {
                    c = super.findClass(name);
                    if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "findClass", "Class " + name + " loaded through MLet classloader");
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) break block9;
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Class " + name + " not found locally");
                }
            }
            if (c == null && this.delegateToCLR && clr != null) {
                try {
                    if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Class " + name + " : looking in CLR");
                    }
                    c = clr.loadClassBefore(this, name);
                    if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "findClass", "Class " + name + " loaded through the default classloader repository");
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) break block10;
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Class " + name + " not found in CLR");
                }
            }
        }
        if (c == null) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Failed to load class " + name);
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    @Override
    protected String findLibrary(String libname) {
        String abs_path;
        String mth = "findLibrary";
        String nativelibname = System.mapLibraryName(libname);
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "Search " + libname + " in all JAR files");
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "loadLibraryAsResource(" + nativelibname + ")");
        }
        if ((abs_path = this.loadLibraryAsResource(nativelibname)) != null) {
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, nativelibname + " loaded, absolute path = " + abs_path);
            }
            return abs_path;
        }
        nativelibname = MLet.removeSpace(System.getProperty("os.name")) + File.separator + MLet.removeSpace(System.getProperty("os.arch")) + File.separator + MLet.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + nativelibname;
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "loadLibraryAsResource(" + nativelibname + ")");
        }
        if ((abs_path = this.loadLibraryAsResource(nativelibname)) != null) {
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, nativelibname + " loaded, absolute path = " + abs_path);
            }
            return abs_path;
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, libname + " not found in any JAR file");
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), mth, "Search " + libname + " along the path specified as the java.library.path property");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            return tmpDir;
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("tmp", "jmx");
            if (tmpFile == null) {
                String string = null;
                return string;
            }
            File tmpDirFile = tmpFile.getParentFile();
            if (tmpDirFile == null) {
                String string = null;
                return string;
            }
            String string = tmpDirFile.getAbsolutePath();
            return string;
        }
        catch (Exception x) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "getTmpDir", "Failed to determine system temporary dir");
            String string = null;
            return string;
        }
        finally {
            if (tmpFile != null) {
                try {
                    boolean deleted = tmpFile.delete();
                    if (!deleted) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "getTmpDir", "Failed to delete temp file");
                    }
                }
                catch (Exception x) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "getTmpDir", "Failed to delete temporary file", x);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String loadLibraryAsResource(String libname) {
        try {
            InputStream is = this.getResourceAsStream(libname.replace(File.separatorChar, '/'));
            if (is == null) return null;
            try {
                File directory = new File(this.libraryDirectory);
                directory.mkdirs();
                File file = Files.createTempFile(directory.toPath(), libname + ".", null, new FileAttribute[0]).toFile();
                file.deleteOnExit();
                try (FileOutputStream fileOutput = new FileOutputStream(file);){
                    int n;
                    byte[] buf = new byte[4096];
                    while ((n = is.read(buf)) >= 0) {
                        fileOutput.write(buf, 0, n);
                    }
                }
                if (!file.exists()) return null;
                if (System.getProperty("os.name", "undefined").equals("HP-UX")) {
                    file.setExecutable(true, false);
                }
                String string = file.getAbsolutePath();
                return string;
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadLibraryAsResource", "Failed to load library : " + libname, e);
            return null;
        }
    }

    private static String removeSpace(String s) {
        return s.trim().replace(" ", "");
    }

    protected URL check(String version, URL codebase, String jarfile, MLetContent mlet) throws Exception {
        return codebase;
    }

    private Object loadSerializedObject(URL codebase, String filename) throws IOException, ClassNotFoundException {
        InputStream is;
        if (filename != null) {
            filename = filename.replace(File.separatorChar, '/');
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "loadSerializedObject", codebase.toString() + filename);
        }
        if ((is = this.getResourceAsStream(filename)) != null) {
            try {
                MLetObjectInputStream ois = new MLetObjectInputStream(is, this);
                Object serObject = ois.readObject();
                ois.close();
                return serObject;
            }
            catch (IOException e) {
                if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadSerializedObject", "Exception while deserializing " + filename, e);
                }
                throw e;
            }
            catch (ClassNotFoundException e) {
                if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadSerializedObject", "Exception while deserializing " + filename, e);
                }
                throw e;
            }
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadSerializedObject", "Error: File " + filename + " containing serialized object not found");
        }
        throw new Error("File " + filename + " containing serialized object not found");
    }

    private Object constructParameter(String param, String type) {
        Class<?> c = this.primitiveClasses.get(type);
        if (c != null) {
            try {
                Constructor<?> cons = c.getConstructor(String.class);
                Object[] oo = new Object[]{param};
                return cons.newInstance(oo);
            }
            catch (Exception e) {
                JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "constructParameter", "Got unexpected exception", e);
            }
        }
        if (type.compareTo("java.lang.Boolean") == 0) {
            return Boolean.valueOf(param);
        }
        if (type.compareTo("java.lang.Byte") == 0) {
            return new Byte(param);
        }
        if (type.compareTo("java.lang.Short") == 0) {
            return new Short(param);
        }
        if (type.compareTo("java.lang.Long") == 0) {
            return new Long(param);
        }
        if (type.compareTo("java.lang.Integer") == 0) {
            return new Integer(param);
        }
        if (type.compareTo("java.lang.Float") == 0) {
            return new Float(param);
        }
        if (type.compareTo("java.lang.Double") == 0) {
            return new Double(param);
        }
        if (type.compareTo("java.lang.String") == 0) {
            return param;
        }
        return param;
    }

    private synchronized void setMBeanServer(final MBeanServer server) {
        this.server = server;
        PrivilegedAction<ClassLoaderRepository> act = new PrivilegedAction<ClassLoaderRepository>(){

            @Override
            public ClassLoaderRepository run() {
                return server.getClassLoaderRepository();
            }
        };
        this.currentClr = AccessController.doPrivileged(act);
    }
}

