/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import sun.security.util.ResourcesMgr;

public final class PrivateCredentialPermission
extends Permission {
    private static final long serialVersionUID = 5284372143517237068L;
    private static final CredOwner[] EMPTY_PRINCIPALS = new CredOwner[0];
    private String credentialClass;
    private Set<Principal> principals;
    private transient CredOwner[] credOwners;
    private boolean testing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateCredentialPermission(String credentialClass, Set<Principal> principals) {
        super(credentialClass);
        this.credentialClass = credentialClass;
        Set<Principal> set = principals;
        synchronized (set) {
            if (principals.size() == 0) {
                this.credOwners = EMPTY_PRINCIPALS;
            } else {
                this.credOwners = new CredOwner[principals.size()];
                int index = 0;
                for (Principal p : principals) {
                    this.credOwners[index++] = new CredOwner(p.getClass().getName(), p.getName());
                }
            }
        }
    }

    public PrivateCredentialPermission(String name, String actions) {
        super(name);
        if (!"read".equalsIgnoreCase(actions)) {
            throw new IllegalArgumentException(ResourcesMgr.getString("actions.can.only.be.read."));
        }
        this.init(name);
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        if (this.credOwners == null || this.credOwners.length == 0) {
            return new String[0][0];
        }
        String[][] pArray = new String[this.credOwners.length][2];
        for (int i = 0; i < this.credOwners.length; ++i) {
            pArray[i][0] = this.credOwners[i].principalClass;
            pArray[i][1] = this.credOwners[i].principalName;
        }
        return pArray;
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null || !(p instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission that = (PrivateCredentialPermission)p;
        if (!this.impliesCredentialClass(this.credentialClass, that.credentialClass)) {
            return false;
        }
        return this.impliesPrincipalSet(this.credOwners, that.credOwners);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission that = (PrivateCredentialPermission)obj;
        return this.implies(that) && that.implies(this);
    }

    @Override
    public int hashCode() {
        return this.credentialClass.hashCode();
    }

    @Override
    public String getActions() {
        return "read";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private void init(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("invalid empty name");
        }
        ArrayList<CredOwner> pList = new ArrayList<CredOwner>();
        StringTokenizer tokenizer = new StringTokenizer(name, " ", true);
        String principalClass = null;
        String principalName = null;
        if (this.testing) {
            System.out.println("whole name = " + name);
        }
        this.credentialClass = tokenizer.nextToken();
        if (this.testing) {
            System.out.println("Credential Class = " + this.credentialClass);
        }
        if (!tokenizer.hasMoreTokens()) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
            Object[] source = new Object[]{name};
            throw new IllegalArgumentException(form.format(source) + ResourcesMgr.getString("Credential.Class.not.followed.by.a.Principal.Class.and.Name"));
        }
        while (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
            principalClass = tokenizer.nextToken();
            if (this.testing) {
                System.out.println("    Principal Class = " + principalClass);
            }
            if (!tokenizer.hasMoreTokens()) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
                Object[] source = new Object[]{name};
                throw new IllegalArgumentException(form.format(source) + ResourcesMgr.getString("Principal.Class.not.followed.by.a.Principal.Name"));
            }
            tokenizer.nextToken();
            principalName = tokenizer.nextToken();
            if (!principalName.startsWith("\"")) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
                Object[] source = new Object[]{name};
                throw new IllegalArgumentException(form.format(source) + ResourcesMgr.getString("Principal.Name.must.be.surrounded.by.quotes"));
            }
            if (!principalName.endsWith("\"")) {
                while (tokenizer.hasMoreTokens() && !(principalName = principalName + tokenizer.nextToken()).endsWith("\"")) {
                }
                if (!principalName.endsWith("\"")) {
                    MessageFormat form = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
                    Object[] source = new Object[]{name};
                    throw new IllegalArgumentException(form.format(source) + ResourcesMgr.getString("Principal.Name.missing.end.quote"));
                }
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + principalName + "'");
            }
            principalName = principalName.substring(1, principalName.length() - 1);
            if (principalClass.equals("*") && !principalName.equals("*")) {
                throw new IllegalArgumentException(ResourcesMgr.getString("PrivateCredentialPermission.Principal.Class.can.not.be.a.wildcard.value.if.Principal.Name.is.not.a.wildcard.value"));
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + principalName + "'");
            }
            pList.add(new CredOwner(principalClass, principalName));
        }
        this.credOwners = new CredOwner[pList.size()];
        pList.toArray(this.credOwners);
    }

    private boolean impliesCredentialClass(String thisC, String thatC) {
        if (thisC == null || thatC == null) {
            return false;
        }
        if (this.testing) {
            System.out.println("credential class comparison: " + thisC + "/" + thatC);
        }
        if (thisC.equals("*")) {
            return true;
        }
        return thisC.equals(thatC);
    }

    private boolean impliesPrincipalSet(CredOwner[] thisP, CredOwner[] thatP) {
        if (thisP == null || thatP == null) {
            return false;
        }
        if (thatP.length == 0) {
            return true;
        }
        if (thisP.length == 0) {
            return false;
        }
        for (int i = 0; i < thisP.length; ++i) {
            boolean foundMatch = false;
            for (int j = 0; j < thatP.length; ++j) {
                if (!thisP[i].implies(thatP[j])) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getName().indexOf(" ") == -1 && this.getName().indexOf("\"") == -1) {
            this.credentialClass = this.getName();
            this.credOwners = EMPTY_PRINCIPALS;
        } else {
            this.init(this.getName());
        }
    }

    static class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        String principalClass;
        String principalName;

        CredOwner(String principalClass, String principalName) {
            this.principalClass = principalClass;
            this.principalName = principalName;
        }

        public boolean implies(Object obj) {
            if (obj == null || !(obj instanceof CredOwner)) {
                return false;
            }
            CredOwner that = (CredOwner)obj;
            return !(!this.principalClass.equals("*") && !this.principalClass.equals(that.principalClass) || !this.principalName.equals("*") && !this.principalName.equals(that.principalName));
        }

        public String toString() {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("CredOwner.Principal.Class.class.Principal.Name.name"));
            Object[] source = new Object[]{this.principalClass, this.principalName};
            return form.format(source);
        }
    }
}

