/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.nio.cs.ThreadLocalCoders;

public abstract class DocumentBuilder {
    protected DocumentBuilder() {
    }

    public void reset() {
        throw new UnsupportedOperationException("This DocumentBuilder, \"" + this.getClass().getName() + "\", does not support the reset functionality.  Specification \"" + this.getClass().getPackage().getSpecificationTitle() + "\" version \"" + this.getClass().getPackage().getSpecificationVersion() + "\"");
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        InputSource in = new InputSource(is);
        return this.parse(in);
    }

    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        return this.parse(in);
    }

    public Document parse(String uri) throws SAXException, IOException {
        Document result;
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        if (uri.startsWith("jar:file:") && (result = this.parseFromJarEntry(uri)) != null) {
            return result;
        }
        InputSource in = new InputSource(uri);
        return this.parse(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseFromJarEntry(String uri) throws SAXException, IOException {
        String localJarEntry = DocumentBuilder.decode(uri.substring("jar:file:".length()));
        int idxExclMark = localJarEntry.indexOf(33);
        if (idxExclMark < 1) {
            return null;
        }
        String jarFileName = localJarEntry.substring(0, idxExclMark);
        int idxEntryStart = idxExclMark + 1;
        while (localJarEntry.charAt(idxEntryStart) == '/') {
            ++idxEntryStart;
        }
        if (idxEntryStart > localJarEntry.length() - 1) {
            return null;
        }
        String entryName = localJarEntry.substring(idxEntryStart);
        File file = new File(jarFileName);
        if (!file.isFile()) {
            return null;
        }
        JarFile jarFile = null;
        InputSource in = null;
        try {
            Document parsedDocument;
            try {
                jarFile = new JarFile(jarFileName);
                JarEntry entry = jarFile.getJarEntry(entryName);
                InputStream is = jarFile.getInputStream(entry);
                in = new InputSource(uri);
                in.setByteStream(is);
            }
            catch (Exception e) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Document document = null;
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return document;
            }
            Document document = parsedDocument = this.parse(in);
            return document;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Document parse(File f) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        InputSource in = new InputSource(f.toURI().toASCIIString());
        return this.parse(in);
    }

    public abstract Document parse(InputSource var1) throws SAXException, IOException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract void setEntityResolver(EntityResolver var1);

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract Document newDocument();

    public abstract DOMImplementation getDOMImplementation();

    public Schema getSchema() {
        throw new UnsupportedOperationException("This parser does not support specification \"" + this.getClass().getPackage().getSpecificationTitle() + "\" version \"" + this.getClass().getPackage().getSpecificationVersion() + "\"");
    }

    public boolean isXIncludeAware() {
        throw new UnsupportedOperationException("This parser does not support specification \"" + this.getClass().getPackage().getSpecificationTitle() + "\" version \"" + this.getClass().getPackage().getSpecificationVersion() + "\"");
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        assert (false);
        return -1;
    }

    private static byte decode(char c1, char c2) {
        return (byte)((DocumentBuilder.decode(c1) & 0xF) << 4 | (DocumentBuilder.decode(c2) & 0xF) << 0);
    }

    private static String decode(String s) {
        if (s == null) {
            return s;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        byte[] ba = new byte[n];
        StringBuffer sb = new StringBuffer(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c = s.charAt(0);
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            assert (c == s.charAt(i));
            if (c == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            int ui = i;
            do {
                assert (n - i >= 2);
                bb.put(DocumentBuilder.decode(s.charAt(++i), s.charAt(++i)));
            } while (++i < n && (c = s.charAt(i)) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            assert (cr.isUnderflow());
            cr = dec.flush(cb);
            assert (cr.isUnderflow());
            sb.append(cb.flip().toString());
        }
        return sb.toString();
    }
}

