/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.event;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public final class EventHelper {
    private static final JavaUtilJarAccess JUJA = SharedSecrets.javaUtilJarAccess();
    private static volatile boolean loggingSecurity;
    private static volatile PlatformLogger securityLogger;
    private static final PlatformLogger.Level LOG_LEVEL;
    private static final String SECURITY_LOGGER_NAME = "jdk.event.security";

    public static void logTLSHandshakeEvent(Instant start, String peerHost, int peerPort, String cipherSuite, String protocolVersion, long peerCertId) {
        assert (securityLogger != null);
        String prepend = EventHelper.getDurationString(start);
        securityLogger.fine(prepend + " TLSHandshake: {0}:{1}, {2}, {3}, {4}", peerHost, peerPort, protocolVersion, cipherSuite, peerCertId);
    }

    public static void logSecurityPropertyEvent(String key, String value) {
        assert (securityLogger != null);
        securityLogger.fine("SecurityPropertyModification: key:{0}, value:{1}", key, value);
    }

    public static void logX509ValidationEvent(int anchorCertId, int[] certIds) {
        assert (securityLogger != null);
        String codes = IntStream.of(certIds).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        securityLogger.fine("ValidationChain: {0}, {1}", anchorCertId, codes);
    }

    public static void logX509CertificateEvent(String algId, String serialNum, String subject, String issuer, String keyType, int length, long certId, long beginDate, long endDate) {
        assert (securityLogger != null);
        securityLogger.fine("X509Certificate: Alg:{0}, Serial:{1}, Subject:{2}, Issuer:{3}, Key type:{4}, Length:{5}, Cert Id:{6}, Valid from:{7}, Valid until:{8}", algId, serialNum, subject, issuer, keyType, length, certId, new Date(beginDate), new Date(endDate));
    }

    private static String getDurationString(Instant start) {
        if (start != null) {
            Duration duration = Duration.between(start, Instant.now());
            long micros = duration.toNanos() / 1000L;
            if (micros < 1000000L) {
                return "duration = " + (double)micros / 1000.0 + " ms:";
            }
            return "duration = " + (double)(micros / 1000L) / 1000.0 + " s:";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLoggingSecurity() {
        PlatformLogger logger = securityLogger;
        if (logger != null || JUJA.isInitializing()) return loggingSecurity;
        logger = PlatformLogger.getLogger(SECURITY_LOGGER_NAME);
        Class<EventHelper> clazz = EventHelper.class;
        synchronized (EventHelper.class) {
            if (securityLogger != null) return loggingSecurity;
            securityLogger = logger;
            loggingSecurity = logger.isLoggable(LOG_LEVEL);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loggingSecurity;
        }
    }

    static {
        LOG_LEVEL = PlatformLogger.Level.FINE;
    }
}

