/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.platform.cgroupv1.Metrics;

public class SubSystem {
    String root;
    String mountPoint;
    String path;

    public SubSystem(String root, String mountPoint) {
        this.root = root;
        this.mountPoint = mountPoint;
    }

    public void setPath(String cgroupPath) {
        if (this.root != null && cgroupPath != null) {
            if (this.root.equals("/")) {
                this.path = !cgroupPath.equals("/") ? this.mountPoint + cgroupPath : this.mountPoint;
            } else if (this.root.equals(cgroupPath)) {
                this.path = this.mountPoint;
            } else if (cgroupPath.startsWith(this.root) && cgroupPath.length() > this.root.length()) {
                String cgroupSubstr = cgroupPath.substring(this.root.length());
                this.path = this.mountPoint + cgroupSubstr;
            }
        }
    }

    public String path() {
        return this.path;
    }

    public static String getStringValue(SubSystem subsystem, String parm) {
        if (subsystem == null) {
            return null;
        }
        try {
            return subsystem.readStringValue(parm);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readStringValue(String param) throws IOException {
        PrivilegedExceptionAction<BufferedReader> pea = () -> Files.newBufferedReader(Paths.get(this.path(), param));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(pea);){
            String line;
            String string = line = bufferedReader.readLine();
            return string;
        }
        catch (PrivilegedActionException e) {
            Metrics.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static long getLongValueMatchingLine(SubSystem subsystem, String param, String match, Function<String, Long> conversion) {
        long retval = Metrics.unlimited_minimum + 1L;
        try {
            List<String> lines = subsystem.readMatchingLines(param);
            for (String line : lines) {
                if (!line.startsWith(match)) continue;
                retval = conversion.apply(line);
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    private List<String> readMatchingLines(String param) throws IOException {
        try {
            PrivilegedExceptionAction<List> pea = () -> Files.readAllLines(Paths.get(this.path(), param));
            return AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            Metrics.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static long getLongValue(SubSystem subsystem, String parm) {
        String strval = SubSystem.getStringValue(subsystem, parm);
        return SubSystem.convertStringToLong(strval);
    }

    public static long convertStringToLong(String strval) {
        long retval;
        block3: {
            retval = 0L;
            if (strval == null) {
                return 0L;
            }
            try {
                retval = Long.parseLong(strval);
            }
            catch (NumberFormatException e) {
                BigInteger b = new BigInteger(strval);
                if (b.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) break block3;
                return Long.MAX_VALUE;
            }
        }
        return retval;
    }

    public static double getDoubleValue(SubSystem subsystem, String parm) {
        String strval = SubSystem.getStringValue(subsystem, parm);
        if (strval == null) {
            return 0.0;
        }
        double retval = Double.parseDouble(strval);
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getLongEntry(SubSystem subsystem, String parm, String entryname) {
        Object val = null;
        if (subsystem == null) {
            return 0L;
        }
        try (Stream<String> lines = Metrics.readFilePrivileged(Paths.get(subsystem.path(), parm));){
            Optional<String> result = lines.map(line -> line.split(" ")).filter(line -> ((String[])line).length == 2 && line[0].equals(entryname)).map(line -> line[1]).findFirst();
            long l = result.isPresent() ? Long.parseLong(result.get()) : 0L;
            return l;
        }
        catch (UncheckedIOException e) {
            return 0L;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static int getIntValue(SubSystem subsystem, String parm) {
        String val = SubSystem.getStringValue(subsystem, parm);
        if (val == null) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public static int[] StringRangeToIntArray(String range) {
        String[] strs;
        int[] ints = new int[]{};
        if (range == null) {
            return ints;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String str : strs = range.split(",")) {
            if (str.contains("-")) {
                String[] lohi = str.split("-");
                if (lohi.length != 2) continue;
                int lo = Integer.parseInt(lohi[0]);
                int hi = Integer.parseInt(lohi[1]);
                for (int i = lo; i <= hi; ++i) {
                    results.add(i);
                }
                continue;
            }
            results.add(Integer.parseInt(str));
        }
        results.sort(null);
        ints = new int[results.size()];
        int i = 0;
        for (Integer n : results) {
            ints[i++] = n;
        }
        return ints;
    }

    public static class MemorySubSystem
    extends SubSystem {
        private boolean hierarchical;
        private boolean swapenabled;

        public MemorySubSystem(String root, String mountPoint) {
            super(root, mountPoint);
        }

        boolean isHierarchical() {
            return this.hierarchical;
        }

        void setHierarchical(boolean hierarchical) {
            this.hierarchical = hierarchical;
        }

        boolean isSwapEnabled() {
            return this.swapenabled;
        }

        void setSwapEnabled(boolean swapenabled) {
            this.swapenabled = swapenabled;
        }
    }
}

