/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdk.Exported;
import jdk.net.NetworkPermission;
import jdk.net.SocketFlow;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@Exported
public final class ExtendedSocketOptions {
    public static final SocketOption<SocketFlow> SO_FLOW_SLA = new ExtSocketOption<SocketFlow>("SO_FLOW_SLA", SocketFlow.class);
    public static final SocketOption<Integer> TCP_KEEPIDLE = new ExtSocketOption<Integer>("TCP_KEEPIDLE", Integer.class);
    public static final SocketOption<Integer> TCP_KEEPINTERVAL = new ExtSocketOption<Integer>("TCP_KEEPINTERVAL", Integer.class);
    public static final SocketOption<Integer> TCP_KEEPCOUNT = new ExtSocketOption<Integer>("TCP_KEEPCOUNT", Integer.class);
    private static final PlatformSocketOptions platformSocketOptions = PlatformSocketOptions.get();
    private static final boolean flowSupported = platformSocketOptions.flowSupported();
    private static final boolean keepAliveOptSupported = platformSocketOptions.keepAliveOptionsSupported();
    private static final Set<SocketOption<?>> extendedOptions = ExtendedSocketOptions.options();
    private static final JavaIOFileDescriptorAccess fdAccess;

    private ExtendedSocketOptions() {
    }

    static Set<SocketOption<?>> options() {
        HashSet<SocketOption<Object>> options = new HashSet<SocketOption<Object>>();
        if (flowSupported) {
            options.add(SO_FLOW_SLA);
        }
        if (keepAliveOptSupported) {
            options.add(TCP_KEEPCOUNT);
            options.add(TCP_KEEPIDLE);
            options.add(TCP_KEEPINTERVAL);
        }
        return Collections.unmodifiableSet(options);
    }

    private static <T> T checkValueType(Object value, Class<T> type) {
        if (!type.isAssignableFrom(value.getClass())) {
            String s = "Found: " + value.getClass() + ", Expected: " + type;
            throw new IllegalArgumentException(s);
        }
        return (T)value;
    }

    public static void setFlowOption(FileDescriptor fd, SocketFlow f) throws SocketException {
        int status = PlatformSocketOptions.get().setFlowOption(fdAccess.get(fd), f.priority(), f.bandwidth());
        f.status(status);
    }

    public static int getFlowOption(FileDescriptor fd, SocketFlow f) throws SocketException {
        return PlatformSocketOptions.get().getFlowOption(fdAccess.get(fd), f);
    }

    private static boolean flowSupported() {
        return PlatformSocketOptions.get().flowSupported();
    }

    private static boolean keepAliveOptionsSupported() {
        return PlatformSocketOptions.get().keepAliveOptionsSupported();
    }

    private static void setTcpkeepAliveProbes(FileDescriptor fd, int value) throws SocketException {
        PlatformSocketOptions.get().setTcpkeepAliveProbes(fdAccess.get(fd), value);
    }

    private static void setTcpKeepAliveTime(FileDescriptor fd, int value) throws SocketException {
        PlatformSocketOptions.get().setTcpKeepAliveTime(fdAccess.get(fd), value);
    }

    private static void setTcpKeepAliveIntvl(FileDescriptor fd, int value) throws SocketException {
        PlatformSocketOptions.get().setTcpKeepAliveIntvl(fdAccess.get(fd), value);
    }

    private static int getTcpkeepAliveProbes(FileDescriptor fd) throws SocketException {
        return PlatformSocketOptions.get().getTcpkeepAliveProbes(fdAccess.get(fd));
    }

    private static int getTcpKeepAliveTime(FileDescriptor fd) throws SocketException {
        return PlatformSocketOptions.get().getTcpKeepAliveTime(fdAccess.get(fd));
    }

    private static int getTcpKeepAliveIntvl(FileDescriptor fd) throws SocketException {
        return PlatformSocketOptions.get().getTcpKeepAliveIntvl(fdAccess.get(fd));
    }

    static {
        sun.net.ExtendedSocketOptions.register(new sun.net.ExtendedSocketOptions((Set)extendedOptions){

            @Override
            public void setOption(FileDescriptor fd, SocketOption<?> option, Object value) throws SocketException {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new NetworkPermission("setOption." + option.name()));
                }
                if (fd == null || !fd.valid()) {
                    throw new SocketException("socket closed");
                }
                if (option == SO_FLOW_SLA) {
                    assert (flowSupported);
                    SocketFlow flow = (SocketFlow)ExtendedSocketOptions.checkValueType(value, SocketFlow.class);
                    ExtendedSocketOptions.setFlowOption(fd, flow);
                } else if (option == TCP_KEEPCOUNT) {
                    ExtendedSocketOptions.setTcpkeepAliveProbes(fd, (Integer)value);
                } else if (option == TCP_KEEPIDLE) {
                    ExtendedSocketOptions.setTcpKeepAliveTime(fd, (Integer)value);
                } else if (option == TCP_KEEPINTERVAL) {
                    ExtendedSocketOptions.setTcpKeepAliveIntvl(fd, (Integer)value);
                } else {
                    throw new InternalError("Unexpected option " + option);
                }
            }

            @Override
            public Object getOption(FileDescriptor fd, SocketOption<?> option) throws SocketException {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new NetworkPermission("getOption." + option.name()));
                }
                if (fd == null || !fd.valid()) {
                    throw new SocketException("socket closed");
                }
                if (option == SO_FLOW_SLA) {
                    assert (flowSupported);
                    SocketFlow flow = SocketFlow.create();
                    ExtendedSocketOptions.getFlowOption(fd, flow);
                    return flow;
                }
                if (option == TCP_KEEPCOUNT) {
                    return ExtendedSocketOptions.getTcpkeepAliveProbes(fd);
                }
                if (option == TCP_KEEPIDLE) {
                    return ExtendedSocketOptions.getTcpKeepAliveTime(fd);
                }
                if (option == TCP_KEEPINTERVAL) {
                    return ExtendedSocketOptions.getTcpKeepAliveIntvl(fd);
                }
                throw new InternalError("Unexpected option " + option);
            }
        });
        fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    }

    static class PlatformSocketOptions {
        private static final PlatformSocketOptions instance = PlatformSocketOptions.create();

        protected PlatformSocketOptions() {
        }

        private static PlatformSocketOptions newInstance(String cn) {
            try {
                Class<?> c = Class.forName(cn);
                return (PlatformSocketOptions)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException x) {
                throw new AssertionError((Object)x);
            }
        }

        private static PlatformSocketOptions create() {
            String osname = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.name");
                }
            });
            if ("SunOS".equals(osname)) {
                return PlatformSocketOptions.newInstance("jdk.net.SolarisSocketOptions");
            }
            if ("Linux".equals(osname)) {
                return PlatformSocketOptions.newInstance("jdk.net.LinuxSocketOptions");
            }
            if (osname.startsWith("Mac")) {
                return PlatformSocketOptions.newInstance("jdk.net.MacOSXSocketOptions");
            }
            return new PlatformSocketOptions();
        }

        static PlatformSocketOptions get() {
            return instance;
        }

        void init() {
        }

        int setFlowOption(int fd, int priority, long bandwidth) throws SocketException {
            throw new UnsupportedOperationException("unsupported socket option");
        }

        int getFlowOption(int fd, SocketFlow f) throws SocketException {
            throw new UnsupportedOperationException("unsupported socket option");
        }

        boolean flowSupported() {
            return false;
        }

        boolean keepAliveOptionsSupported() {
            return false;
        }

        void setTcpkeepAliveProbes(int fd, int value) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPCNT option");
        }

        void setTcpKeepAliveTime(int fd, int value) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPIDLE option");
        }

        void setTcpKeepAliveIntvl(int fd, int value) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPINTVL option");
        }

        int getTcpkeepAliveProbes(int fd) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPCNT option");
        }

        int getTcpKeepAliveTime(int fd) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPIDLE option");
        }

        int getTcpKeepAliveIntvl(int fd) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPINTVL option");
        }
    }

    private static class ExtSocketOption<T>
    implements SocketOption<T> {
        private final String name;
        private final Class<T> type;

        ExtSocketOption(String name, Class<T> type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

