/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.jcp.xml.dsig.internal.dom.DOMCanonicalizationMethod;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.Policy;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignedInfo
extends DOMStructure
implements SignedInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DOMSignedInfo.class);
    private List<Reference> references;
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private String id;
    private Document ownerDoc;
    private Element localSiElem;
    private InputStream canonData;

    public DOMSignedInfo(CanonicalizationMethod cm, SignatureMethod sm, List<? extends Reference> references) {
        if (cm == null || sm == null || references == null) {
            throw new NullPointerException();
        }
        this.canonicalizationMethod = cm;
        this.signatureMethod = sm;
        this.references = Collections.unmodifiableList(new ArrayList<Reference>(references));
        if (this.references.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int size = this.references.size();
        for (int i = 0; i < size; ++i) {
            Reference obj = this.references.get(i);
            if (obj instanceof Reference) continue;
            throw new ClassCastException("list of references contains an illegal type");
        }
    }

    public DOMSignedInfo(CanonicalizationMethod cm, SignatureMethod sm, List<? extends Reference> references, String id) {
        this(cm, sm, references);
        this.id = id;
    }

    public DOMSignedInfo(Element siElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        this.localSiElem = siElem;
        this.ownerDoc = siElem.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(siElem, "Id");
        Element cmElem = DOMUtils.getFirstChildElement(siElem, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
        this.canonicalizationMethod = new DOMCanonicalizationMethod(cmElem, context, provider);
        Element smElem = DOMUtils.getNextSiblingElement(cmElem, "SignatureMethod", "http://www.w3.org/2000/09/xmldsig#");
        this.signatureMethod = DOMSignatureMethod.unmarshal(smElem);
        boolean secVal = Utils.secureValidation(context);
        String signatureMethodAlgorithm = this.signatureMethod.getAlgorithm();
        if (secVal && Policy.restrictAlg(signatureMethodAlgorithm)) {
            throw new MarshalException("It is forbidden to use algorithm " + signatureMethodAlgorithm + " when secure validation is enabled");
        }
        ArrayList<DOMReference> refList = new ArrayList<DOMReference>(5);
        Element refElem = DOMUtils.getNextSiblingElement(smElem, "Reference", "http://www.w3.org/2000/09/xmldsig#");
        refList.add(new DOMReference(refElem, context, provider));
        refElem = DOMUtils.getNextSiblingElement(refElem);
        while (refElem != null) {
            String name = refElem.getLocalName();
            String namespace = refElem.getNamespaceURI();
            if (!"Reference".equals(name) || !"http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                throw new MarshalException("Invalid element name: " + namespace + ":" + name + ", expected Reference");
            }
            refList.add(new DOMReference(refElem, context, provider));
            if (secVal && Policy.restrictNumReferences(refList.size())) {
                String error = "A maxiumum of " + Policy.maxReferences() + " references per Manifest are allowed when secure validation is enabled";
                throw new MarshalException(error);
            }
            refElem = DOMUtils.getNextSiblingElement(refElem);
        }
        this.references = Collections.unmodifiableList(refList);
    }

    @Override
    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    @Override
    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public InputStream getCanonicalizedData() {
        return this.canonData;
    }

    public void canonicalize(XMLCryptoContext context, ByteArrayOutputStream bos) throws XMLSignatureException {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        DOMSubTreeData subTree = new DOMSubTreeData(this.localSiElem, true);
        try (UnsyncBufferedOutputStream os = new UnsyncBufferedOutputStream(bos);){
            ((DOMCanonicalizationMethod)this.canonicalizationMethod).canonicalize(subTree, context, os);
            ((OutputStream)os).flush();
            byte[] signedInfoBytes = bos.toByteArray();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Canonicalized SignedInfo:");
                StringBuilder sb = new StringBuilder(signedInfoBytes.length);
                for (int i = 0; i < signedInfoBytes.length; ++i) {
                    sb.append((char)signedInfoBytes[i]);
                }
                LOG.debug(sb.toString());
                LOG.debug("Data to be signed/verified:" + XMLUtils.encodeToString(signedInfoBytes));
            }
            this.canonData = new ByteArrayInputStream(signedInfoBytes);
        }
        catch (TransformException te) {
            throw new XMLSignatureException(te);
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), e);
        }
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element siElem = DOMUtils.createElement(this.ownerDoc, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMCanonicalizationMethod dcm = (DOMCanonicalizationMethod)this.canonicalizationMethod;
        dcm.marshal(siElem, dsPrefix, context);
        ((DOMStructure)((Object)this.signatureMethod)).marshal(siElem, dsPrefix, context);
        for (Reference reference : this.references) {
            ((DOMReference)reference).marshal(siElem, dsPrefix, context);
        }
        DOMUtils.setAttributeID(siElem, "Id", this.id);
        parent.appendChild(siElem);
        this.localSiElem = siElem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignedInfo)) {
            return false;
        }
        SignedInfo osi = (SignedInfo)o;
        boolean idEqual = this.id == null ? osi.getId() == null : this.id.equals(osi.getId());
        return this.canonicalizationMethod.equals(osi.getCanonicalizationMethod()) && this.signatureMethod.equals(osi.getSignatureMethod()) && this.references.equals(osi.getReferences()) && idEqual;
    }

    public static List<Reference> getSignedInfoReferences(SignedInfo si) {
        return si.getReferences();
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.canonicalizationMethod.hashCode();
        result = 31 * result + this.signatureMethod.hashCode();
        result = 31 * result + this.references.hashCode();
        return result;
    }
}

