/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTError;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import sun.awt.SunToolkit;
import sun.awt.X11GraphicsDevice;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceManagerFactory;
import sun.java2d.UnixSurfaceManagerFactory;
import sun.java2d.xr.XRSurfaceData;
import sun.security.action.GetPropertyAction;
import sun.util.logging.PlatformLogger;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11GraphicsEnvironment");
    private static final PlatformLogger screenLog = PlatformLogger.getLogger("sun.awt.screen.X11GraphicsEnvironment");
    private static Boolean xinerState;
    private static boolean glxAvailable;
    private static boolean glxVerbose;
    private static boolean xRenderVerbose;
    private static boolean xRenderAvailable;
    private Boolean isDisplayLocal;

    private static native boolean initGLX();

    public static boolean isGLXAvailable() {
        return glxAvailable;
    }

    public static boolean isGLXVerbose() {
        return glxVerbose;
    }

    private static native boolean initXRender(boolean var0, boolean var1);

    public static boolean isXRenderAvailable() {
        return xRenderAvailable;
    }

    public static boolean isXRenderVerbose() {
        return xRenderVerbose;
    }

    private static native int checkShmExt();

    private static native String getDisplayString();

    private static native void initDisplay(boolean var0);

    @Override
    protected native int getNumScreens();

    @Override
    protected GraphicsDevice makeScreenDevice(int screennum) {
        return new X11GraphicsDevice(screennum);
    }

    protected native int getDefaultScreenNum();

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        GraphicsDevice[] screens = this.getScreenDevices();
        if (screens.length == 0) {
            throw new AWTError("no screen devices");
        }
        int index = this.getDefaultScreenNum();
        return screens[0 < index && index < screens.length ? index : 0];
    }

    @Override
    public boolean isDisplayLocal() {
        if (this.isDisplayLocal == null) {
            SunToolkit.awtLock();
            try {
                if (this.isDisplayLocal == null) {
                    this.isDisplayLocal = X11GraphicsEnvironment._isDisplayLocal();
                }
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
        return this.isDisplayLocal;
    }

    private static boolean _isDisplayLocal() {
        if (X11GraphicsEnvironment.isHeadless()) {
            return true;
        }
        String isRemote = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (isRemote != null) {
            return isRemote.equals("false");
        }
        int shm = X11GraphicsEnvironment.checkShmExt();
        if (shm != -1) {
            return shm == 1;
        }
        String display = X11GraphicsEnvironment.getDisplayString();
        int ind = display.indexOf(58);
        final String hostName = display.substring(0, ind);
        if (ind <= 0) {
            return true;
        }
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress[] remAddr = null;
                Enumeration<InetAddress> locals = null;
                Enumeration<NetworkInterface> interfaces = null;
                try {
                    interfaces = NetworkInterface.getNetworkInterfaces();
                    remAddr = InetAddress.getAllByName(hostName);
                    if (remAddr == null) {
                        return Boolean.FALSE;
                    }
                }
                catch (UnknownHostException e) {
                    System.err.println("Unknown host: " + hostName);
                    return Boolean.FALSE;
                }
                catch (SocketException e1) {
                    System.err.println(e1.getMessage());
                    return Boolean.FALSE;
                }
                while (interfaces.hasMoreElements()) {
                    locals = interfaces.nextElement().getInetAddresses();
                    while (locals.hasMoreElements()) {
                        InetAddress localAddr = locals.nextElement();
                        for (int i = 0; i < remAddr.length; ++i) {
                            if (!localAddr.equals(remAddr[i])) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    public String getDefaultFontFaceName() {
        return null;
    }

    private static native boolean pRunningXinerama();

    private static native Point getXineramaCenterPoint();

    @Override
    public Point getCenterPoint() {
        Point p;
        if (this.runningXinerama() && (p = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return p;
        }
        return super.getCenterPoint();
    }

    @Override
    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    public boolean runningXinerama() {
        if (xinerState == null) {
            xinerState = X11GraphicsEnvironment.pRunningXinerama();
            if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
                screenLog.finer("Running Xinerama: " + xinerState);
            }
        }
        return xinerState;
    }

    protected Rectangle getXineramaWindowBounds() {
        Point center = this.getCenterPoint();
        GraphicsDevice[] gds = this.getScreenDevices();
        Rectangle centerMonitorRect = null;
        Rectangle unionRect = X11GraphicsEnvironment.getUsableBounds(gds[0]);
        for (int i = 0; i < gds.length; ++i) {
            Rectangle tempRect = X11GraphicsEnvironment.getUsableBounds(gds[i]);
            if (centerMonitorRect == null && tempRect.width / 2 + tempRect.x > center.x - 1 && tempRect.height / 2 + tempRect.y > center.y - 1 && tempRect.width / 2 + tempRect.x < center.x + 1 && tempRect.height / 2 + tempRect.y < center.y + 1) {
                centerMonitorRect = tempRect;
            }
            unionRect = unionRect.union(tempRect);
        }
        if (unionRect.width / 2 + unionRect.x > center.x - 1 && unionRect.height / 2 + unionRect.y > center.y - 1 && unionRect.width / 2 + unionRect.x < center.x + 1 && unionRect.height / 2 + unionRect.y < center.y + 1) {
            if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
                screenLog.finer("Video Wall: center point is at center of all displays.");
            }
            return unionRect;
        }
        if (centerMonitorRect != null) {
            if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
                screenLog.finer("Center point at center of a particular monitor, but not of the entire virtual display.");
            }
            return centerMonitorRect;
        }
        if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
            screenLog.finer("Center point is somewhere strange - return union of all bounds.");
        }
        return unionRect;
    }

    @Override
    public void paletteChanged() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                if (!GraphicsEnvironment.isHeadless()) {
                    boolean glxRequested = false;
                    String prop = System.getProperty("sun.java2d.opengl");
                    if (prop != null) {
                        if (prop.equals("true") || prop.equals("t")) {
                            glxRequested = true;
                        } else if (prop.equals("True") || prop.equals("T")) {
                            glxRequested = true;
                            glxVerbose = true;
                        }
                    }
                    boolean xRenderRequested = true;
                    String osname = System.getProperty("os.name");
                    if (osname.equals("AIX") || osname.equals("OS400") || osname.equals("HP-UX")) {
                        xRenderRequested = false;
                    }
                    boolean xRenderIgnoreLinuxVersion = false;
                    String xProp = System.getProperty("sun.java2d.xrender");
                    if (xProp != null) {
                        if (xProp.equals("false") || xProp.equals("f")) {
                            xRenderRequested = false;
                        } else if (xProp.equals("True") || xProp.equals("T")) {
                            xRenderRequested = true;
                            xRenderVerbose = true;
                        }
                        if (xProp.equalsIgnoreCase("t") || xProp.equalsIgnoreCase("true")) {
                            xRenderIgnoreLinuxVersion = true;
                        }
                    }
                    X11GraphicsEnvironment.initDisplay(glxRequested);
                    if (glxRequested) {
                        glxAvailable = X11GraphicsEnvironment.initGLX();
                        if (glxVerbose && !glxAvailable) {
                            System.out.println("Could not enable OpenGL pipeline (GLX 1.3 not available)");
                        }
                    }
                    if (xRenderRequested) {
                        xRenderAvailable = X11GraphicsEnvironment.initXRender(xRenderVerbose, xRenderIgnoreLinuxVersion);
                        if (xRenderVerbose && !xRenderAvailable) {
                            System.out.println("Could not enable XRender pipeline");
                        }
                    }
                    if (xRenderAvailable) {
                        XRSurfaceData.initXRSurfaceData();
                    }
                }
                return null;
            }
        });
        SurfaceManagerFactory.setInstance(new UnixSurfaceManagerFactory());
    }
}

