/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JPEGImageDecoderImpl
implements JPEGImageDecoder {
    private static final Class InputStreamClass = InputStream.class;
    private JPEGDecodeParam param = null;
    private InputStream input = null;
    private WritableRaster aRas = null;
    private BufferedImage aBufImg = null;
    private ColorModel cm = null;
    private boolean unpack = false;
    private boolean flip = false;

    public JPEGImageDecoderImpl(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        this.input = in;
        this.initDecoder(InputStreamClass);
    }

    public JPEGImageDecoderImpl(InputStream in, JPEGDecodeParam jdp) {
        this(in);
        this.setJPEGDecodeParam(jdp);
    }

    @Override
    public JPEGDecodeParam getJPEGDecodeParam() {
        if (this.param != null) {
            return (JPEGDecodeParam)this.param.clone();
        }
        return null;
    }

    @Override
    public void setJPEGDecodeParam(JPEGDecodeParam jdp) {
        this.param = (JPEGDecodeParam)jdp.clone();
    }

    @Override
    public synchronized InputStream getInputStream() {
        return this.input;
    }

    @Override
    public synchronized Raster decodeAsRaster() throws ImageFormatException {
        try {
            this.param = this.readJPEGStream(this.input, this.param, false);
        }
        catch (IOException e) {
            System.out.println("Can't open input Stream" + e);
            e.printStackTrace();
        }
        return this.aRas;
    }

    @Override
    public synchronized BufferedImage decodeAsBufferedImage() throws ImageFormatException {
        try {
            this.param = this.readJPEGStream(this.input, this.param, true);
        }
        catch (IOException e) {
            System.out.println("Can't open input Stream" + e);
            e.printStackTrace();
        }
        return this.aBufImg;
    }

    private native void initDecoder(Class var1);

    private synchronized native JPEGDecodeParam readJPEGStream(InputStream var1, JPEGDecodeParam var2, boolean var3) throws IOException, ImageFormatException;

    private void readTables() throws IOException {
        try {
            this.param = this.readJPEGStream(this.input, null, false);
        }
        catch (ImageFormatException ife) {
            ife.printStackTrace();
        }
    }

    private int getDecodedColorModel(int colorID, boolean convert) throws ImageFormatException {
        int[] bits1 = new int[]{8};
        int[] bits3 = new int[]{8, 8, 8};
        int[] bits4 = new int[]{8, 8, 8, 8};
        this.cm = null;
        this.unpack = false;
        this.flip = false;
        if (!convert) {
            return colorID;
        }
        switch (colorID) {
            case 1: {
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1003), bits1, false, false, 1, 0);
                return colorID;
            }
            case 5: {
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1002), bits3, false, false, 1, 0);
                return colorID;
            }
            case 10: {
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1002), bits4, true, false, 3, 0);
                return colorID;
            }
            case 2: 
            case 3: {
                this.unpack = true;
                this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                return 2;
            }
            case 8: 
            case 9: {
                this.flip = true;
            }
            case 6: 
            case 7: {
                this.unpack = true;
                this.cm = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                return 6;
            }
        }
        throw new ImageFormatException("Can't construct a BufferedImage for given COLOR_ID");
    }

    private Object allocateDataBuffer(int imgWidth, int imgHeight, int imgComponents) {
        Object[] data;
        if (this.unpack) {
            if (imgComponents == 3) {
                int[] masks = new int[]{0xFF0000, 65280, 255};
                this.aRas = Raster.createPackedRaster(3, imgWidth, imgHeight, masks, new Point(0, 0));
            } else if (imgComponents == 4) {
                int[] masks = new int[]{0xFF0000, 65280, 255, -16777216};
                this.aRas = Raster.createPackedRaster(3, imgWidth, imgHeight, masks, new Point(0, 0));
            } else {
                throw new ImageFormatException("Can't unpack with anything other than 3 or 4 components");
            }
            data = ((DataBufferInt)this.aRas.getDataBuffer()).getData();
        } else {
            this.aRas = Raster.createInterleavedRaster(0, imgWidth, imgHeight, imgComponents, new Point(0, 0));
            data = ((DataBufferByte)this.aRas.getDataBuffer()).getData();
        }
        if (this.cm != null) {
            this.aBufImg = new BufferedImage(this.cm, this.aRas, true, null);
        }
        return data;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("jpeg");
                return null;
            }
        });
    }
}

