/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RescaleOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.image.codec.JPEGParam;

public class JPEGImageEncoderImpl
implements JPEGImageEncoder {
    private OutputStream outStream = null;
    private JPEGParam param = null;
    private boolean pack = false;
    private static final Class OutputStreamClass = OutputStream.class;

    public JPEGImageEncoderImpl(OutputStream dest) {
        if (dest == null) {
            throw new IllegalArgumentException("OutputStream is null.");
        }
        this.outStream = dest;
        this.initEncoder(OutputStreamClass);
    }

    public JPEGImageEncoderImpl(OutputStream dest, JPEGEncodeParam jep) {
        this(dest);
        this.setJPEGEncodeParam(jep);
    }

    @Override
    public int getDefaultColorId(ColorModel cm) {
        boolean alpha = cm.hasAlpha();
        ColorSpace cs = cm.getColorSpace();
        ColorSpace csPYCC = null;
        switch (cs.getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                if (alpha) {
                    return 7;
                }
                return 3;
            }
            case 3: {
                if (csPYCC == null) {
                    try {
                        csPYCC = ColorSpace.getInstance(1002);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (cs == csPYCC) {
                    return alpha ? 10 : 5;
                }
                return alpha ? 7 : 3;
            }
            case 9: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        return this.outStream;
    }

    @Override
    public synchronized void setJPEGEncodeParam(JPEGEncodeParam jep) {
        this.param = new JPEGParam(jep);
    }

    @Override
    public synchronized JPEGEncodeParam getJPEGEncodeParam() {
        return (JPEGEncodeParam)this.param.clone();
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(Raster ras, int colorID) {
        JPEGParam ret = new JPEGParam(colorID, ras.getNumBands());
        ret.setWidth(ras.getWidth());
        ret.setHeight(ras.getHeight());
        return ret;
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        int colorID = this.getDefaultColorId(cm);
        if (!(cm instanceof IndexColorModel)) {
            return this.getDefaultJPEGEncodeParam(bi.getRaster(), colorID);
        }
        JPEGParam ret = cm.hasAlpha() ? new JPEGParam(colorID, 4) : new JPEGParam(colorID, 3);
        ret.setWidth(bi.getWidth());
        ret.setHeight(bi.getHeight());
        return ret;
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(int numBands, int colorID) {
        return new JPEGParam(colorID, numBands);
    }

    @Override
    public JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jdp) throws ImageFormatException {
        return new JPEGParam(jdp);
    }

    @Override
    public synchronized void encode(BufferedImage bi) throws IOException, ImageFormatException {
        if (this.param == null) {
            this.setJPEGEncodeParam(this.getDefaultJPEGEncodeParam(bi));
        }
        if (bi.getWidth() != this.param.getWidth() || bi.getHeight() != this.param.getHeight()) {
            throw new ImageFormatException("Param block's width/height doesn't match the BufferedImage");
        }
        if (this.param.getEncodedColorID() != this.getDefaultColorId(bi.getColorModel())) {
            throw new ImageFormatException("The encoded COLOR_ID doesn't match the BufferedImage");
        }
        WritableRaster dataSrc = bi.getRaster();
        ColorModel cm = bi.getColorModel();
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            bi = icm.convertToIntDiscrete(dataSrc, false);
            dataSrc = bi.getRaster();
            cm = bi.getColorModel();
        }
        this.encode((Raster)dataSrc, cm);
    }

    @Override
    public synchronized void encode(BufferedImage bi, JPEGEncodeParam jep) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(jep);
        this.encode(bi);
    }

    @Override
    public void encode(Raster ras) throws IOException, ImageFormatException {
        if (this.param == null) {
            this.setJPEGEncodeParam(this.getDefaultJPEGEncodeParam(ras, 0));
        }
        if (ras.getNumBands() != ras.getSampleModel().getNumBands()) {
            throw new ImageFormatException("Raster's number of bands doesn't match the SampleModel");
        }
        if (ras.getWidth() != this.param.getWidth() || ras.getHeight() != this.param.getHeight()) {
            throw new ImageFormatException("Param block's width/height doesn't match the Raster");
        }
        if (this.param.getEncodedColorID() != 0 && this.param.getNumComponents() != ras.getNumBands()) {
            throw new ImageFormatException("Param block's COLOR_ID doesn't match the Raster.");
        }
        this.encode(ras, (ColorModel)null);
    }

    @Override
    public void encode(Raster ras, JPEGEncodeParam jep) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(jep);
        this.encode(ras);
    }

    private boolean useGiven(Raster ras) {
        SampleModel sm = ras.getSampleModel();
        if (sm.getDataType() != 0) {
            return false;
        }
        if (!(sm instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)sm;
        if (csm.getPixelStride() != sm.getNumBands()) {
            return false;
        }
        int[] offsets = csm.getBandOffsets();
        for (int i = 0; i < offsets.length; ++i) {
            if (offsets[i] == i) continue;
            return false;
        }
        return true;
    }

    private boolean canPack(Raster ras) {
        SampleModel sm = ras.getSampleModel();
        if (sm.getDataType() != 3) {
            return false;
        }
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
        int[] need = new int[]{0xFF0000, 65280, 255, -16777216};
        int[] masks = sppsm.getBitMasks();
        if (masks.length != 3 && masks.length != 4) {
            return false;
        }
        for (int i = 0; i < masks.length; ++i) {
            if (masks[i] == need[i]) continue;
            return false;
        }
        return true;
    }

    private void encode(Raster ras, ColorModel cm) throws IOException, ImageFormatException {
        Object[] data;
        int line;
        int start;
        int i;
        SampleModel sm = ras.getSampleModel();
        int numBands = sm.getNumBands();
        if (cm == null) {
            for (i = 0; i < numBands; ++i) {
                if (sm.getSampleSize(i) <= 8) continue;
                throw new ImageFormatException("JPEG encoder can only accept 8 bit data.");
            }
        }
        int colorID = this.param.getEncodedColorID();
        switch (this.param.getNumComponents()) {
            case 1: {
                if (colorID == 1 || colorID == 0 || this.param.findAPP0() == null) break;
                throw new ImageFormatException("1 band JFIF files imply Y or unknown encoding.\nParam block indicates alternate encoding.");
            }
            case 3: {
                if (colorID == 3 || this.param.findAPP0() == null) break;
                throw new ImageFormatException("3 band JFIF files imply YCbCr encoding.\nParam block indicates alternate encoding.");
            }
            case 4: {
                if (colorID == 4 || this.param.findAPP0() == null) break;
                throw new ImageFormatException("4 band JFIF files imply CMYK encoding.\nParam block indicates alternate encoding.");
            }
        }
        if (!this.param.isImageInfoValid()) {
            this.writeJPEGStream(this.param, cm, this.outStream, null, 0, 0);
            return;
        }
        DataBuffer db = ras.getDataBuffer();
        boolean premult = false;
        boolean cmok = true;
        int[] cmbits = null;
        if (cm != null) {
            if (cm.hasAlpha() && cm.isAlphaPremultiplied()) {
                premult = true;
                cmok = false;
            }
            cmbits = cm.getComponentSize();
            for (i = 0; i < numBands; ++i) {
                if (cmbits[i] == 8) continue;
                cmok = false;
            }
        }
        this.pack = false;
        if (cmok && this.useGiven(ras)) {
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            start = db.getOffset() + csm.getOffset(ras.getMinX() - ras.getSampleModelTranslateX(), ras.getMinY() - ras.getSampleModelTranslateY());
            line = csm.getScanlineStride();
            data = ((DataBufferByte)db).getData();
        } else if (cmok && this.canPack(ras)) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
            start = db.getOffset() + sppsm.getOffset(ras.getMinX() - ras.getSampleModelTranslateX(), ras.getMinY() - ras.getSampleModelTranslateY());
            line = sppsm.getScanlineStride();
            data = ((DataBufferInt)db).getData();
            this.pack = true;
        } else {
            int[] offsets = new int[numBands];
            float[] rsfactors = new float[numBands];
            for (i = 0; i < numBands; ++i) {
                offsets[i] = i;
                if (cmok) continue;
                rsfactors[i] = cmbits[i] != 8 ? 255.0f / (float)((1 << cmbits[i]) - 1) : 1.0f;
            }
            ComponentSampleModel csm = new ComponentSampleModel(0, ras.getWidth(), ras.getHeight(), numBands, numBands * ras.getWidth(), offsets);
            WritableRaster wr = Raster.createWritableRaster(csm, new Point(ras.getMinX(), ras.getMinY()));
            if (cmok) {
                wr.setRect(ras);
            } else {
                float[] rsoffsets = new float[numBands];
                RescaleOp rsop = new RescaleOp(rsfactors, rsoffsets, null);
                rsop.filter(ras, wr);
                if (premult) {
                    int[] bits = new int[numBands];
                    for (i = 0; i < numBands; ++i) {
                        bits[i] = 8;
                    }
                    ComponentColorModel ccm = new ComponentColorModel(cm.getColorSpace(), bits, true, true, 3, 0);
                    ccm.coerceData(wr, false);
                }
            }
            db = wr.getDataBuffer();
            data = ((DataBufferByte)db).getData();
            start = db.getOffset() + csm.getOffset(0, 0);
            line = csm.getScanlineStride();
        }
        this.verify(start, line, db.getSize());
        this.writeJPEGStream(this.param, cm, this.outStream, data, start, line);
    }

    private void verify(int start, int scanlineStride, int dbSize) throws ImageFormatException {
        int pixelStride;
        int width = this.param.getWidth();
        int height = this.param.getHeight();
        int n = pixelStride = this.pack ? 1 : this.param.getNumComponents();
        if (width <= 0 || height <= 0 || height > Integer.MAX_VALUE / width) {
            throw new ImageFormatException("Invalid image dimensions");
        }
        if (scanlineStride < 0 || scanlineStride > Integer.MAX_VALUE / height || scanlineStride > dbSize) {
            throw new ImageFormatException("Invalid scanline stride: " + scanlineStride);
        }
        int lastScanOffset = (height - 1) * scanlineStride;
        if (pixelStride < 0 || pixelStride > Integer.MAX_VALUE / width || pixelStride > dbSize || pixelStride * width > scanlineStride) {
            throw new ImageFormatException("Invalid pixel stride: " + pixelStride);
        }
        int scanlineSize = width * pixelStride;
        if (scanlineSize > Integer.MAX_VALUE - lastScanOffset) {
            throw new ImageFormatException("Invalid raster attributes");
        }
        int imageSize = lastScanOffset + scanlineSize;
        if (start < 0 || start > Integer.MAX_VALUE - imageSize) {
            throw new ImageFormatException("Invalid data offset");
        }
        int size = start + imageSize;
        if (size > dbSize) {
            throw new ImageFormatException("Computed buffer size doesn't match DataBuffer");
        }
    }

    private int getNearestColorId(ColorModel cm) {
        ColorSpace cs = cm.getColorSpace();
        switch (cs.getType()) {
            case 5: {
                if (cm.hasAlpha()) {
                    return 6;
                }
                return 2;
            }
        }
        return this.getDefaultColorId(cm);
    }

    private native void initEncoder(Class var1);

    private synchronized native void writeJPEGStream(JPEGEncodeParam var1, ColorModel var2, OutputStream var3, Object var4, int var5, int var6) throws IOException, ImageFormatException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("jpeg");
                return null;
            }
        });
    }
}

