/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGHuffmanTable;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Enumeration;
import java.util.Vector;

public class JPEGParam
implements JPEGEncodeParam,
Cloneable {
    private static int[] defComponents = new int[]{-1, 1, 3, 3, 4, 3, 4, 4, 4, 4, 4, 4};
    private static int[][] stdCompMapping = new int[][]{{0, 0, 0, 0}, {0}, {0, 0, 0}, {0, 1, 1}, {0, 0, 0, 0}, {0, 1, 1}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}};
    private static int[][] stdSubsample = new int[][]{{1, 1, 1, 1}, {1}, {1, 1, 1}, {1, 2, 2}, {1, 1, 1, 1}, {1, 2, 2}, {1, 1, 1, 1}, {1, 2, 2, 1}, {1, 1, 1, 1}, {1, 2, 2, 1}, {1, 2, 2, 1}, {1, 2, 2, 1}};
    private int width;
    private int height;
    private int encodedColorID;
    private int numComponents;
    private byte[][][] appMarkers;
    private byte[][] comMarker;
    private boolean imageInfoValid;
    private boolean tableInfoValid;
    private int[] horizontalSubsampling;
    private int[] verticalSubsampling;
    private JPEGQTable[] qTables;
    private int[] qTableMapping;
    private JPEGHuffmanTable[] dcHuffTables;
    private int[] dcHuffMapping;
    private JPEGHuffmanTable[] acHuffTables;
    private int[] acHuffMapping;
    private int restartInterval;
    private static final int app0Length = 14;

    public JPEGParam(int colorID) {
        this(colorID, defComponents[colorID]);
    }

    public JPEGParam(JPEGDecodeParam src) {
        this(src.getEncodedColorID(), src.getNumComponents());
        this.copy(src);
    }

    public JPEGParam(JPEGEncodeParam src) {
        this(src.getEncodedColorID(), src.getNumComponents());
        this.copy(src);
    }

    public JPEGParam(int colorID, int numComponents) {
        if (colorID != 0 && numComponents != defComponents[colorID]) {
            throw new IllegalArgumentException("NumComponents not in sync with COLOR_ID");
        }
        this.qTables = new JPEGQTable[4];
        this.acHuffTables = new JPEGHuffmanTable[4];
        this.dcHuffTables = new JPEGHuffmanTable[4];
        for (int i = 0; i < 4; ++i) {
            this.qTables[i] = null;
            this.dcHuffTables[i] = null;
            this.acHuffTables[i] = null;
        }
        this.comMarker = null;
        this.appMarkers = new byte[16][][];
        this.numComponents = numComponents;
        this.setDefaults(colorID);
    }

    private void copy(JPEGDecodeParam src) {
        int i;
        if (this.getEncodedColorID() != src.getEncodedColorID()) {
            throw new IllegalArgumentException("Argument to copy must match current COLOR_ID");
        }
        if (this.getNumComponents() != src.getNumComponents()) {
            throw new IllegalArgumentException("Argument to copy must match in number of components");
        }
        this.setWidth(src.getWidth());
        this.setHeight(src.getHeight());
        for (i = 224; i < 239; ++i) {
            this.setMarkerData(i, JPEGParam.copyArrays(src.getMarkerData(i)));
        }
        this.setMarkerData(254, JPEGParam.copyArrays(src.getMarkerData(254)));
        this.setTableInfoValid(src.isTableInfoValid());
        this.setImageInfoValid(src.isImageInfoValid());
        this.setRestartInterval(src.getRestartInterval());
        for (i = 0; i < 4; ++i) {
            this.setDCHuffmanTable(i, src.getDCHuffmanTable(i));
            this.setACHuffmanTable(i, src.getACHuffmanTable(i));
            this.setQTable(i, src.getQTable(i));
        }
        for (i = 0; i < src.getNumComponents(); ++i) {
            this.setDCHuffmanComponentMapping(i, src.getDCHuffmanComponentMapping(i));
            this.setACHuffmanComponentMapping(i, src.getACHuffmanComponentMapping(i));
            this.setQTableComponentMapping(i, src.getQTableComponentMapping(i));
            this.setHorizontalSubsampling(i, src.getHorizontalSubsampling(i));
            this.setVerticalSubsampling(i, src.getVerticalSubsampling(i));
        }
    }

    private void copy(JPEGEncodeParam src) {
        this.copy((JPEGDecodeParam)src);
    }

    protected void setDefaults(int colorID) {
        this.encodedColorID = colorID;
        this.restartInterval = 0;
        boolean isJFIFcompatible = false;
        switch (this.numComponents) {
            case 1: {
                if (this.encodedColorID != 1 && this.encodedColorID != 0) break;
                isJFIFcompatible = true;
                break;
            }
            case 3: {
                if (this.encodedColorID != 3) break;
                isJFIFcompatible = true;
                break;
            }
            case 4: {
                if (this.encodedColorID != 4) break;
                isJFIFcompatible = true;
                break;
            }
        }
        if (isJFIFcompatible) {
            this.addMarkerData(224, JPEGParam.createDefaultAPP0Marker());
        }
        this.setTableInfoValid(true);
        this.setImageInfoValid(true);
        this.dcHuffTables[0] = JPEGHuffmanTable.StdDCLuminance;
        this.dcHuffTables[1] = JPEGHuffmanTable.StdDCChrominance;
        this.dcHuffMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.dcHuffMapping, 0, this.getNumComponents());
        this.acHuffTables[0] = JPEGHuffmanTable.StdACLuminance;
        this.acHuffTables[1] = JPEGHuffmanTable.StdACChrominance;
        this.acHuffMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.acHuffMapping, 0, this.getNumComponents());
        this.qTables[0] = JPEGQTable.StdLuminance.getScaledInstance(0.5f, true);
        this.qTables[1] = JPEGQTable.StdChrominance.getScaledInstance(0.5f, true);
        this.qTableMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.qTableMapping, 0, this.getNumComponents());
        this.horizontalSubsampling = new int[this.getNumComponents()];
        System.arraycopy(stdSubsample[this.encodedColorID], 0, this.horizontalSubsampling, 0, this.getNumComponents());
        this.verticalSubsampling = new int[this.getNumComponents()];
        System.arraycopy(stdSubsample[this.encodedColorID], 0, this.verticalSubsampling, 0, this.getNumComponents());
    }

    @Override
    public Object clone() {
        JPEGParam ret = new JPEGParam(this.getEncodedColorID(), this.getNumComponents());
        ret.copy(this);
        return ret;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getHorizontalSubsampling(int component) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.horizontalSubsampling[component];
    }

    @Override
    public int getVerticalSubsampling(int component) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.verticalSubsampling[component];
    }

    @Override
    public void setHorizontalSubsampling(int component, int subsample) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components: " + component);
        }
        if (subsample <= 0) {
            throw new IllegalArgumentException("SubSample factor must be positive: " + subsample);
        }
        this.horizontalSubsampling[component] = subsample;
    }

    @Override
    public void setVerticalSubsampling(int component, int subsample) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        if (subsample <= 0) {
            throw new IllegalArgumentException("SubSample factor must be positive.");
        }
        this.verticalSubsampling[component] = subsample;
    }

    @Override
    public JPEGQTable getQTable(int tableNum) {
        if (tableNum < 0 || tableNum >= 4) {
            throw new IllegalArgumentException("tableNum must be between 0 and 3.");
        }
        return this.qTables[tableNum];
    }

    @Override
    public JPEGQTable getQTableForComponent(int component) {
        if (component < 0 || component >= this.qTableMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getQTable(this.qTableMapping[component]);
    }

    @Override
    public JPEGHuffmanTable getDCHuffmanTable(int tableNum) {
        if (tableNum < 0 || tableNum >= 4) {
            throw new IllegalArgumentException("tableNum must be 0-3.");
        }
        return this.dcHuffTables[tableNum];
    }

    @Override
    public JPEGHuffmanTable getDCHuffmanTableForComponent(int component) {
        if (component < 0 || component >= this.dcHuffMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getDCHuffmanTable(this.dcHuffMapping[component]);
    }

    @Override
    public JPEGHuffmanTable getACHuffmanTable(int tableNum) {
        if (tableNum < 0 || tableNum >= 4) {
            throw new IllegalArgumentException("tableNum must be 0-3.");
        }
        return this.acHuffTables[tableNum];
    }

    @Override
    public JPEGHuffmanTable getACHuffmanTableForComponent(int component) {
        if (component < 0 || component >= this.acHuffMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getACHuffmanTable(this.acHuffMapping[component]);
    }

    @Override
    public void setQTable(int tableNum, JPEGQTable qTable) {
        if (tableNum < 0 || tableNum >= 4) {
            throw new IllegalArgumentException("tableNum must be between 0 and 3.");
        }
        this.qTables[tableNum] = qTable;
    }

    @Override
    public void setDCHuffmanTable(int tableNum, JPEGHuffmanTable huffTable) {
        if (tableNum < 0 || tableNum >= 4) {
            throw new IllegalArgumentException("tableNum must be 0, 1, 2, or 3.");
        }
        this.dcHuffTables[tableNum] = huffTable;
    }

    @Override
    public void setACHuffmanTable(int tableNum, JPEGHuffmanTable huffTable) {
        if (tableNum < 0 || tableNum >= 4) {
            throw new IllegalArgumentException("tableNum must be 0, 1, 2, or 3.");
        }
        this.acHuffTables[tableNum] = huffTable;
    }

    @Override
    public int getDCHuffmanComponentMapping(int component) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.dcHuffMapping[component];
    }

    @Override
    public int getACHuffmanComponentMapping(int component) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.acHuffMapping[component];
    }

    @Override
    public int getQTableComponentMapping(int component) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.qTableMapping[component];
    }

    @Override
    public void setDCHuffmanComponentMapping(int component, int table) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (table < 0 || table >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.dcHuffMapping[component] = table;
    }

    @Override
    public void setACHuffmanComponentMapping(int component, int table) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (table < 0 || table >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.acHuffMapping[component] = table;
    }

    @Override
    public void setQTableComponentMapping(int component, int table) {
        if (component < 0 || component >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (table < 0 || table >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.qTableMapping[component] = table;
    }

    @Override
    public boolean isImageInfoValid() {
        return this.imageInfoValid;
    }

    @Override
    public void setImageInfoValid(boolean flag) {
        this.imageInfoValid = flag;
    }

    @Override
    public boolean isTableInfoValid() {
        return this.tableInfoValid;
    }

    @Override
    public void setTableInfoValid(boolean flag) {
        this.tableInfoValid = flag;
    }

    @Override
    public boolean getMarker(int marker) {
        byte[][] data = null;
        if (marker == 254) {
            data = this.comMarker;
        } else if (marker >= 224 && marker <= 239) {
            data = this.appMarkers[marker - 224];
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + marker);
        }
        if (data == null) {
            return false;
        }
        return data.length != 0;
    }

    @Override
    public byte[][] getMarkerData(int marker) {
        if (marker == 254) {
            return this.comMarker;
        }
        if (marker >= 224 && marker <= 239) {
            return this.appMarkers[marker - 224];
        }
        throw new IllegalArgumentException("Invalid Marker ID:" + marker);
    }

    @Override
    public void setMarkerData(int marker, byte[][] data) {
        if (marker == 254) {
            this.comMarker = data;
        } else if (marker >= 224 && marker <= 239) {
            this.appMarkers[marker - 224] = data;
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + marker);
        }
    }

    @Override
    public void addMarkerData(int marker, byte[] data) {
        if (data == null) {
            return;
        }
        if (marker == 254) {
            this.comMarker = JPEGParam.appendArray(this.comMarker, data);
        } else if (marker >= 224 && marker <= 239) {
            this.appMarkers[marker - 224] = JPEGParam.appendArray(this.appMarkers[marker - 224], data);
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + marker);
        }
    }

    @Override
    public int getEncodedColorID() {
        return this.encodedColorID;
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    public static int getNumComponents(int id) {
        if (id < 0 || id >= 12) {
            throw new IllegalArgumentException("Invalid JPEGColorID.");
        }
        return defComponents[id];
    }

    @Override
    public int getRestartInterval() {
        return this.restartInterval;
    }

    @Override
    public void setRestartInterval(int restartInterval) {
        this.restartInterval = restartInterval;
    }

    @Override
    public int getDensityUnit() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] data = this.findAPP0();
        if (data == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        return data[7];
    }

    @Override
    public int getXDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] data = this.findAPP0();
        if (data == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        int ret = data[8] << 8 | data[9] & 0xFF;
        return ret;
    }

    @Override
    public int getYDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] data = this.findAPP0();
        if (data == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        int ret = data[10] << 8 | data[11] & 0xFF;
        return ret;
    }

    @Override
    public void setDensityUnit(int unit) {
        byte[] data = null;
        if (!this.getMarker(224)) {
            data = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, data);
        } else {
            data = this.findAPP0();
            if (data == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        data[7] = (byte)unit;
    }

    @Override
    public void setXDensity(int density) {
        byte[] data = null;
        if (!this.getMarker(224)) {
            data = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, data);
        } else {
            data = this.findAPP0();
            if (data == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        data[8] = (byte)(density >>> 8 & 0xFF);
        data[9] = (byte)(density & 0xFF);
    }

    @Override
    public void setYDensity(int density) {
        byte[] data = null;
        if (!this.getMarker(224)) {
            data = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, data);
        } else {
            data = this.findAPP0();
            if (data == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        data[10] = (byte)(density >>> 8 & 0xFF);
        data[11] = (byte)(density & 0xFF);
    }

    @Override
    public void setQuality(float quality, boolean forceBaseline) {
        double q = quality;
        if (q <= 0.01) {
            q = 0.01;
        }
        if (q > 1.0) {
            q = 1.0;
        }
        q = q < 0.5 ? 0.5 / q : 2.0 - q * 2.0;
        this.qTableMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.qTableMapping, 0, this.getNumComponents());
        JPEGQTable table = JPEGQTable.StdLuminance;
        this.qTables[0] = table.getScaledInstance((float)q, forceBaseline);
        table = JPEGQTable.StdChrominance;
        this.qTables[1] = table.getScaledInstance((float)q, forceBaseline);
        this.qTables[2] = null;
        this.qTables[3] = null;
    }

    byte[] findAPP0() {
        byte[][] data = null;
        data = this.getMarkerData(224);
        if (data == null) {
            return null;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null || !JPEGParam.checkAPP0(data[i])) continue;
            return data[i];
        }
        return null;
    }

    static boolean checkAPP0(byte[] data) {
        if (data.length < 14) {
            return false;
        }
        if (data[0] != 74 || data[1] != 70 || data[2] != 73 || data[3] != 70 || data[4] != 0) {
            return false;
        }
        return data[5] >= 1;
    }

    static byte[] createDefaultAPP0Marker() {
        byte[] ret = new byte[]{74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0};
        return ret;
    }

    static byte[] copyArray(byte[] src) {
        if (src == null) {
            return null;
        }
        byte[] ret = new byte[src.length];
        System.arraycopy(src, 0, ret, 0, src.length);
        return ret;
    }

    static byte[][] copyArrays(byte[][] in) {
        if (in == null) {
            return null;
        }
        byte[][] ret = new byte[in.length][];
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            ret[i] = JPEGParam.copyArray(in[i]);
        }
        return ret;
    }

    static byte[][] appendArray(byte[][] in, byte[] add) {
        int len = 0;
        if (in != null) {
            len = in.length;
        }
        byte[][] ret = new byte[len + 1][];
        for (int i = 0; i < len; ++i) {
            ret[i] = in[i];
        }
        if (add != null) {
            ret[len] = JPEGParam.copyArray(add);
        }
        return ret;
    }

    static byte[][] buildArray(Vector vec) {
        if (vec == null) {
            return null;
        }
        int i = 0;
        byte[][] ret = new byte[vec.size()][];
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            byte[] src = (byte[])e.nextElement();
            if (src == null) continue;
            ret[i++] = JPEGParam.copyArray(src);
        }
        return ret;
    }

    public static int getDefaultColorId(ColorModel cm) {
        boolean alpha = cm.hasAlpha();
        ColorSpace cs = cm.getColorSpace();
        ColorSpace csPYCC = null;
        switch (cs.getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                if (alpha) {
                    return 7;
                }
                return 3;
            }
            case 3: {
                if (csPYCC == null) {
                    try {
                        csPYCC = ColorSpace.getInstance(1002);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (cs == csPYCC) {
                    return alpha ? 10 : 5;
                }
                return alpha ? 7 : 3;
            }
            case 9: {
                return 4;
            }
        }
        return 0;
    }
}

