/*
 * Decompiled with CFR 0.152.
 */
package sun.dc;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import sun.awt.geom.PathConsumer2D;
import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;
import sun.dc.pr.Rasterizer;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;

public class DuctusRenderingEngine
extends RenderingEngine {
    static final float PenUnits = 0.01f;
    static final int MinPenUnits = 100;
    static final int MinPenUnitsAA = 20;
    static final float MinPenSizeAA = 0.19999999f;
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;
    private static final int[] RasterizerCaps = new int[]{30, 10, 20};
    private static final int[] RasterizerCorners = new int[]{50, 10, 40};
    private static Rasterizer theRasterizer;

    static float[] getTransformMatrix(AffineTransform transform) {
        float[] matrix = new float[4];
        double[] dmatrix = new double[6];
        transform.getMatrix(dmatrix);
        for (int i = 0; i < 4; ++i) {
            matrix[i] = (float)dmatrix[i];
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape createStrokedShape(Shape src, float width, int caps, int join, float miterlimit, float[] dashes, float dashphase) {
        FillAdapter filler = new FillAdapter();
        PathStroker stroker = new PathStroker(filler);
        PathDasher dasher = null;
        try {
            PathConsumer consumer;
            stroker.setPenDiameter(width);
            stroker.setPenT4(null);
            stroker.setCaps(RasterizerCaps[caps]);
            stroker.setCorners(RasterizerCorners[join], miterlimit);
            if (dashes != null) {
                dasher = new PathDasher(stroker);
                dasher.setDash(dashes, dashphase);
                dasher.setDashT4(null);
                consumer = dasher;
            } else {
                consumer = stroker;
            }
            this.feedConsumer(consumer, src.getPathIterator(null));
        }
        finally {
            stroker.dispose();
            if (dasher != null) {
                dasher.dispose();
            }
        }
        return filler.getShape();
    }

    @Override
    public void strokeTo(Shape src, AffineTransform transform, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, PathConsumer2D sr) {
        PathStroker stroker = new PathStroker(sr);
        PathConsumer consumer = stroker;
        float[] matrix = null;
        if (!thin) {
            stroker.setPenDiameter(bs.getLineWidth());
            if (transform != null) {
                matrix = DuctusRenderingEngine.getTransformMatrix(transform);
            }
            stroker.setPenT4(matrix);
            stroker.setPenFitting(0.01f, 100);
        }
        stroker.setCaps(RasterizerCaps[bs.getEndCap()]);
        stroker.setCorners(RasterizerCorners[bs.getLineJoin()], bs.getMiterLimit());
        float[] dashes = bs.getDashArray();
        if (dashes != null) {
            PathDasher dasher = new PathDasher(stroker);
            dasher.setDash(dashes, bs.getDashPhase());
            if (transform != null && matrix == null) {
                matrix = DuctusRenderingEngine.getTransformMatrix(transform);
            }
            dasher.setDashT4(matrix);
            consumer = dasher;
        }
        try {
            PathIterator pi = src.getPathIterator(transform);
            DuctusRenderingEngine.feedConsumer(pi, consumer, normalize, 0.25f);
        }
        catch (PathException e) {
            throw new InternalError("Unable to Stroke shape (" + e.getMessage() + ")", e);
        }
        finally {
            while (consumer != null && consumer != sr) {
                PathConsumer next = consumer.getConsumer();
                consumer.dispose();
                consumer = next;
            }
        }
    }

    public static void feedConsumer(PathIterator pi, PathConsumer consumer, boolean normalize, float norm) throws PathException {
        consumer.beginPath();
        boolean pathClosed = false;
        boolean skip = false;
        boolean subpathStarted = false;
        float mx = 0.0f;
        float my = 0.0f;
        float[] point = new float[6];
        float rnd = 0.5f - norm;
        float ax = 0.0f;
        float ay = 0.0f;
        while (!pi.isDone()) {
            int type = pi.currentSegment(point);
            if (pathClosed) {
                pathClosed = false;
                if (type != 0) {
                    consumer.beginSubpath(mx, my);
                    subpathStarted = true;
                }
            }
            if (normalize) {
                int index;
                switch (type) {
                    case 3: {
                        index = 4;
                        break;
                    }
                    case 2: {
                        index = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        index = 0;
                        break;
                    }
                    default: {
                        index = -1;
                    }
                }
                if (index >= 0) {
                    float ox = point[index];
                    float oy = point[index + 1];
                    float newax = (float)Math.floor(ox + rnd) + norm;
                    float neway = (float)Math.floor(oy + rnd) + norm;
                    point[index] = newax;
                    point[index + 1] = neway;
                    newax -= ox;
                    neway -= oy;
                    switch (type) {
                        case 3: {
                            point[0] = point[0] + ax;
                            point[1] = point[1] + ay;
                            point[2] = point[2] + newax;
                            point[3] = point[3] + neway;
                            break;
                        }
                        case 2: {
                            point[0] = point[0] + (newax + ax) / 2.0f;
                            point[1] = point[1] + (neway + ay) / 2.0f;
                            break;
                        }
                    }
                    ax = newax;
                    ay = neway;
                }
            }
            switch (type) {
                case 0: {
                    if (point[0] < 1.7014117E38f && point[0] > -1.7014117E38f && point[1] < 1.7014117E38f && point[1] > -1.7014117E38f) {
                        mx = point[0];
                        my = point[1];
                        consumer.beginSubpath(mx, my);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    skip = true;
                    break;
                }
                case 1: {
                    if (!(point[0] < 1.7014117E38f) || !(point[0] > -1.7014117E38f) || !(point[1] < 1.7014117E38f) || !(point[1] > -1.7014117E38f)) break;
                    if (skip) {
                        consumer.beginSubpath(point[0], point[1]);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    consumer.appendLine(point[0], point[1]);
                    break;
                }
                case 2: {
                    if (!(point[2] < 1.7014117E38f) || !(point[2] > -1.7014117E38f) || !(point[3] < 1.7014117E38f) || !(point[3] > -1.7014117E38f)) break;
                    if (skip) {
                        consumer.beginSubpath(point[2], point[3]);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    if (point[0] < 1.7014117E38f && point[0] > -1.7014117E38f && point[1] < 1.7014117E38f && point[1] > -1.7014117E38f) {
                        consumer.appendQuadratic(point[0], point[1], point[2], point[3]);
                        break;
                    }
                    consumer.appendLine(point[2], point[3]);
                    break;
                }
                case 3: {
                    if (!(point[4] < 1.7014117E38f) || !(point[4] > -1.7014117E38f) || !(point[5] < 1.7014117E38f) || !(point[5] > -1.7014117E38f)) break;
                    if (skip) {
                        consumer.beginSubpath(point[4], point[5]);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    if (point[0] < 1.7014117E38f && point[0] > -1.7014117E38f && point[1] < 1.7014117E38f && point[1] > -1.7014117E38f && point[2] < 1.7014117E38f && point[2] > -1.7014117E38f && point[3] < 1.7014117E38f && point[3] > -1.7014117E38f) {
                        consumer.appendCubic(point[0], point[1], point[2], point[3], point[4], point[5]);
                        break;
                    }
                    consumer.appendLine(point[4], point[5]);
                    break;
                }
                case 4: {
                    if (!subpathStarted) break;
                    consumer.closedSubpath();
                    subpathStarted = false;
                    pathClosed = true;
                }
            }
            pi.next();
        }
        consumer.endPath();
    }

    public static synchronized Rasterizer getRasterizer() {
        Rasterizer r = theRasterizer;
        if (r == null) {
            r = new Rasterizer();
        } else {
            theRasterizer = null;
        }
        return r;
    }

    public static synchronized void dropRasterizer(Rasterizer r) {
        r.reset();
        theRasterizer = r;
    }

    @Override
    public float getMinimumAAPenSize() {
        return 0.19999999f;
    }

    @Override
    public AATileGenerator getAATileGenerator(Shape s, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, int[] bbox) {
        Rasterizer r = DuctusRenderingEngine.getRasterizer();
        PathIterator pi = s.getPathIterator(at);
        if (bs != null) {
            float[] matrix = null;
            r.setUsage(3);
            if (thin) {
                r.setPenDiameter(0.19999999f);
            } else {
                r.setPenDiameter(bs.getLineWidth());
                if (at != null) {
                    matrix = DuctusRenderingEngine.getTransformMatrix(at);
                    r.setPenT4(matrix);
                }
                r.setPenFitting(0.01f, 20);
            }
            r.setCaps(RasterizerCaps[bs.getEndCap()]);
            r.setCorners(RasterizerCorners[bs.getLineJoin()], bs.getMiterLimit());
            float[] dashes = bs.getDashArray();
            if (dashes != null) {
                r.setDash(dashes, bs.getDashPhase());
                if (at != null && matrix == null) {
                    matrix = DuctusRenderingEngine.getTransformMatrix(at);
                }
                r.setDashT4(matrix);
            }
        } else {
            r.setUsage(pi.getWindingRule() == 0 ? 1 : 2);
        }
        r.beginPath();
        boolean pathClosed = false;
        boolean skip = false;
        boolean subpathStarted = false;
        float mx = 0.0f;
        float my = 0.0f;
        float[] point = new float[6];
        float ax = 0.0f;
        float ay = 0.0f;
        while (!pi.isDone()) {
            int type = pi.currentSegment(point);
            if (pathClosed) {
                pathClosed = false;
                if (type != 0) {
                    r.beginSubpath(mx, my);
                    subpathStarted = true;
                }
            }
            if (normalize) {
                int index;
                switch (type) {
                    case 3: {
                        index = 4;
                        break;
                    }
                    case 2: {
                        index = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        index = 0;
                        break;
                    }
                    default: {
                        index = -1;
                    }
                }
                if (index >= 0) {
                    float ox = point[index];
                    float oy = point[index + 1];
                    float newax = (float)Math.floor(ox) + 0.5f;
                    float neway = (float)Math.floor(oy) + 0.5f;
                    point[index] = newax;
                    point[index + 1] = neway;
                    newax -= ox;
                    neway -= oy;
                    switch (type) {
                        case 3: {
                            point[0] = point[0] + ax;
                            point[1] = point[1] + ay;
                            point[2] = point[2] + newax;
                            point[3] = point[3] + neway;
                            break;
                        }
                        case 2: {
                            point[0] = point[0] + (newax + ax) / 2.0f;
                            point[1] = point[1] + (neway + ay) / 2.0f;
                            break;
                        }
                    }
                    ax = newax;
                    ay = neway;
                }
            }
            switch (type) {
                case 0: {
                    if (point[0] < 1.7014117E38f && point[0] > -1.7014117E38f && point[1] < 1.7014117E38f && point[1] > -1.7014117E38f) {
                        mx = point[0];
                        my = point[1];
                        r.beginSubpath(mx, my);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    skip = true;
                    break;
                }
                case 1: {
                    if (!(point[0] < 1.7014117E38f) || !(point[0] > -1.7014117E38f) || !(point[1] < 1.7014117E38f) || !(point[1] > -1.7014117E38f)) break;
                    if (skip) {
                        r.beginSubpath(point[0], point[1]);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    r.appendLine(point[0], point[1]);
                    break;
                }
                case 2: {
                    if (!(point[2] < 1.7014117E38f) || !(point[2] > -1.7014117E38f) || !(point[3] < 1.7014117E38f) || !(point[3] > -1.7014117E38f)) break;
                    if (skip) {
                        r.beginSubpath(point[2], point[3]);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    if (point[0] < 1.7014117E38f && point[0] > -1.7014117E38f && point[1] < 1.7014117E38f && point[1] > -1.7014117E38f) {
                        r.appendQuadratic(point[0], point[1], point[2], point[3]);
                        break;
                    }
                    r.appendLine(point[2], point[3]);
                    break;
                }
                case 3: {
                    if (!(point[4] < 1.7014117E38f) || !(point[4] > -1.7014117E38f) || !(point[5] < 1.7014117E38f) || !(point[5] > -1.7014117E38f)) break;
                    if (skip) {
                        r.beginSubpath(point[4], point[5]);
                        subpathStarted = true;
                        skip = false;
                        break;
                    }
                    if (point[0] < 1.7014117E38f && point[0] > -1.7014117E38f && point[1] < 1.7014117E38f && point[1] > -1.7014117E38f && point[2] < 1.7014117E38f && point[2] > -1.7014117E38f && point[3] < 1.7014117E38f && point[3] > -1.7014117E38f) {
                        r.appendCubic(point[0], point[1], point[2], point[3], point[4], point[5]);
                        break;
                    }
                    r.appendLine(point[4], point[5]);
                    break;
                }
                case 4: {
                    if (!subpathStarted) break;
                    r.closedSubpath();
                    subpathStarted = false;
                    pathClosed = true;
                }
            }
            pi.next();
        }
        try {
            r.endPath();
            r.getAlphaBox(bbox);
            clip.clipBoxToBounds(bbox);
            if (bbox[0] >= bbox[2] || bbox[1] >= bbox[3]) {
                DuctusRenderingEngine.dropRasterizer(r);
                return null;
            }
            r.setOutputArea(bbox[0], bbox[1], bbox[2] - bbox[0], bbox[3] - bbox[1]);
        }
        catch (PRException e) {
            System.err.println("DuctusRenderingEngine.getAATileGenerator: " + e);
        }
        return r;
    }

    @Override
    public AATileGenerator getAATileGenerator(double x, double y, double dx1, double dy1, double dx2, double dy2, double lw1, double lw2, Region clip, int[] bbox) {
        double ldy2;
        double ldx2;
        double ldy1;
        double ldx1;
        boolean innerpgram;
        boolean bl = innerpgram = lw1 > 0.0 && lw2 > 0.0;
        if (innerpgram) {
            ldx1 = dx1 * lw1;
            ldy1 = dy1 * lw1;
            ldx2 = dx2 * lw2;
            ldy2 = dy2 * lw2;
            x -= (ldx1 + ldx2) / 2.0;
            y -= (ldy1 + ldy2) / 2.0;
            dx1 += ldx1;
            dy1 += ldy1;
            dx2 += ldx2;
            dy2 += ldy2;
            if (lw1 > 1.0 && lw2 > 1.0) {
                innerpgram = false;
            }
        } else {
            ldy2 = 0.0;
            ldx2 = 0.0;
            ldy1 = 0.0;
            ldx1 = 0.0;
        }
        Rasterizer r = DuctusRenderingEngine.getRasterizer();
        r.setUsage(1);
        r.beginPath();
        r.beginSubpath((float)x, (float)y);
        r.appendLine((float)(x + dx1), (float)(y + dy1));
        r.appendLine((float)(x + dx1 + dx2), (float)(y + dy1 + dy2));
        r.appendLine((float)(x + dx2), (float)(y + dy2));
        r.closedSubpath();
        if (innerpgram) {
            r.beginSubpath((float)(x += ldx1 + ldx2), (float)(y += ldy1 + ldy2));
            r.appendLine((float)(x + (dx1 -= 2.0 * ldx1)), (float)(y + (dy1 -= 2.0 * ldy1)));
            r.appendLine((float)(x + dx1 + (dx2 -= 2.0 * ldx2)), (float)(y + dy1 + (dy2 -= 2.0 * ldy2)));
            r.appendLine((float)(x + dx2), (float)(y + dy2));
            r.closedSubpath();
        }
        try {
            r.endPath();
            r.getAlphaBox(bbox);
            clip.clipBoxToBounds(bbox);
            if (bbox[0] >= bbox[2] || bbox[1] >= bbox[3]) {
                DuctusRenderingEngine.dropRasterizer(r);
                return null;
            }
            r.setOutputArea(bbox[0], bbox[1], bbox[2] - bbox[0], bbox[3] - bbox[1]);
        }
        catch (PRException e) {
            System.err.println("DuctusRenderingEngine.getAATileGenerator: " + e);
        }
        return r;
    }

    private void feedConsumer(PathConsumer consumer, PathIterator pi) {
        try {
            consumer.beginPath();
            boolean pathClosed = false;
            float mx = 0.0f;
            float my = 0.0f;
            float[] point = new float[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(point);
                if (pathClosed) {
                    pathClosed = false;
                    if (type != 0) {
                        consumer.beginSubpath(mx, my);
                    }
                }
                switch (type) {
                    case 0: {
                        mx = point[0];
                        my = point[1];
                        consumer.beginSubpath(point[0], point[1]);
                        break;
                    }
                    case 1: {
                        consumer.appendLine(point[0], point[1]);
                        break;
                    }
                    case 2: {
                        consumer.appendQuadratic(point[0], point[1], point[2], point[3]);
                        break;
                    }
                    case 3: {
                        consumer.appendCubic(point[0], point[1], point[2], point[3], point[4], point[5]);
                        break;
                    }
                    case 4: {
                        consumer.closedSubpath();
                        pathClosed = true;
                    }
                }
                pi.next();
            }
            consumer.endPath();
        }
        catch (PathException e) {
            throw new InternalError("Unable to Stroke shape (" + e.getMessage() + ")", e);
        }
    }

    private class FillAdapter
    implements PathConsumer {
        boolean closed;
        Path2D.Float path = new Path2D.Float(1);

        public Shape getShape() {
            return this.path;
        }

        @Override
        public void dispose() {
        }

        @Override
        public PathConsumer getConsumer() {
            return null;
        }

        @Override
        public void beginPath() {
        }

        @Override
        public void beginSubpath(float x0, float y0) {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
            this.path.moveTo(x0, y0);
        }

        @Override
        public void appendLine(float x1, float y1) {
            this.path.lineTo(x1, y1);
        }

        @Override
        public void appendQuadratic(float xm, float ym, float x1, float y1) {
            this.path.quadTo(xm, ym, x1, y1);
        }

        @Override
        public void appendCubic(float xm, float ym, float xn, float yn, float x1, float y1) {
            this.path.curveTo(xm, ym, xn, yn, x1, y1);
        }

        @Override
        public void closedSubpath() {
            this.closed = true;
        }

        @Override
        public void endPath() {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
        }

        @Override
        public void useProxy(FastPathProducer proxy) throws PathException {
            proxy.sendTo(this);
        }

        @Override
        public long getCPathConsumer() {
            return 0L;
        }
    }
}

