/*
 * Decompiled with CFR 0.152.
 */
package sun.dc.pr;

import sun.dc.DuctusRenderingEngine;
import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathError;
import sun.dc.path.PathException;
import sun.dc.pr.PRError;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathFiller;
import sun.dc.pr.PathStroker;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.pipe.AATileGenerator;

public class Rasterizer
implements AATileGenerator {
    public static final int EOFILL = 1;
    public static final int NZFILL = 2;
    public static final int STROKE = 3;
    public static final int ROUND = 10;
    public static final int SQUARE = 20;
    public static final int BUTT = 30;
    public static final int BEVEL = 40;
    public static final int MITER = 50;
    public static final int TILE_SIZE = 1 << PathFiller.tileSizeL2S;
    public static final int TILE_SIZE_L2S = PathFiller.tileSizeL2S;
    public static final int MAX_ALPHA = 1000000;
    public static final int MAX_MITER = 10;
    public static final int MAX_WN = 63;
    public static final int TILE_IS_ALL_0 = 0;
    public static final int TILE_IS_ALL_1 = 1;
    public static final int TILE_IS_GENERAL = 2;
    private static final int BEG = 1;
    private static final int PAC_FILL = 2;
    private static final int PAC_STROKE = 3;
    private static final int PATH = 4;
    private static final int SUBPATH = 5;
    private static final int RAS = 6;
    private int state = 1;
    private PathFiller filler = new PathFiller();
    private PathStroker stroker = new PathStroker(this.filler);
    private PathDasher dasher = new PathDasher(this.stroker);
    private PathConsumer curPC;

    public Rasterizer() {
        Disposer.addRecord(this, new ConsumerDisposer(this.filler, this.stroker, this.dasher));
    }

    public void setUsage(int usage) throws PRError {
        if (this.state != 1) {
            throw new PRError("setUsage: unexpected");
        }
        if (usage == 1) {
            this.filler.setFillMode(1);
            this.curPC = this.filler;
            this.state = 2;
        } else if (usage == 2) {
            this.filler.setFillMode(2);
            this.curPC = this.filler;
            this.state = 2;
        } else if (usage == 3) {
            this.curPC = this.stroker;
            this.filler.setFillMode(2);
            this.stroker.setPenDiameter(1.0f);
            this.stroker.setPenT4(null);
            this.stroker.setCaps(10);
            this.stroker.setCorners(10, 0.0f);
            this.state = 3;
        } else {
            throw new PRError("setUsage: unknown usage type");
        }
    }

    public void setPenDiameter(float d) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenDiameter: unexpected");
        }
        this.stroker.setPenDiameter(d);
    }

    public void setPenT4(float[] t4) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenT4: unexpected");
        }
        this.stroker.setPenT4(t4);
    }

    public void setPenFitting(float unit, int mindiameter) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenFitting: unexpected");
        }
        this.stroker.setPenFitting(unit, mindiameter);
    }

    public void setPenDisplacement(float dx, float dy) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenDisplacement: unexpected");
        }
        float[] t6 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, dx, dy};
        this.stroker.setOutputT6(t6);
    }

    public void setCaps(int caps) throws PRError {
        if (this.state != 3) {
            throw new PRError("setCaps: unexpected");
        }
        this.stroker.setCaps(caps);
    }

    public void setCorners(int corners, float miter) throws PRError {
        if (this.state != 3) {
            throw new PRError("setCorners: unexpected");
        }
        this.stroker.setCorners(corners, miter);
    }

    public void setDash(float[] dash, float offset) throws PRError {
        if (this.state != 3) {
            throw new PRError("setDash: unexpected");
        }
        this.dasher.setDash(dash, offset);
        this.curPC = this.dasher;
    }

    public void setDashT4(float[] dasht4) throws PRError {
        if (this.state != 3) {
            throw new PRError("setDashT4: unexpected");
        }
        this.dasher.setDashT4(dasht4);
    }

    public void beginPath(float[] box) throws PRError {
        this.beginPath();
    }

    public void beginPath() throws PRError {
        if (this.state != 2 && this.state != 3) {
            throw new PRError("beginPath: unexpected");
        }
        try {
            this.curPC.beginPath();
            this.state = 4;
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
    }

    public void beginSubpath(float x0, float y0) throws PRError {
        if (this.state != 4 && this.state != 5) {
            throw new PRError("beginSubpath: unexpected");
        }
        try {
            this.curPC.beginSubpath(x0, y0);
            this.state = 5;
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
    }

    public void appendLine(float x1, float y1) throws PRError {
        if (this.state != 5) {
            throw new PRError("appendLine: unexpected");
        }
        try {
            this.curPC.appendLine(x1, y1);
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
    }

    public void appendQuadratic(float xm, float ym, float x1, float y1) throws PRError {
        if (this.state != 5) {
            throw new PRError("appendQuadratic: unexpected");
        }
        try {
            this.curPC.appendQuadratic(xm, ym, x1, y1);
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
    }

    public void appendCubic(float xm, float ym, float xn, float yn, float x1, float y1) throws PRError {
        if (this.state != 5) {
            throw new PRError("appendCubic: unexpected");
        }
        try {
            this.curPC.appendCubic(xm, ym, xn, yn, x1, y1);
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
    }

    public void closedSubpath() throws PRError {
        if (this.state != 5) {
            throw new PRError("closedSubpath: unexpected");
        }
        try {
            this.curPC.closedSubpath();
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
    }

    public void endPath() throws PRError, PRException {
        if (this.state != 4 && this.state != 5) {
            throw new PRError("endPath: unexpected");
        }
        try {
            this.curPC.endPath();
            this.state = 6;
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
        catch (PathException e) {
            throw new PRException(e.getMessage());
        }
    }

    public void useProxy(FastPathProducer proxy) throws PRError, PRException {
        if (this.state != 2 && this.state != 3) {
            throw new PRError("useProxy: unexpected");
        }
        try {
            this.curPC.useProxy(proxy);
            this.state = 6;
        }
        catch (PathError e) {
            throw new PRError(e.getMessage());
        }
        catch (PathException e) {
            throw new PRException(e.getMessage());
        }
    }

    public void getAlphaBox(int[] box) throws PRError {
        this.filler.getAlphaBox(box);
    }

    public void setOutputArea(float x0, float y0, int w, int h) throws PRError, PRException {
        this.filler.setOutputArea(x0, y0, w, h);
    }

    public int getTileState() throws PRError {
        return this.filler.getTileState();
    }

    public void writeAlpha(byte[] alpha, int xstride, int ystride, int pix0offset) throws PRError, PRException, InterruptedException {
        this.filler.writeAlpha(alpha, xstride, ystride, pix0offset);
    }

    public void writeAlpha(char[] alpha, int xstride, int ystride, int pix0offset) throws PRError, PRException, InterruptedException {
        this.filler.writeAlpha(alpha, xstride, ystride, pix0offset);
    }

    @Override
    public void nextTile() throws PRError {
        this.filler.nextTile();
    }

    public void reset() {
        this.state = 1;
        this.filler.reset();
        this.stroker.reset();
        this.dasher.reset();
    }

    @Override
    public int getTileWidth() {
        return TILE_SIZE;
    }

    @Override
    public int getTileHeight() {
        return TILE_SIZE;
    }

    @Override
    public int getTypicalAlpha() {
        int s = this.filler.getTileState();
        switch (s) {
            case 0: {
                s = 0;
                break;
            }
            case 1: {
                s = 255;
                break;
            }
            case 2: {
                s = 128;
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAlpha(byte[] tile, int offset, int rowstride) {
        Class<Rasterizer> clazz = Rasterizer.class;
        synchronized (Rasterizer.class) {
            try {
                this.filler.writeAlpha(tile, 1, rowstride, offset);
            }
            catch (PRException e) {
                throw new InternalError("Ductus AA error: " + e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    @Override
    public void dispose() {
        DuctusRenderingEngine.dropRasterizer(this);
    }

    private static class ConsumerDisposer
    implements DisposerRecord {
        PathConsumer filler;
        PathConsumer stroker;
        PathConsumer dasher;

        public ConsumerDisposer(PathConsumer filler, PathConsumer stroker, PathConsumer dasher) {
            this.filler = filler;
            this.stroker = stroker;
            this.dasher = dasher;
        }

        @Override
        public void dispose() {
            this.filler.dispose();
            this.stroker.dispose();
            this.dasher.dispose();
        }
    }
}

