/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.util.WeakHashMap;
import sun.font.Font2D;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.GlyphLayout;
import sun.font.PhysicalFont;
import sun.font.TextRecord;
import sun.font.TrueTypeFont;

public final class SunLayoutEngine
implements GlyphLayout.LayoutEngine,
GlyphLayout.LayoutEngineFactory {
    private GlyphLayout.LayoutEngineKey key;
    private static GlyphLayout.LayoutEngineFactory instance;
    static WeakHashMap<Font2D, Boolean> aatInfo;

    private static native void initGVIDs();

    public static GlyphLayout.LayoutEngineFactory instance() {
        if (instance == null) {
            instance = new SunLayoutEngine();
        }
        return instance;
    }

    private SunLayoutEngine() {
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(Font2D font, int script, int lang) {
        return this.getEngine(new GlyphLayout.LayoutEngineKey(font, script, lang));
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(GlyphLayout.LayoutEngineKey key) {
        return new SunLayoutEngine(key.copy());
    }

    private SunLayoutEngine(GlyphLayout.LayoutEngineKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAAT(Font2D font) {
        Boolean aatObj;
        WeakHashMap<Font2D, Boolean> weakHashMap = aatInfo;
        synchronized (weakHashMap) {
            aatObj = aatInfo.get(font);
        }
        if (aatObj != null) {
            return aatObj;
        }
        boolean aat = false;
        if (font instanceof TrueTypeFont) {
            TrueTypeFont ttf = (TrueTypeFont)font;
            aat = ttf.getDirectoryEntry(1836020344) != null || ttf.getDirectoryEntry(1836020340) != null;
        } else if (font instanceof PhysicalFont) {
            PhysicalFont pf = (PhysicalFont)font;
            aat = pf.getTableBytes(1836020344) != null || pf.getTableBytes(1836020340) != null;
        }
        WeakHashMap<Font2D, Boolean> weakHashMap2 = aatInfo;
        synchronized (weakHashMap2) {
            aatInfo.put(font, aat);
        }
        return aat;
    }

    @Override
    public void layout(FontStrikeDesc desc, float[] mat, int gmask, int baseIndex, TextRecord tr, int typo_flags, Point2D.Float pt, GlyphLayout.GVData data) {
        Font2D font = this.key.font();
        FontStrike strike = font.getStrike(desc);
        long layoutTables = (typo_flags & Integer.MIN_VALUE) != 0 && this.isAAT(font) ? 0L : font.getLayoutTableCache();
        SunLayoutEngine.nativeLayout(font, strike, mat, gmask, baseIndex, tr.text, tr.start, tr.limit, tr.min, tr.max, this.key.script(), this.key.lang(), typo_flags, pt, data, font.getUnitsPerEm(), layoutTables);
    }

    private static native void nativeLayout(Font2D var0, FontStrike var1, float[] var2, int var3, int var4, char[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Point2D.Float var13, GlyphLayout.GVData var14, long var15, long var17);

    static {
        FontManagerNativeLibrary.load();
        SunLayoutEngine.initGVIDs();
        aatInfo = new WeakHashMap();
    }
}

