/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.MarlinConst;

public final class FloatMath
implements MarlinConst {
    static final boolean CHECK_OVERFLOW = true;
    static final boolean CHECK_NAN = true;
    public static final int FLOAT_SIGNIFICAND_WIDTH = 24;
    public static final int FLOAT_EXP_BIAS = 127;
    public static final int FLOAT_EXP_BIT_MASK = 2139095040;
    public static final int FLOAT_SIGNIF_BIT_MASK = 0x7FFFFF;

    private FloatMath() {
    }

    static int max(int a, int b) {
        return a >= b ? a : b;
    }

    static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static float ceil_f(float a) {
        int doppel = Float.floatToRawIntBits(a);
        int exponent = ((doppel & 0x7F800000) >> 23) - 127;
        if (exponent < 0) {
            return a == 0.0f ? a : (a < 0.0f ? -0.0f : 1.0f);
        }
        if (exponent >= 23) {
            return a;
        }
        assert (exponent >= 0 && exponent <= 22);
        int intpart = doppel & ~(0x7FFFFF >> exponent);
        if (intpart == doppel) {
            return a;
        }
        return Float.intBitsToFloat(intpart) + (float)(~intpart >>> 31);
    }

    public static float floor_f(float a) {
        int doppel = Float.floatToRawIntBits(a);
        int exponent = ((doppel & 0x7F800000) >> 23) - 127;
        if (exponent < 0) {
            return a == 0.0f ? a : (a < 0.0f ? -1.0f : 0.0f);
        }
        if (exponent >= 23) {
            return a;
        }
        assert (exponent >= 0 && exponent <= 22);
        int intpart = doppel & ~(0x7FFFFF >> exponent);
        if (intpart == doppel) {
            return a;
        }
        return Float.intBitsToFloat(intpart) + (float)(intpart >> 31);
    }

    public static int ceil_int(float a) {
        int intpart = (int)a;
        if (a <= (float)intpart || intpart == Integer.MAX_VALUE || Float.isNaN(a)) {
            return intpart;
        }
        return intpart + 1;
    }

    public static int ceil_int(double a) {
        int intpart = (int)a;
        if (a <= (double)intpart || intpart == Integer.MAX_VALUE || Double.isNaN(a)) {
            return intpart;
        }
        return intpart + 1;
    }

    public static int floor_int(float a) {
        int intpart = (int)a;
        if (a >= (float)intpart || intpart == Integer.MIN_VALUE || Float.isNaN(a)) {
            return intpart;
        }
        return intpart - 1;
    }

    public static int floor_int(double a) {
        int intpart = (int)a;
        if (a >= (double)intpart || intpart == Integer.MIN_VALUE || Double.isNaN(a)) {
            return intpart;
        }
        return intpart - 1;
    }
}

