/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.ByteArrayCache;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.FloatArrayCache;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.RendererContext;
import sun.java2d.marlin.stats.Histogram;
import sun.java2d.marlin.stats.StatLong;

final class Helpers
implements MarlinConst {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(float x, float y, float err) {
        float d = y - x;
        return d <= err && d >= -err;
    }

    static boolean within(double x, double y, double err) {
        double d = y - x;
        return d <= err && d >= -err;
    }

    static float evalCubic(float a, float b, float c, float d, float t) {
        return t * (t * (t * a + b) + c) + d;
    }

    static float evalQuad(float a, float b, float c, float t) {
        return t * (t * a + b) + c;
    }

    static int quadraticRoots(float a, float b, float c, float[] zeroes, int off) {
        int ret = off;
        if (a != 0.0f) {
            float dis = b * b - 4.0f * a * c;
            if (dis > 0.0f) {
                float sqrtDis = (float)Math.sqrt(dis);
                if (b >= 0.0f) {
                    zeroes[ret++] = 2.0f * c / (-b - sqrtDis);
                    zeroes[ret++] = (-b - sqrtDis) / (2.0f * a);
                } else {
                    zeroes[ret++] = (-b + sqrtDis) / (2.0f * a);
                    zeroes[ret++] = 2.0f * c / (-b + sqrtDis);
                }
            } else if (dis == 0.0f) {
                zeroes[ret++] = -b / (2.0f * a);
            }
        } else if (b != 0.0f) {
            zeroes[ret++] = -c / b;
        }
        return ret - off;
    }

    static int cubicRootsInAB(float d0, float a0, float b0, float c0, float[] pts, int off, float A, float B) {
        int num;
        if (d0 == 0.0f) {
            int num2 = Helpers.quadraticRoots(a0, b0, c0, pts, off);
            return Helpers.filterOutNotInAB(pts, off, num2, A, B) - off;
        }
        double a = (double)a0 / (double)d0;
        double sq_A = a * a;
        double sub = 0.3333333333333333 * a;
        double b = (double)b0 / (double)d0;
        double c = (double)c0 / (double)d0;
        double q = 0.5 * (0.07407407407407407 * a * sq_A - sub * b + c);
        double p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + b);
        double cb_p = p * p * p;
        double D = q * q + cb_p;
        if (D < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            pts[off] = (float)(t * Math.cos(phi) - sub);
            pts[off + 1] = (float)(-t * Math.cos(phi + 1.0471975511965976) - sub);
            pts[off + 2] = (float)(-t * Math.cos(phi - 1.0471975511965976) - sub);
            num = 3;
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = Math.cbrt(sqrt_D - q);
            double v = -Math.cbrt(sqrt_D + q);
            pts[off] = (float)(u + v - sub);
            num = 1;
            if (Helpers.within(D, 0.0, 1.0E-8)) {
                pts[off + 1] = (float)(-0.5 * (u + v) - sub);
                num = 2;
            }
        }
        return Helpers.filterOutNotInAB(pts, off, num, A, B) - off;
    }

    static int filterOutNotInAB(float[] nums, int off, int len, float a, float b) {
        int ret = off;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            if (!(nums[i] >= a) || !(nums[i] < b)) continue;
            nums[ret++] = nums[i];
        }
        return ret;
    }

    static float fastLineLen(float x0, float y0, float x1, float y1) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        return Math.abs(dx) + Math.abs(dy);
    }

    static float linelen(float x0, float y0, float x1, float y1) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    static float fastQuadLen(float x0, float y0, float x1, float y1, float x2, float y2) {
        float dx1 = x1 - x0;
        float dx2 = x2 - x1;
        float dy1 = y1 - y0;
        float dy2 = y2 - y1;
        return Math.abs(dx1) + Math.abs(dx2) + Math.abs(dy1) + Math.abs(dy2);
    }

    static float quadlen(float x0, float y0, float x1, float y1, float x2, float y2) {
        return (Helpers.linelen(x0, y0, x1, y1) + Helpers.linelen(x1, y1, x2, y2) + Helpers.linelen(x0, y0, x2, y2)) / 2.0f;
    }

    static float fastCurvelen(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        float dx1 = x1 - x0;
        float dx2 = x2 - x1;
        float dx3 = x3 - x2;
        float dy1 = y1 - y0;
        float dy2 = y2 - y1;
        float dy3 = y3 - y2;
        return Math.abs(dx1) + Math.abs(dx2) + Math.abs(dx3) + Math.abs(dy1) + Math.abs(dy2) + Math.abs(dy3);
    }

    static float curvelen(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        return (Helpers.linelen(x0, y0, x1, y1) + Helpers.linelen(x1, y1, x2, y2) + Helpers.linelen(x2, y2, x3, y3) + Helpers.linelen(x0, y0, x3, y3)) / 2.0f;
    }

    static int findSubdivPoints(Curve c, float[] pts, float[] ts, int type, float w2) {
        float x12 = pts[2] - pts[0];
        float y12 = pts[3] - pts[1];
        if (y12 != 0.0f && x12 != 0.0f) {
            float hypot = (float)Math.sqrt(x12 * x12 + y12 * y12);
            float cos = x12 / hypot;
            float sin = y12 / hypot;
            float x1 = cos * pts[0] + sin * pts[1];
            float y1 = cos * pts[1] - sin * pts[0];
            float x2 = cos * pts[2] + sin * pts[3];
            float y2 = cos * pts[3] - sin * pts[2];
            float x3 = cos * pts[4] + sin * pts[5];
            float y3 = cos * pts[5] - sin * pts[4];
            switch (type) {
                case 8: {
                    float x4 = cos * pts[6] + sin * pts[7];
                    float y4 = cos * pts[7] - sin * pts[6];
                    c.set(x1, y1, x2, y2, x3, y3, x4, y4);
                    break;
                }
                case 6: {
                    c.set(x1, y1, x2, y2, x3, y3);
                    break;
                }
            }
        } else {
            c.set(pts, type);
        }
        int ret = 0;
        ret += c.dxRoots(ts, ret);
        ret += c.dyRoots(ts, ret);
        if (type == 8) {
            ret += c.infPoints(ts, ret);
        }
        ret += c.rootsOfROCMinusW(ts, ret, w2, 1.0E-4f);
        ret = Helpers.filterOutNotInAB(ts, 0, ret, 1.0E-4f, 0.9999f);
        Helpers.isort(ts, ret);
        return ret;
    }

    static int findClipPoints(Curve curve, float[] pts, float[] ts, int type, int outCodeOR, float[] clipRect) {
        curve.set(pts, type);
        int ret = 0;
        if ((outCodeOR & 4) != 0) {
            ret += curve.xPoints(ts, ret, clipRect[2]);
        }
        if ((outCodeOR & 8) != 0) {
            ret += curve.xPoints(ts, ret, clipRect[3]);
        }
        if ((outCodeOR & 1) != 0) {
            ret += curve.yPoints(ts, ret, clipRect[0]);
        }
        if ((outCodeOR & 2) != 0) {
            ret += curve.yPoints(ts, ret, clipRect[1]);
        }
        Helpers.isort(ts, ret);
        return ret;
    }

    static void subdivide(float[] src, float[] left, float[] right, int type) {
        switch (type) {
            case 8: {
                Helpers.subdivideCubic(src, left, right);
                return;
            }
            case 6: {
                Helpers.subdivideQuad(src, left, right);
                return;
            }
        }
        throw new InternalError("Unsupported curve type");
    }

    static void isort(float[] a, int len) {
        for (int i = 1; i < len; ++i) {
            float ai = a[i];
            for (int j = i - 1; j >= 0 && a[j] > ai; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = ai;
        }
    }

    static void subdivideCubic(float[] src, float[] left, float[] right) {
        float x1 = src[0];
        float y1 = src[1];
        float cx1 = src[2];
        float cy1 = src[3];
        float cx2 = src[4];
        float cy2 = src[5];
        float x2 = src[6];
        float y2 = src[7];
        left[0] = x1;
        left[1] = y1;
        right[6] = x2;
        right[7] = y2;
        x1 = (x1 + cx1) / 2.0f;
        y1 = (y1 + cy1) / 2.0f;
        x2 = (x2 + cx2) / 2.0f;
        y2 = (y2 + cy2) / 2.0f;
        float cx = (cx1 + cx2) / 2.0f;
        float cy = (cy1 + cy2) / 2.0f;
        cx1 = (x1 + cx) / 2.0f;
        cy1 = (y1 + cy) / 2.0f;
        cx2 = (x2 + cx) / 2.0f;
        cy2 = (y2 + cy) / 2.0f;
        cx = (cx1 + cx2) / 2.0f;
        cy = (cy1 + cy2) / 2.0f;
        left[2] = x1;
        left[3] = y1;
        left[4] = cx1;
        left[5] = cy1;
        left[6] = cx;
        left[7] = cy;
        right[0] = cx;
        right[1] = cy;
        right[2] = cx2;
        right[3] = cy2;
        right[4] = x2;
        right[5] = y2;
    }

    static void subdivideCubicAt(float t, float[] src, int offS, float[] pts, int offL, int offR) {
        float x1 = src[offS];
        float y1 = src[offS + 1];
        float cx1 = src[offS + 2];
        float cy1 = src[offS + 3];
        float cx2 = src[offS + 4];
        float cy2 = src[offS + 5];
        float x2 = src[offS + 6];
        float y2 = src[offS + 7];
        pts[offL] = x1;
        pts[offL + 1] = y1;
        pts[offR + 6] = x2;
        pts[offR + 7] = y2;
        x1 += t * (cx1 - x1);
        y1 += t * (cy1 - y1);
        x2 = cx2 + t * (x2 - cx2);
        y2 = cy2 + t * (y2 - cy2);
        float cx = cx1 + t * (cx2 - cx1);
        float cy = cy1 + t * (cy2 - cy1);
        cx1 = x1 + t * (cx - x1);
        cy1 = y1 + t * (cy - y1);
        cx2 = cx + t * (x2 - cx);
        cy2 = cy + t * (y2 - cy);
        cx = cx1 + t * (cx2 - cx1);
        cy = cy1 + t * (cy2 - cy1);
        pts[offL + 2] = x1;
        pts[offL + 3] = y1;
        pts[offL + 4] = cx1;
        pts[offL + 5] = cy1;
        pts[offL + 6] = cx;
        pts[offL + 7] = cy;
        pts[offR] = cx;
        pts[offR + 1] = cy;
        pts[offR + 2] = cx2;
        pts[offR + 3] = cy2;
        pts[offR + 4] = x2;
        pts[offR + 5] = y2;
    }

    static void subdivideQuad(float[] src, float[] left, float[] right) {
        float x1 = src[0];
        float y1 = src[1];
        float cx = src[2];
        float cy = src[3];
        float x2 = src[4];
        float y2 = src[5];
        left[0] = x1;
        left[1] = y1;
        right[4] = x2;
        right[5] = y2;
        x1 = (x1 + cx) / 2.0f;
        y1 = (y1 + cy) / 2.0f;
        x2 = (x2 + cx) / 2.0f;
        y2 = (y2 + cy) / 2.0f;
        cx = (x1 + x2) / 2.0f;
        cy = (y1 + y2) / 2.0f;
        left[2] = x1;
        left[3] = y1;
        left[4] = cx;
        left[5] = cy;
        right[0] = cx;
        right[1] = cy;
        right[2] = x2;
        right[3] = y2;
    }

    static void subdivideQuadAt(float t, float[] src, int offS, float[] pts, int offL, int offR) {
        float x1 = src[offS];
        float y1 = src[offS + 1];
        float cx = src[offS + 2];
        float cy = src[offS + 3];
        float x2 = src[offS + 4];
        float y2 = src[offS + 5];
        pts[offL] = x1;
        pts[offL + 1] = y1;
        pts[offR + 4] = x2;
        pts[offR + 5] = y2;
        x1 += t * (cx - x1);
        y1 += t * (cy - y1);
        x2 = cx + t * (x2 - cx);
        y2 = cy + t * (y2 - cy);
        cx = x1 + t * (x2 - x1);
        cy = y1 + t * (y2 - y1);
        pts[offL + 2] = x1;
        pts[offL + 3] = y1;
        pts[offL + 4] = cx;
        pts[offL + 5] = cy;
        pts[offR] = cx;
        pts[offR + 1] = cy;
        pts[offR + 2] = x2;
        pts[offR + 3] = y2;
    }

    static void subdivideLineAt(float t, float[] src, int offS, float[] pts, int offL, int offR) {
        float x1 = src[offS];
        float y1 = src[offS + 1];
        float x2 = src[offS + 2];
        float y2 = src[offS + 3];
        pts[offL] = x1;
        pts[offL + 1] = y1;
        pts[offR + 2] = x2;
        pts[offR + 3] = y2;
        x1 += t * (x2 - x1);
        y1 += t * (y2 - y1);
        pts[offL + 2] = x1;
        pts[offL + 3] = y1;
        pts[offR] = x1;
        pts[offR + 1] = y1;
    }

    static void subdivideAt(float t, float[] src, int offS, float[] pts, int offL, int type) {
        if (type == 8) {
            Helpers.subdivideCubicAt(t, src, offS, pts, offL, offL + type);
        } else if (type == 4) {
            Helpers.subdivideLineAt(t, src, offS, pts, offL, offL + type);
        } else {
            Helpers.subdivideQuadAt(t, src, offS, pts, offL, offL + type);
        }
    }

    static int outcode(float x, float y, float[] clipRect) {
        int code = y < clipRect[0] ? 1 : (y >= clipRect[1] ? 2 : 0);
        if (x < clipRect[2]) {
            code |= 4;
        } else if (x >= clipRect[3]) {
            code |= 8;
        }
        return code;
    }

    static final class IndexStack {
        private static final int INITIAL_COUNT = MarlinConst.INITIAL_EDGES_COUNT >> 2;
        private int end;
        private int[] indices;
        private final IntArrayCache.Reference indices_ref;
        private int indicesUseMark;
        private final StatLong stat_idxstack_indices;
        private final Histogram hist_idxstack_indices;
        private final StatLong stat_array_idxstack_indices;

        IndexStack(RendererContext rdrCtx) {
            this(rdrCtx, null, null, null);
        }

        IndexStack(RendererContext rdrCtx, StatLong stat_idxstack_indices, Histogram hist_idxstack_indices, StatLong stat_array_idxstack_indices) {
            this.indices_ref = rdrCtx.newDirtyIntArrayRef(INITIAL_COUNT);
            this.indices = this.indices_ref.initial;
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.indicesUseMark = 0;
            }
            this.stat_idxstack_indices = stat_idxstack_indices;
            this.hist_idxstack_indices = hist_idxstack_indices;
            this.stat_array_idxstack_indices = stat_array_idxstack_indices;
        }

        void dispose() {
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.stat_idxstack_indices.add(this.indicesUseMark);
                this.hist_idxstack_indices.add(this.indicesUseMark);
                this.indicesUseMark = 0;
            }
            this.indices = this.indices_ref.putArray(this.indices);
        }

        boolean isEmpty() {
            return this.end == 0;
        }

        void reset() {
            this.end = 0;
        }

        void push(int v) {
            int nc;
            int[] _values = this.indices;
            if ((nc = this.end--) != 0 && _values[nc - 1] == v) {
                return;
            }
            if (_values.length <= nc) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_idxstack_indices.add(nc + 1);
                }
                this.indices = _values = this.indices_ref.widenArray(_values, nc, nc + 1);
            }
            _values[this.end++] = v;
            if (MarlinConst.DO_STATS && this.end > this.indicesUseMark) {
                this.indicesUseMark = this.end;
            }
        }

        void pullAll(float[] points, PathConsumer2D io) {
            int nc = this.end;
            if (nc == 0) {
                return;
            }
            int[] _values = this.indices;
            for (int i = 0; i < nc; ++i) {
                int j = _values[i] << 1;
                io.lineTo(points[j], points[j + 1]);
            }
            this.end = 0;
        }
    }

    static final class PolyStack {
        private static final byte TYPE_LINETO = 0;
        private static final byte TYPE_QUADTO = 1;
        private static final byte TYPE_CUBICTO = 2;
        private static final int INITIAL_CURVES_COUNT = MarlinConst.INITIAL_EDGES_COUNT << 1;
        private static final int INITIAL_TYPES_COUNT = MarlinConst.INITIAL_EDGES_COUNT;
        float[] curves;
        int end;
        byte[] curveTypes;
        int numCurves;
        final FloatArrayCache.Reference curves_ref;
        final ByteArrayCache.Reference curveTypes_ref;
        int curveTypesUseMark;
        int curvesUseMark;
        private final StatLong stat_polystack_types;
        private final StatLong stat_polystack_curves;
        private final Histogram hist_polystack_curves;
        private final StatLong stat_array_polystack_curves;
        private final StatLong stat_array_polystack_curveTypes;

        PolyStack(RendererContext rdrCtx) {
            this(rdrCtx, null, null, null, null, null);
        }

        PolyStack(RendererContext rdrCtx, StatLong stat_polystack_types, StatLong stat_polystack_curves, Histogram hist_polystack_curves, StatLong stat_array_polystack_curves, StatLong stat_array_polystack_curveTypes) {
            this.curves_ref = rdrCtx.newDirtyFloatArrayRef(INITIAL_CURVES_COUNT);
            this.curves = this.curves_ref.initial;
            this.curveTypes_ref = rdrCtx.newDirtyByteArrayRef(INITIAL_TYPES_COUNT);
            this.curveTypes = this.curveTypes_ref.initial;
            this.numCurves = 0;
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            this.stat_polystack_types = stat_polystack_types;
            this.stat_polystack_curves = stat_polystack_curves;
            this.hist_polystack_curves = hist_polystack_curves;
            this.stat_array_polystack_curves = stat_array_polystack_curves;
            this.stat_array_polystack_curveTypes = stat_array_polystack_curveTypes;
        }

        void dispose() {
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.DO_STATS) {
                this.stat_polystack_types.add(this.curveTypesUseMark);
                this.stat_polystack_curves.add(this.curvesUseMark);
                this.hist_polystack_curves.add(this.curvesUseMark);
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            this.curves = this.curves_ref.putArray(this.curves);
            this.curveTypes = this.curveTypes_ref.putArray(this.curveTypes);
        }

        private void ensureSpace(int n) {
            if (this.curves.length - this.end < n) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_polystack_curves.add(this.end + n);
                }
                this.curves = this.curves_ref.widenArray(this.curves, this.end, this.end + n);
            }
            if (this.curveTypes.length <= this.numCurves) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_polystack_curveTypes.add(this.numCurves + 1);
                }
                this.curveTypes = this.curveTypes_ref.widenArray(this.curveTypes, this.numCurves, this.numCurves + 1);
            }
        }

        void pushCubic(float x0, float y0, float x1, float y1, float x2, float y2) {
            this.ensureSpace(6);
            this.curveTypes[this.numCurves++] = 2;
            float[] _curves = this.curves;
            int e = this.end;
            _curves[e++] = x2;
            _curves[e++] = y2;
            _curves[e++] = x1;
            _curves[e++] = y1;
            _curves[e++] = x0;
            _curves[e++] = y0;
            this.end = e;
        }

        void pushQuad(float x0, float y0, float x1, float y1) {
            this.ensureSpace(4);
            this.curveTypes[this.numCurves++] = 1;
            float[] _curves = this.curves;
            int e = this.end;
            _curves[e++] = x1;
            _curves[e++] = y1;
            _curves[e++] = x0;
            _curves[e++] = y0;
            this.end = e;
        }

        void pushLine(float x, float y) {
            this.ensureSpace(2);
            this.curveTypes[this.numCurves++] = 0;
            this.curves[this.end++] = x;
            this.curves[this.end++] = y;
        }

        void pullAll(PathConsumer2D io) {
            int nc = this.numCurves;
            if (nc == 0) {
                return;
            }
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] _curveTypes = this.curveTypes;
            float[] _curves = this.curves;
            int e = 0;
            block5: for (int i = 0; i < nc; ++i) {
                switch (_curveTypes[i]) {
                    case 0: {
                        io.lineTo(_curves[e], _curves[e + 1]);
                        e += 2;
                        continue block5;
                    }
                    case 2: {
                        io.curveTo(_curves[e], _curves[e + 1], _curves[e + 2], _curves[e + 3], _curves[e + 4], _curves[e + 5]);
                        e += 6;
                        continue block5;
                    }
                    case 1: {
                        io.quadTo(_curves[e], _curves[e + 1], _curves[e + 2], _curves[e + 3]);
                        e += 4;
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        void popAll(PathConsumer2D io) {
            int nc = this.numCurves;
            if (nc == 0) {
                return;
            }
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] _curveTypes = this.curveTypes;
            float[] _curves = this.curves;
            int e = this.end;
            block5: while (nc != 0) {
                switch (_curveTypes[--nc]) {
                    case 0: {
                        io.lineTo(_curves[e -= 2], _curves[e + 1]);
                        continue block5;
                    }
                    case 2: {
                        io.curveTo(_curves[e -= 6], _curves[e + 1], _curves[e + 2], _curves[e + 3], _curves[e + 4], _curves[e + 5]);
                        continue block5;
                    }
                    case 1: {
                        io.quadTo(_curves[e -= 4], _curves[e + 1], _curves[e + 2], _curves[e + 3]);
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        public String toString() {
            String ret = "";
            int nc = this.numCurves;
            int last = this.end;
            while (nc != 0) {
                int len;
                switch (this.curveTypes[--nc]) {
                    case 0: {
                        len = 2;
                        ret = ret + "line: ";
                        break;
                    }
                    case 1: {
                        len = 4;
                        ret = ret + "quad: ";
                        break;
                    }
                    case 2: {
                        len = 6;
                        ret = ret + "cubic: ";
                        break;
                    }
                    default: {
                        len = 0;
                    }
                }
                ret = ret + Arrays.toString(Arrays.copyOfRange(this.curves, last -= len, last + len)) + "\n";
            }
            return ret;
        }
    }
}

