/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.MarlinProperties;

final class PathSimplifier
implements PathConsumer2D {
    private static final float PIX_THRESHOLD = MarlinProperties.getPathSimplifierPixelTolerance();
    private static final float SQUARE_TOLERANCE = PIX_THRESHOLD * PIX_THRESHOLD;
    private PathConsumer2D delegate;
    private float cx;
    private float cy;

    PathSimplifier() {
    }

    PathSimplifier init(PathConsumer2D delegate) {
        this.delegate = delegate;
        return this;
    }

    @Override
    public void pathDone() {
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.delegate.closePath();
    }

    @Override
    public long getNativeConsumer() {
        return 0L;
    }

    @Override
    public void quadTo(float x1, float y1, float xe, float ye) {
        float dx = xe - this.cx;
        float dy = ye - this.cy;
        if (dx * dx + dy * dy <= SQUARE_TOLERANCE && (dx = x1 - this.cx) * dx + (dy = y1 - this.cy) * dy <= SQUARE_TOLERANCE) {
            return;
        }
        this.delegate.quadTo(x1, y1, xe, ye);
        this.cx = xe;
        this.cy = ye;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float xe, float ye) {
        float dx = xe - this.cx;
        float dy = ye - this.cy;
        if (dx * dx + dy * dy <= SQUARE_TOLERANCE && (dx = x1 - this.cx) * dx + (dy = y1 - this.cy) * dy <= SQUARE_TOLERANCE && (dx = x2 - this.cx) * dx + (dy = y2 - this.cy) * dy <= SQUARE_TOLERANCE) {
            return;
        }
        this.delegate.curveTo(x1, y1, x2, y2, xe, ye);
        this.cx = xe;
        this.cy = ye;
    }

    @Override
    public void moveTo(float xe, float ye) {
        this.delegate.moveTo(xe, ye);
        this.cx = xe;
        this.cy = ye;
    }

    @Override
    public void lineTo(float xe, float ye) {
        float dx = xe - this.cx;
        float dy = ye - this.cy;
        if (dx * dx + dy * dy <= SQUARE_TOLERANCE) {
            return;
        }
        this.delegate.lineTo(xe, ye);
        this.cx = xe;
        this.cy = ye;
    }
}

