/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import sun.misc.VMSupport;

public class PlatformSupport {
    private static final String tmpDirName;

    public static PlatformSupport getInstance() {
        try {
            Class<?> c = Class.forName("sun.jvmstat.PlatformSupportImpl");
            Constructor<?> cntr = c.getConstructor(new Class[0]);
            return (PlatformSupport)cntr.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return new PlatformSupport();
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    PlatformSupport() {
    }

    public static String getTemporaryDirectory() {
        return tmpDirName;
    }

    public List<String> getTemporaryDirectories(int vmid) {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add(tmpDirName);
        return ls;
    }

    public int getLocalVmId(File file) throws NumberFormatException {
        return Integer.parseInt(file.getName());
    }

    public int getNamespaceVmId(int pid) {
        return pid;
    }

    static {
        String tmpdir = VMSupport.getVMTemporaryDirectory();
        if (tmpdir.lastIndexOf(File.separator) != tmpdir.length() - 1) {
            tmpdir = tmpdir + File.separator;
        }
        tmpDirName = tmpdir;
    }
}

