/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.jvmstat.PlatformSupport;

public class PlatformSupportImpl
extends PlatformSupport {
    private static final String containerTmpPath = "/root" + PlatformSupportImpl.getTemporaryDirectory();
    private static final String pidPatternStr = "^[0-9]+$";

    @Override
    public List<String> getTemporaryDirectories(int pid) {
        File[] dirs;
        Pattern pidPattern = Pattern.compile(pidPatternStr);
        long tmpInode = 0L;
        File procdir = new File("/proc");
        pidPattern = pid != 0 ? Pattern.compile(Integer.toString(pid)) : Pattern.compile(pidPatternStr);
        final Matcher pidMatcher = pidPattern.matcher("");
        ArrayList<String> v = new ArrayList<String>();
        v.add(PlatformSupportImpl.getTemporaryDirectory());
        try {
            File f = new File(PlatformSupportImpl.getTemporaryDirectory());
            tmpInode = (Long)Files.getAttribute(f.toPath(), "unix:ino", new LinkOption[0]);
        }
        catch (IOException f) {
            // empty catch block
        }
        FilenameFilter pidFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!dir.isDirectory()) {
                    return false;
                }
                pidMatcher.reset(name);
                return pidMatcher.matches();
            }
        };
        for (File dir : dirs = procdir.listFiles(pidFilter)) {
            String containerTmpDir = dir.getAbsolutePath() + containerTmpPath;
            File containerFile = new File(containerTmpDir);
            try {
                long procInode = (Long)Files.getAttribute(containerFile.toPath(), "unix:ino", new LinkOption[0]);
                if (!containerFile.exists() || !containerFile.isDirectory() || !containerFile.canRead() || procInode == tmpInode) continue;
                v.add(containerTmpDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return v;
    }

    @Override
    public int getLocalVmId(File file) throws NumberFormatException {
        String p = file.getAbsolutePath();
        String[] s = p.split("\\/");
        if (s.length == 7 && s[1].equals("proc")) {
            int hostpid = Integer.parseInt(s[2]);
            int nspid = Integer.parseInt(s[6]);
            if (nspid == hostpid || nspid == this.getNamespaceVmId(hostpid)) {
                return hostpid;
            }
            return -1;
        }
        return Integer.parseInt(file.getName());
    }

    @Override
    public int getNamespaceVmId(int pid) {
        Path statusPath = Paths.get("/proc", Integer.toString(pid), "status");
        if (Files.notExists(statusPath, new LinkOption[0])) {
            return pid;
        }
        try {
            for (String line : Files.readAllLines(statusPath, StandardCharsets.UTF_8)) {
                String[] parts = line.split(":");
                if (parts.length != 2 || !parts[0].trim().equals("NSpid")) continue;
                parts = parts[1].trim().split("\\s+");
                int ns_pid = Integer.parseInt(parts[parts.length - 1]);
                return ns_pid;
            }
            return pid;
        }
        catch (IOException | NumberFormatException x) {
            return pid;
        }
    }
}

