/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import java.net.URI;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;

public class HostIdentifier {
    private URI uri;

    private URI canonicalize(String uriString) throws URISyntaxException {
        if (uriString == null || uriString.compareTo("localhost") == 0) {
            uriString = "//localhost";
            return new URI(uriString);
        }
        URI u = new URI(uriString);
        if (u.isAbsolute()) {
            if (u.isOpaque()) {
                String scheme = u.getScheme();
                String ssp = u.getSchemeSpecificPart();
                String frag = u.getFragment();
                URI u2 = null;
                int c1index = uriString.indexOf(":");
                int c2index = uriString.lastIndexOf(":");
                if (c2index != c1index) {
                    u2 = frag == null ? new URI(scheme + "://" + ssp) : new URI(scheme + "://" + ssp + "#" + frag);
                    return u2;
                }
                u2 = new URI("//" + uriString);
                return u2;
            }
            return u;
        }
        String ssp = u.getSchemeSpecificPart();
        if (ssp.startsWith("//")) {
            return u;
        }
        return new URI("//" + uriString);
    }

    public HostIdentifier(String uriString) throws URISyntaxException {
        this.uri = this.canonicalize(uriString);
    }

    public HostIdentifier(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        this.uri = new URI(scheme, authority, path, query, fragment);
    }

    public HostIdentifier(VmIdentifier vmid) {
        String frag;
        String query;
        String path;
        StringBuilder sb = new StringBuilder();
        String scheme = vmid.getScheme();
        String host = vmid.getHost();
        String authority = vmid.getAuthority();
        if (scheme != null && scheme.compareTo("file") == 0) {
            try {
                this.uri = new URI("file://localhost");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return;
        }
        if (host != null && host.compareTo(authority) == 0) {
            host = null;
        }
        if (scheme == null) {
            scheme = host == null ? "local" : "rmi";
        }
        sb.append(scheme).append("://");
        if (host == null) {
            sb.append("localhost");
        } else {
            sb.append(host);
        }
        int port = vmid.getPort();
        if (port != -1) {
            sb.append(":").append(port);
        }
        if ((path = vmid.getPath()) != null && path.length() != 0) {
            sb.append(path);
        }
        if ((query = vmid.getQuery()) != null) {
            sb.append("?").append(query);
        }
        if ((frag = vmid.getFragment()) != null) {
            sb.append("#").append(frag);
        }
        try {
            this.uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Internal Error", e);
        }
    }

    public VmIdentifier resolve(VmIdentifier vmid) throws URISyntaxException, MonitorException {
        String fragment;
        String query;
        String path;
        String scheme = vmid.getScheme();
        String host = vmid.getHost();
        String authority = vmid.getAuthority();
        if (scheme != null && scheme.compareTo("file") == 0) {
            return vmid;
        }
        if (host != null && host.compareTo(authority) == 0) {
            host = null;
        }
        if (scheme == null) {
            scheme = this.getScheme();
        }
        Object nuri = null;
        StringBuffer sb = new StringBuffer();
        sb.append(scheme).append("://");
        String userInfo = vmid.getUserInfo();
        if (userInfo != null) {
            sb.append(userInfo);
        } else {
            sb.append(vmid.getAuthority());
        }
        if (host == null) {
            host = this.getHost();
        }
        sb.append("@").append(host);
        int port = vmid.getPort();
        if (port == -1) {
            port = this.getPort();
        }
        if (port != -1) {
            sb.append(":").append(port);
        }
        if ((path = vmid.getPath()) == null || path.length() == 0) {
            path = this.getPath();
        }
        if (path != null && path.length() > 0) {
            sb.append(path);
        }
        if ((query = vmid.getQuery()) == null) {
            query = this.getQuery();
        }
        if (query != null) {
            sb.append("?").append(query);
        }
        if ((fragment = vmid.getFragment()) == null) {
            fragment = this.getFragment();
        }
        if (fragment != null) {
            sb.append("#").append(fragment);
        }
        String s = sb.toString();
        return new VmIdentifier(s);
    }

    public String getScheme() {
        return this.uri.isAbsolute() ? this.uri.getScheme() : null;
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public String getHost() {
        return this.uri.getHost() == null ? "localhost" : this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String getMode() {
        String query = this.getQuery();
        if (query != null) {
            String[] queryArgs = query.split("\\+");
            for (int i = 0; i < queryArgs.length; ++i) {
                if (!queryArgs[i].startsWith("mode=")) continue;
                int index = queryArgs[i].indexOf(61);
                return queryArgs[i].substring(index + 1);
            }
        }
        return "r";
    }

    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HostIdentifier)) {
            return false;
        }
        return this.uri.equals(((HostIdentifier)object).uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

