/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import java.net.URI;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.HostIdentifier;

public class VmIdentifier {
    private URI uri;

    private URI canonicalize(String uriString) throws URISyntaxException {
        if (uriString == null) {
            uriString = "local://0@localhost";
            return new URI(uriString);
        }
        URI u = new URI(uriString);
        if (u.isAbsolute()) {
            if (u.isOpaque()) {
                u = new URI(u.getScheme(), "//" + u.getSchemeSpecificPart(), u.getFragment());
            }
        } else if (!uriString.startsWith("//")) {
            u = u.getFragment() == null ? new URI("//" + u.getSchemeSpecificPart()) : new URI("//" + u.getSchemeSpecificPart() + "#" + u.getFragment());
        }
        return u;
    }

    private void validate() throws URISyntaxException {
        String s = this.getScheme();
        if (s != null && s.compareTo("file") == 0) {
            return;
        }
        if (this.getLocalVmId() == -1) {
            throw new URISyntaxException(this.uri.toString(), "Local vmid required");
        }
    }

    public VmIdentifier(String uriString) throws URISyntaxException {
        URI u;
        try {
            u = this.canonicalize(uriString);
        }
        catch (URISyntaxException e) {
            if (uriString.startsWith("//")) {
                throw e;
            }
            u = this.canonicalize("//" + uriString);
        }
        this.uri = u;
        this.validate();
    }

    public VmIdentifier(URI uri) throws URISyntaxException {
        this.uri = uri;
        this.validate();
    }

    public HostIdentifier getHostIdentifier() throws URISyntaxException {
        StringBuffer sb = new StringBuffer();
        if (this.getScheme() != null) {
            sb.append(this.getScheme()).append(":");
        }
        sb.append("//").append(this.getHost());
        if (this.getPort() != -1) {
            sb.append(":").append(this.getPort());
        }
        if (this.getPath() != null) {
            sb.append(this.getPath());
        }
        return new HostIdentifier(sb.toString());
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public int getLocalVmId() {
        int result = -1;
        try {
            result = this.uri.getUserInfo() == null ? Integer.parseInt(this.uri.getAuthority()) : Integer.parseInt(this.uri.getUserInfo());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public String getMode() {
        String query = this.getQuery();
        if (query != null) {
            String[] queryArgs = query.split("\\+");
            for (int i = 0; i < queryArgs.length; ++i) {
                if (!queryArgs[i].startsWith("mode=")) continue;
                int index = queryArgs[i].indexOf(61);
                return queryArgs[i].substring(index + 1);
            }
        }
        return "r";
    }

    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VmIdentifier)) {
            return false;
        }
        return this.uri.equals(((VmIdentifier)object).uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

