/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBuffer;
import sun.jvmstat.perfdata.monitor.protocol.local.PerfDataFile;
import sun.misc.Perf;

public class PerfDataBuffer
extends AbstractPerfDataBuffer {
    private static final Perf perf = AccessController.doPrivileged(new Perf.GetPerfAction());

    public PerfDataBuffer(VmIdentifier vmid) throws MonitorException {
        try {
            ByteBuffer bb = perf.attach(vmid.getLocalVmId(), vmid.getMode());
            this.createPerfDataBuffer(bb, vmid.getLocalVmId());
        }
        catch (IllegalArgumentException e) {
            try {
                String filename = PerfDataFile.getTempDirectory() + "hsperfdata_" + Integer.toString(vmid.getLocalVmId());
                File f = new File(filename);
                FileChannel fc = new RandomAccessFile(f, "r").getChannel();
                MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
                fc.close();
                this.createPerfDataBuffer(bb, vmid.getLocalVmId());
            }
            catch (FileNotFoundException e2) {
                throw new MonitorException(vmid.getLocalVmId() + " not found", e);
            }
            catch (IOException e2) {
                throw new MonitorException("Could not map 1.4.1 file for " + vmid.getLocalVmId(), e2);
            }
        }
        catch (IOException e) {
            throw new MonitorException("Could not attach to " + vmid.getLocalVmId(), e);
        }
    }
}

