/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.stream.Collectors;
import sun.jvmstat.PlatformSupport;

public class PerfDataFile {
    public static final String dirNamePrefix = "hsperfdata_";
    public static final String userDirNamePattern = "hsperfdata_\\S*";
    public static final String fileNamePattern = "^[0-9]+$";
    public static final String tmpFileNamePattern = "^hsperfdata_[0-9]+(_[1-2]+)?$";
    private static final PlatformSupport platSupport = PlatformSupport.getInstance();

    private PerfDataFile() {
    }

    public static File getFile(int lvmid) {
        if (lvmid == 0) {
            return null;
        }
        List<String> tmpDirs = PerfDataFile.getTempDirectories(null, lvmid);
        File newest = null;
        for (String dir : tmpDirs) {
            File tmpDir = new File(dir);
            String[] files = tmpDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (!name.startsWith(PerfDataFile.dirNamePrefix)) {
                        return false;
                    }
                    File candidate = new File(dir, name);
                    return (candidate.isDirectory() || candidate.isFile()) && candidate.canRead();
                }
            });
            long newestTime = 0L;
            for (String file : files) {
                long modTime;
                File f = new File(dir + file);
                File candidate = null;
                if (f.exists() && f.isDirectory()) {
                    String name = f.getAbsolutePath() + File.separator + lvmid;
                    candidate = new File(name);
                    if (!candidate.exists()) {
                        name = f.getAbsolutePath() + File.separator + platSupport.getNamespaceVmId(lvmid);
                        candidate = new File(name);
                    }
                } else {
                    candidate = f.exists() && f.isFile() ? f : f;
                }
                if (!candidate.exists() || !candidate.isFile() || !candidate.canRead() || (modTime = candidate.lastModified()) < newestTime) continue;
                newestTime = modTime;
                newest = candidate;
            }
        }
        return newest;
    }

    public static File getFile(String user, int lvmid) {
        File f;
        String basename;
        if (lvmid == 0) {
            return null;
        }
        List<String> tmpDirs = PerfDataFile.getTempDirectories(user, lvmid);
        for (String dir : tmpDirs) {
            basename = dir + lvmid;
            f = new File(basename);
            if (f.exists() && f.isFile() && f.canRead()) {
                return f;
            }
            basename = dir + platSupport.getNamespaceVmId(lvmid);
            f = new File(basename);
            if (!f.exists() || !f.isFile() || !f.canRead()) continue;
            return f;
        }
        long newestTime = 0L;
        File newest = null;
        for (int i = 0; i < 2; ++i) {
            long modTime;
            basename = i == 0 ? PerfDataFile.getTempDirectory() + Integer.toString(lvmid) : PerfDataFile.getTempDirectory() + Integer.toString(lvmid) + Integer.toString(i);
            f = new File(basename);
            if (!f.exists() || !f.isFile() || !f.canRead() || (modTime = f.lastModified()) < newestTime) continue;
            newestTime = modTime;
            newest = f;
        }
        return newest;
    }

    public static int getLocalVmId(File file) {
        try {
            return platSupport.getLocalVmId(file);
        }
        catch (NumberFormatException numberFormatException) {
            String name = file.getName();
            if (name.startsWith(dirNamePrefix)) {
                int first = name.indexOf(95);
                int last = name.lastIndexOf(95);
                try {
                    if (first == last) {
                        return Integer.parseInt(name.substring(first + 1));
                    }
                    return Integer.parseInt(name.substring(first + 1, last));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("file name does not match pattern");
        }
    }

    public static String getTempDirectory() {
        return PlatformSupport.getTemporaryDirectory();
    }

    public static String getTempDirectory(String user) {
        return PerfDataFile.getTempDirectory() + dirNamePrefix + user + File.separator;
    }

    public static List<String> getTempDirectories(String userName, int vmid) {
        List<String> list = platSupport.getTemporaryDirectories(vmid);
        if (userName == null) {
            return list;
        }
        List<String> nameList = list.stream().map(name -> name + dirNamePrefix + userName + File.separator).collect(Collectors.toList());
        return nameList;
    }
}

