/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpParameters;
import com.sun.jmx.snmp.SnmpPeer;
import com.sun.jmx.snmp.SnmpString;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.snmp.jvminstr.JvmClassLoadingImpl;
import sun.management.snmp.jvminstr.JvmCompilationImpl;
import sun.management.snmp.jvminstr.JvmMemPoolTableMetaImpl;
import sun.management.snmp.jvminstr.JvmMemoryImpl;
import sun.management.snmp.jvminstr.JvmMemoryMetaImpl;
import sun.management.snmp.jvminstr.JvmOSImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvminstr.JvmRuntimeMetaImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvminstr.JvmThreadingMetaImpl;
import sun.management.snmp.jvminstr.NotificationTarget;
import sun.management.snmp.jvmmib.JVM_MANAGEMENT_MIB;
import sun.management.snmp.jvmmib.JVM_MANAGEMENT_MIBOidTable;
import sun.management.snmp.jvmmib.JvmCompilationMeta;
import sun.management.snmp.jvmmib.JvmMemoryMeta;
import sun.management.snmp.jvmmib.JvmRuntimeMeta;
import sun.management.snmp.jvmmib.JvmThreadingMeta;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableHandler;

public class JVM_MANAGEMENT_MIB_IMPL
extends JVM_MANAGEMENT_MIB {
    private static final long serialVersionUID = -8104825586888859831L;
    private static final MibLogger log = new MibLogger(JVM_MANAGEMENT_MIB_IMPL.class);
    private static WeakReference<SnmpOidTable> tableRef;
    private ArrayList<NotificationTarget> notificationTargets = new ArrayList();
    private final NotificationEmitter emitter;
    private final NotificationHandler handler = new NotificationHandler();
    private static final int DISPLAY_STRING_MAX_LENGTH = 255;
    private static final int JAVA_OBJECT_NAME_MAX_LENGTH = 1023;
    private static final int PATH_ELEMENT_MAX_LENGTH = 1023;
    private static final int ARG_VALUE_MAX_LENGTH = 1023;
    private static final int DEFAULT_CACHE_VALIDITY_PERIOD = 1000;

    public static SnmpOidTable getOidTable() {
        SnmpOidTable table = null;
        if (tableRef == null) {
            table = new JVM_MANAGEMENT_MIBOidTable();
            tableRef = new WeakReference<JVM_MANAGEMENT_MIBOidTable>((JVM_MANAGEMENT_MIBOidTable)table);
            return table;
        }
        table = (SnmpOidTable)tableRef.get();
        if (table == null) {
            table = new JVM_MANAGEMENT_MIBOidTable();
            tableRef = new WeakReference<JVM_MANAGEMENT_MIBOidTable>((JVM_MANAGEMENT_MIBOidTable)table);
        }
        return table;
    }

    public JVM_MANAGEMENT_MIB_IMPL() {
        this.emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        this.emitter.addNotificationListener(this.handler, null, null);
    }

    private synchronized void sendTrap(SnmpOid trap, SnmpVarBindList list) {
        Iterator<NotificationTarget> iterator = this.notificationTargets.iterator();
        SnmpAdaptorServer adaptor = (SnmpAdaptorServer)this.getSnmpAdaptor();
        if (adaptor == null) {
            log.error("sendTrap", "Cannot send trap: adaptor is null.");
            return;
        }
        if (!adaptor.isActive()) {
            log.config("sendTrap", "Adaptor is not active: trap not sent.");
            return;
        }
        while (iterator.hasNext()) {
            NotificationTarget target = null;
            try {
                target = iterator.next();
                SnmpPeer peer = new SnmpPeer(target.getAddress(), target.getPort());
                SnmpParameters p = new SnmpParameters();
                p.setRdCommunity(target.getCommunity());
                peer.setParams(p);
                log.debug("handleNotification", "Sending trap to " + target.getAddress() + ":" + target.getPort());
                adaptor.snmpV2Trap(peer, trap, list, null);
            }
            catch (Exception e) {
                log.error("sendTrap", "Exception occurred while sending trap to [" + target + "]. Exception : " + e);
                log.debug("sendTrap", e);
            }
        }
    }

    public synchronized void addTarget(NotificationTarget target) throws IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("Target is null");
        }
        this.notificationTargets.add(target);
    }

    public void terminate() {
        try {
            this.emitter.removeNotificationListener(this.handler);
        }
        catch (ListenerNotFoundException e) {
            log.error("terminate", "Listener Not found : " + e);
        }
    }

    public synchronized void addTargets(List<NotificationTarget> targets) throws IllegalArgumentException {
        if (targets == null) {
            throw new IllegalArgumentException("Target list is null");
        }
        this.notificationTargets.addAll(targets);
    }

    @Override
    protected Object createJvmMemoryMBean(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (server != null) {
            return new JvmMemoryImpl(this, server);
        }
        return new JvmMemoryImpl(this);
    }

    @Override
    protected JvmMemoryMeta createJvmMemoryMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmMemoryMetaImpl(this, this.objectserver);
    }

    @Override
    protected JvmThreadingMeta createJvmThreadingMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmThreadingMetaImpl(this, this.objectserver);
    }

    @Override
    protected Object createJvmThreadingMBean(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (server != null) {
            return new JvmThreadingImpl(this, server);
        }
        return new JvmThreadingImpl(this);
    }

    @Override
    protected JvmRuntimeMeta createJvmRuntimeMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmRuntimeMetaImpl(this, this.objectserver);
    }

    @Override
    protected Object createJvmRuntimeMBean(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (server != null) {
            return new JvmRuntimeImpl(this, server);
        }
        return new JvmRuntimeImpl(this);
    }

    @Override
    protected JvmCompilationMeta createJvmCompilationMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (ManagementFactory.getCompilationMXBean() == null) {
            return null;
        }
        return super.createJvmCompilationMetaNode(groupName, groupOid, groupObjname, server);
    }

    @Override
    protected Object createJvmCompilationMBean(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (server != null) {
            return new JvmCompilationImpl(this, server);
        }
        return new JvmCompilationImpl(this);
    }

    @Override
    protected Object createJvmOSMBean(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (server != null) {
            return new JvmOSImpl(this, server);
        }
        return new JvmOSImpl(this);
    }

    @Override
    protected Object createJvmClassLoadingMBean(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        if (server != null) {
            return new JvmClassLoadingImpl(this, server);
        }
        return new JvmClassLoadingImpl(this);
    }

    static String validDisplayStringTC(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() > 255) {
            return str.substring(0, 255);
        }
        return str;
    }

    static String validJavaObjectNameTC(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() > 1023) {
            return str.substring(0, 1023);
        }
        return str;
    }

    static String validPathElementTC(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() > 1023) {
            return str.substring(0, 1023);
        }
        return str;
    }

    static String validArgValueTC(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() > 1023) {
            return str.substring(0, 1023);
        }
        return str;
    }

    private SnmpTableHandler getJvmMemPoolTableHandler(Object userData) {
        SnmpMibTable meta = this.getRegisteredTableMeta("JvmMemPoolTable");
        if (!(meta instanceof JvmMemPoolTableMetaImpl)) {
            String err = meta == null ? "No metadata for JvmMemPoolTable" : "Bad metadata class for JvmMemPoolTable: " + meta.getClass().getName();
            log.error("getJvmMemPoolTableHandler", err);
            return null;
        }
        JvmMemPoolTableMetaImpl memPoolTable = (JvmMemPoolTableMetaImpl)meta;
        return memPoolTable.getHandler(userData);
    }

    private int findInCache(SnmpTableHandler handler, String poolName) {
        if (!(handler instanceof SnmpCachedData)) {
            if (handler != null) {
                String err = "Bad class for JvmMemPoolTable datas: " + handler.getClass().getName();
                log.error("getJvmMemPoolEntry", err);
            }
            return -1;
        }
        SnmpCachedData data = (SnmpCachedData)handler;
        int len = data.datas.length;
        for (int i = 0; i < data.datas.length; ++i) {
            MemoryPoolMXBean pool = (MemoryPoolMXBean)data.datas[i];
            if (!poolName.equals(pool.getName())) continue;
            return i;
        }
        return -1;
    }

    private SnmpOid getJvmMemPoolEntryIndex(SnmpTableHandler handler, String poolName) {
        int index = this.findInCache(handler, poolName);
        if (index < 0) {
            return null;
        }
        return ((SnmpCachedData)handler).indexes[index];
    }

    private SnmpOid getJvmMemPoolEntryIndex(String poolName) {
        return this.getJvmMemPoolEntryIndex(this.getJvmMemPoolTableHandler(null), poolName);
    }

    public long validity() {
        return 1000L;
    }

    private class NotificationHandler
    implements NotificationListener {
        private NotificationHandler() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            log.debug("handleNotification", "Received notification [ " + notification.getType() + "]");
            String type = notification.getType();
            if (type.equals("java.management.memory.threshold.exceeded") || type.equals("java.management.memory.collection.threshold.exceeded")) {
                MemoryNotificationInfo minfo = MemoryNotificationInfo.from((CompositeData)notification.getUserData());
                SnmpCounter64 count = new SnmpCounter64(minfo.getCount());
                SnmpCounter64 used = new SnmpCounter64(minfo.getUsage().getUsed());
                SnmpString poolName = new SnmpString(minfo.getPoolName());
                SnmpOid entryIndex = JVM_MANAGEMENT_MIB_IMPL.this.getJvmMemPoolEntryIndex(minfo.getPoolName());
                if (entryIndex == null) {
                    log.error("handleNotification", "Error: Can't find entry index for Memory Pool: " + minfo.getPoolName() + ": No trap emitted for " + type);
                    return;
                }
                SnmpOid trap = null;
                SnmpOidTable mibTable = JVM_MANAGEMENT_MIB_IMPL.getOidTable();
                try {
                    SnmpOid usedOid = null;
                    SnmpOid countOid = null;
                    if (type.equals("java.management.memory.threshold.exceeded")) {
                        trap = new SnmpOid(mibTable.resolveVarName("jvmLowMemoryPoolUsageNotif").getOid());
                        usedOid = new SnmpOid(mibTable.resolveVarName("jvmMemPoolUsed").getOid() + "." + entryIndex);
                        countOid = new SnmpOid(mibTable.resolveVarName("jvmMemPoolThreshdCount").getOid() + "." + entryIndex);
                    } else if (type.equals("java.management.memory.collection.threshold.exceeded")) {
                        trap = new SnmpOid(mibTable.resolveVarName("jvmLowMemoryPoolCollectNotif").getOid());
                        usedOid = new SnmpOid(mibTable.resolveVarName("jvmMemPoolCollectUsed").getOid() + "." + entryIndex);
                        countOid = new SnmpOid(mibTable.resolveVarName("jvmMemPoolCollectThreshdCount").getOid() + "." + entryIndex);
                    }
                    SnmpVarBindList list = new SnmpVarBindList();
                    SnmpOid poolNameOid = new SnmpOid(mibTable.resolveVarName("jvmMemPoolName").getOid() + "." + entryIndex);
                    SnmpVarBind varCount = new SnmpVarBind(countOid, count);
                    SnmpVarBind varUsed = new SnmpVarBind(usedOid, used);
                    SnmpVarBind varPoolName = new SnmpVarBind(poolNameOid, poolName);
                    list.add(varPoolName);
                    list.add(varCount);
                    list.add(varUsed);
                    JVM_MANAGEMENT_MIB_IMPL.this.sendTrap(trap, list);
                }
                catch (Exception e) {
                    log.error("handleNotification", "Exception occurred : " + e);
                }
            }
        }
    }
}

