/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmClassesVerboseLevel;
import sun.management.snmp.jvmmib.JvmClassLoadingMBean;

public class JvmClassLoadingImpl
implements JvmClassLoadingMBean {
    static final EnumJvmClassesVerboseLevel JvmClassesVerboseLevelVerbose = new EnumJvmClassesVerboseLevel("verbose");
    static final EnumJvmClassesVerboseLevel JvmClassesVerboseLevelSilent = new EnumJvmClassesVerboseLevel("silent");

    public JvmClassLoadingImpl(SnmpMib myMib) {
    }

    public JvmClassLoadingImpl(SnmpMib myMib, MBeanServer server) {
    }

    static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    @Override
    public EnumJvmClassesVerboseLevel getJvmClassesVerboseLevel() throws SnmpStatusException {
        if (JvmClassLoadingImpl.getClassLoadingMXBean().isVerbose()) {
            return JvmClassesVerboseLevelVerbose;
        }
        return JvmClassesVerboseLevelSilent;
    }

    @Override
    public void setJvmClassesVerboseLevel(EnumJvmClassesVerboseLevel x) throws SnmpStatusException {
        boolean verbose;
        if (JvmClassesVerboseLevelVerbose.equals(x)) {
            verbose = true;
        } else if (JvmClassesVerboseLevelSilent.equals(x)) {
            verbose = false;
        } else {
            throw new SnmpStatusException(10);
        }
        JvmClassLoadingImpl.getClassLoadingMXBean().setVerbose(verbose);
    }

    @Override
    public void checkJvmClassesVerboseLevel(EnumJvmClassesVerboseLevel x) throws SnmpStatusException {
        if (JvmClassesVerboseLevelVerbose.equals(x)) {
            return;
        }
        if (JvmClassesVerboseLevelSilent.equals(x)) {
            return;
        }
        throw new SnmpStatusException(10);
    }

    @Override
    public Long getJvmClassesUnloadedCount() throws SnmpStatusException {
        return new Long(JvmClassLoadingImpl.getClassLoadingMXBean().getUnloadedClassCount());
    }

    @Override
    public Long getJvmClassesTotalLoadedCount() throws SnmpStatusException {
        return new Long(JvmClassLoadingImpl.getClassLoadingMXBean().getTotalLoadedClassCount());
    }

    @Override
    public Long getJvmClassesLoadedCount() throws SnmpStatusException {
        return new Long(JvmClassLoadingImpl.getClassLoadingMXBean().getLoadedClassCount());
    }
}

