/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.List;
import java.util.Map;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemManagerEntryImpl;
import sun.management.snmp.jvmmib.JvmMemManagerTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpNamedListTableCache;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemManagerTableMetaImpl
extends JvmMemManagerTableMeta {
    static final long serialVersionUID = 36176771566817592L;
    protected SnmpTableCache cache;
    static final MibLogger log = new MibLogger(JvmMemManagerTableMetaImpl.class);

    public JvmMemManagerTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
        this.cache = new JvmMemManagerTableCache(((JVM_MANAGEMENT_MIB_IMPL)myMib).validity());
    }

    @Override
    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        return this.getNextOid(null, userData);
    }

    @Override
    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        SnmpTableHandler handler;
        boolean dbg = log.isDebugOn();
        if (dbg) {
            log.debug("getNextOid", "previous=" + oid);
        }
        if ((handler = this.getHandler(userData)) == null) {
            if (dbg) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid next = handler.getNext(oid);
        if (dbg) {
            log.debug("getNextOid", "next=" + next);
        }
        if (next == null) {
            throw new SnmpStatusException(224);
        }
        return next;
    }

    @Override
    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        return handler.contains(oid);
    }

    @Override
    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        Object entry;
        String entryTag;
        if (oid == null) {
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> m = JvmContextFactory.getUserData();
        long index = oid.getOidArc(0);
        String string = entryTag = m == null ? null : "JvmMemManagerTable.entry." + index;
        if (m != null && (entry = m.get(entryTag)) != null) {
            return entry;
        }
        SnmpTableHandler handler = this.getHandler(m);
        if (handler == null) {
            throw new SnmpStatusException(224);
        }
        Object data = handler.getData(oid);
        if (data == null) {
            throw new SnmpStatusException(224);
        }
        JvmMemManagerEntryImpl entry2 = new JvmMemManagerEntryImpl((MemoryManagerMXBean)data, (int)index);
        if (m != null && entry2 != null) {
            m.put(entryTag, entry2);
        }
        return entry2;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        SnmpTableHandler handler;
        Map m = userData instanceof Map ? (Map)Util.cast(userData) : null;
        if (m != null && (handler = (SnmpTableHandler)m.get("JvmMemManagerTable.handler")) != null) {
            return handler;
        }
        handler = this.cache.getTableHandler();
        if (m != null && handler != null) {
            m.put("JvmMemManagerTable.handler", handler);
        }
        return handler;
    }

    private static class JvmMemManagerTableCache
    extends SnmpNamedListTableCache {
        static final long serialVersionUID = 6564294074653009240L;

        JvmMemManagerTableCache(long validity) {
            this.validity = validity;
        }

        @Override
        protected String getKey(Object context, List<?> rawDatas, int rank, Object item) {
            if (item == null) {
                return null;
            }
            String name = ((MemoryManagerMXBean)item).getName();
            log.debug("getKey", "key=" + name);
            return name;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> userData = JvmContextFactory.getUserData();
            return this.getTableDatas(userData);
        }

        @Override
        protected String getRawDatasKey() {
            return "JvmMemManagerTable.getMemoryManagers";
        }

        protected List<MemoryManagerMXBean> loadRawDatas(Map<Object, Object> userData) {
            return ManagementFactory.getMemoryManagerMXBeans();
        }
    }
}

