/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemManagerTableMetaImpl;
import sun.management.snmp.jvminstr.JvmMemMgrPoolRelEntryImpl;
import sun.management.snmp.jvminstr.JvmMemPoolTableMetaImpl;
import sun.management.snmp.jvmmib.JvmMemMgrPoolRelTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemMgrPoolRelTableMetaImpl
extends JvmMemMgrPoolRelTableMeta
implements Serializable {
    static final long serialVersionUID = 1896509775012355443L;
    protected SnmpTableCache cache;
    private transient JvmMemManagerTableMetaImpl managers = null;
    private transient JvmMemPoolTableMetaImpl pools = null;
    static final MibLogger log = new MibLogger(JvmMemMgrPoolRelTableMetaImpl.class);

    public JvmMemMgrPoolRelTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
        this.cache = new JvmMemMgrPoolRelTableCache(this, ((JVM_MANAGEMENT_MIB_IMPL)myMib).validity());
    }

    private final JvmMemManagerTableMetaImpl getManagers(SnmpMib mib) {
        if (this.managers == null) {
            this.managers = (JvmMemManagerTableMetaImpl)mib.getRegisteredTableMeta("JvmMemManagerTable");
        }
        return this.managers;
    }

    private final JvmMemPoolTableMetaImpl getPools(SnmpMib mib) {
        if (this.pools == null) {
            this.pools = (JvmMemPoolTableMetaImpl)mib.getRegisteredTableMeta("JvmMemPoolTable");
        }
        return this.pools;
    }

    protected SnmpTableHandler getManagerHandler(Object userData) {
        JvmMemManagerTableMetaImpl managerTable = this.getManagers(this.theMib);
        return managerTable.getHandler(userData);
    }

    protected SnmpTableHandler getPoolHandler(Object userData) {
        JvmMemPoolTableMetaImpl poolTable = this.getPools(this.theMib);
        return poolTable.getHandler(userData);
    }

    @Override
    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        return this.getNextOid(null, userData);
    }

    @Override
    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        SnmpTableHandler handler;
        boolean dbg = log.isDebugOn();
        if (dbg) {
            log.debug("getNextOid", "previous=" + oid);
        }
        if ((handler = this.getHandler(userData)) == null) {
            if (dbg) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid next = handler.getNext(oid);
        if (dbg) {
            log.debug("getNextOid", "next=" + next);
        }
        if (next == null) {
            throw new SnmpStatusException(224);
        }
        return next;
    }

    @Override
    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        return handler.contains(oid);
    }

    @Override
    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        Object entry;
        String entryTag;
        if (oid == null || oid.getLength() < 2) {
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> m = JvmContextFactory.getUserData();
        long mgrIndex = oid.getOidArc(0);
        long poolIndex = oid.getOidArc(1);
        String string = entryTag = m == null ? null : "JvmMemMgrPoolRelTable.entry." + mgrIndex + "." + poolIndex;
        if (m != null && (entry = m.get(entryTag)) != null) {
            return entry;
        }
        SnmpTableHandler handler = this.getHandler(m);
        if (handler == null) {
            throw new SnmpStatusException(224);
        }
        Object data = handler.getData(oid);
        if (!(data instanceof JvmMemMgrPoolRelEntryImpl)) {
            throw new SnmpStatusException(224);
        }
        JvmMemMgrPoolRelEntryImpl entry2 = (JvmMemMgrPoolRelEntryImpl)data;
        if (m != null && entry2 != null) {
            m.put(entryTag, entry2);
        }
        return entry2;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        SnmpTableHandler handler;
        Map m = userData instanceof Map ? (Map)Util.cast(userData) : null;
        if (m != null && (handler = (SnmpTableHandler)m.get("JvmMemMgrPoolRelTable.handler")) != null) {
            return handler;
        }
        handler = this.cache.getTableHandler();
        if (m != null && handler != null) {
            m.put("JvmMemMgrPoolRelTable.handler", handler);
        }
        return handler;
    }

    private static class JvmMemMgrPoolRelTableCache
    extends SnmpTableCache {
        static final long serialVersionUID = 6059937161990659184L;
        private final JvmMemMgrPoolRelTableMetaImpl meta;

        JvmMemMgrPoolRelTableCache(JvmMemMgrPoolRelTableMetaImpl meta, long validity) {
            this.validity = validity;
            this.meta = meta;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> userData = JvmContextFactory.getUserData();
            return this.getTableDatas(userData);
        }

        private static Map<String, SnmpOid> buildPoolIndexMap(SnmpTableHandler handler) {
            if (handler instanceof SnmpCachedData) {
                return JvmMemMgrPoolRelTableCache.buildPoolIndexMap((SnmpCachedData)handler);
            }
            HashMap<String, SnmpOid> m = new HashMap<String, SnmpOid>();
            SnmpOid index = null;
            while ((index = handler.getNext(index)) != null) {
                String name;
                MemoryPoolMXBean mpm = (MemoryPoolMXBean)handler.getData(index);
                if (mpm == null || (name = mpm.getName()) == null) continue;
                m.put(name, index);
            }
            return m;
        }

        private static Map<String, SnmpOid> buildPoolIndexMap(SnmpCachedData cached) {
            if (cached == null) {
                return Collections.emptyMap();
            }
            SnmpOid[] indexes = cached.indexes;
            Object[] datas = cached.datas;
            int len = indexes.length;
            HashMap<String, SnmpOid> m = new HashMap<String, SnmpOid>(len);
            for (int i = 0; i < len; ++i) {
                String name;
                MemoryPoolMXBean mpm;
                SnmpOid index = indexes[i];
                if (index == null || (mpm = (MemoryPoolMXBean)datas[i]) == null || (name = mpm.getName()) == null) continue;
                m.put(name, index);
            }
            return m;
        }

        @Override
        protected SnmpCachedData updateCachedDatas(Object userData) {
            SnmpTableHandler mmHandler = this.meta.getManagerHandler(userData);
            SnmpTableHandler mpHandler = this.meta.getPoolHandler(userData);
            long time = System.currentTimeMillis();
            Map<String, SnmpOid> poolIndexMap = JvmMemMgrPoolRelTableCache.buildPoolIndexMap(mpHandler);
            TreeMap<SnmpOid, Object> table = new TreeMap<SnmpOid, Object>(SnmpCachedData.oidComparator);
            this.updateTreeMap(table, userData, mmHandler, mpHandler, poolIndexMap);
            return new SnmpCachedData(time, table);
        }

        protected String[] getMemoryPools(Object userData, MemoryManagerMXBean mmm, long mmarc) {
            String listTag = "JvmMemManager." + mmarc + ".getMemoryPools";
            String[] result = null;
            if (userData instanceof Map && (result = (String[])((Map)userData).get(listTag)) != null) {
                return result;
            }
            if (mmm != null) {
                result = mmm.getMemoryPoolNames();
            }
            if (result != null && userData instanceof Map) {
                Map map = (Map)Util.cast(userData);
                map.put(listTag, result);
            }
            return result;
        }

        protected void updateTreeMap(TreeMap<SnmpOid, Object> table, Object userData, MemoryManagerMXBean mmm, SnmpOid mmIndex, Map<String, SnmpOid> poolIndexMap) {
            long mmarc;
            try {
                mmarc = mmIndex.getOidArc(0);
            }
            catch (SnmpStatusException x) {
                log.debug("updateTreeMap", "Bad MemoryManager OID index: " + mmIndex);
                log.debug("updateTreeMap", x);
                return;
            }
            String[] mpList = this.getMemoryPools(userData, mmm, mmarc);
            if (mpList == null || mpList.length < 1) {
                return;
            }
            String mmmName = mmm.getName();
            for (int i = 0; i < mpList.length; ++i) {
                long mparc;
                SnmpOid mpIndex;
                String mpmName = mpList[i];
                if (mpmName == null || (mpIndex = poolIndexMap.get(mpmName)) == null) continue;
                try {
                    mparc = mpIndex.getOidArc(0);
                }
                catch (SnmpStatusException x) {
                    log.debug("updateTreeMap", "Bad MemoryPool OID index: " + mpIndex);
                    log.debug("updateTreeMap", x);
                    continue;
                }
                long[] arcs = new long[]{mmarc, mparc};
                SnmpOid index = new SnmpOid(arcs);
                table.put(index, new JvmMemMgrPoolRelEntryImpl(mmmName, mpmName, (int)mmarc, (int)mparc));
            }
        }

        protected void updateTreeMap(TreeMap<SnmpOid, Object> table, Object userData, SnmpTableHandler mmHandler, SnmpTableHandler mpHandler, Map<String, SnmpOid> poolIndexMap) {
            if (mmHandler instanceof SnmpCachedData) {
                this.updateTreeMap(table, userData, (SnmpCachedData)mmHandler, mpHandler, poolIndexMap);
                return;
            }
            SnmpOid mmIndex = null;
            while ((mmIndex = mmHandler.getNext(mmIndex)) != null) {
                MemoryManagerMXBean mmm = (MemoryManagerMXBean)mmHandler.getData(mmIndex);
                if (mmm == null) continue;
                this.updateTreeMap(table, userData, mmm, mmIndex, poolIndexMap);
            }
        }

        protected void updateTreeMap(TreeMap<SnmpOid, Object> table, Object userData, SnmpCachedData mmHandler, SnmpTableHandler mpHandler, Map<String, SnmpOid> poolIndexMap) {
            SnmpOid[] indexes = mmHandler.indexes;
            Object[] datas = mmHandler.datas;
            int size = indexes.length;
            for (int i = size - 1; i > -1; --i) {
                MemoryManagerMXBean mmm = (MemoryManagerMXBean)datas[i];
                if (mmm == null) continue;
                this.updateTreeMap(table, userData, mmm, indexes[i], poolIndexMap);
            }
        }
    }
}

