/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCCall;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCVerboseLevel;
import sun.management.snmp.jvmmib.JvmMemoryMBean;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;

public class JvmMemoryImpl
implements JvmMemoryMBean {
    static final EnumJvmMemoryGCCall JvmMemoryGCCallSupported = new EnumJvmMemoryGCCall("supported");
    static final EnumJvmMemoryGCCall JvmMemoryGCCallStart = new EnumJvmMemoryGCCall("start");
    static final EnumJvmMemoryGCCall JvmMemoryGCCallFailed = new EnumJvmMemoryGCCall("failed");
    static final EnumJvmMemoryGCCall JvmMemoryGCCallStarted = new EnumJvmMemoryGCCall("started");
    static final EnumJvmMemoryGCVerboseLevel JvmMemoryGCVerboseLevelVerbose = new EnumJvmMemoryGCVerboseLevel("verbose");
    static final EnumJvmMemoryGCVerboseLevel JvmMemoryGCVerboseLevelSilent = new EnumJvmMemoryGCVerboseLevel("silent");
    static final String heapMemoryTag = "jvmMemory.getHeapMemoryUsage";
    static final String nonHeapMemoryTag = "jvmMemory.getNonHeapMemoryUsage";
    static final Long Long0 = new Long(0L);
    static final MibLogger log = new MibLogger(JvmMemoryImpl.class);

    public JvmMemoryImpl(SnmpMib myMib) {
    }

    public JvmMemoryImpl(SnmpMib myMib, MBeanServer server) {
    }

    private MemoryUsage getMemoryUsage(MemoryType type) {
        if (type == MemoryType.HEAP) {
            return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        }
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
    }

    MemoryUsage getNonHeapMemoryUsage() {
        try {
            Map<Object, Object> m = JvmContextFactory.getUserData();
            if (m != null) {
                MemoryUsage cached = (MemoryUsage)m.get(nonHeapMemoryTag);
                if (cached != null) {
                    log.debug("getNonHeapMemoryUsage", "jvmMemory.getNonHeapMemoryUsage found in cache.");
                    return cached;
                }
                MemoryUsage u = this.getMemoryUsage(MemoryType.NON_HEAP);
                m.put(nonHeapMemoryTag, u);
                return u;
            }
            log.trace("getNonHeapMemoryUsage", "ERROR: should never come here!");
            return this.getMemoryUsage(MemoryType.NON_HEAP);
        }
        catch (RuntimeException x) {
            log.trace("getNonHeapMemoryUsage", "Failed to get NonHeapMemoryUsage: " + x);
            log.debug("getNonHeapMemoryUsage", x);
            throw x;
        }
    }

    MemoryUsage getHeapMemoryUsage() {
        try {
            Map<Object, Object> m = JvmContextFactory.getUserData();
            if (m != null) {
                MemoryUsage cached = (MemoryUsage)m.get(heapMemoryTag);
                if (cached != null) {
                    log.debug("getHeapMemoryUsage", "jvmMemory.getHeapMemoryUsage found in cache.");
                    return cached;
                }
                MemoryUsage u = this.getMemoryUsage(MemoryType.HEAP);
                m.put(heapMemoryTag, u);
                return u;
            }
            log.trace("getHeapMemoryUsage", "ERROR: should never come here!");
            return this.getMemoryUsage(MemoryType.HEAP);
        }
        catch (RuntimeException x) {
            log.trace("getHeapMemoryUsage", "Failed to get HeapMemoryUsage: " + x);
            log.debug("getHeapMemoryUsage", x);
            throw x;
        }
    }

    @Override
    public Long getJvmMemoryNonHeapMaxSize() throws SnmpStatusException {
        long val = this.getNonHeapMemoryUsage().getMax();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public Long getJvmMemoryNonHeapCommitted() throws SnmpStatusException {
        long val = this.getNonHeapMemoryUsage().getCommitted();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public Long getJvmMemoryNonHeapUsed() throws SnmpStatusException {
        long val = this.getNonHeapMemoryUsage().getUsed();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public Long getJvmMemoryNonHeapInitSize() throws SnmpStatusException {
        long val = this.getNonHeapMemoryUsage().getInit();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public Long getJvmMemoryHeapMaxSize() throws SnmpStatusException {
        long val = this.getHeapMemoryUsage().getMax();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public EnumJvmMemoryGCCall getJvmMemoryGCCall() throws SnmpStatusException {
        EnumJvmMemoryGCCall cached;
        Map<Object, Object> m = JvmContextFactory.getUserData();
        if (m != null && (cached = (EnumJvmMemoryGCCall)m.get("jvmMemory.getJvmMemoryGCCall")) != null) {
            return cached;
        }
        return JvmMemoryGCCallSupported;
    }

    @Override
    public void setJvmMemoryGCCall(EnumJvmMemoryGCCall x) throws SnmpStatusException {
        if (x.intValue() == JvmMemoryGCCallStart.intValue()) {
            block4: {
                Map<Object, Object> m = JvmContextFactory.getUserData();
                try {
                    ManagementFactory.getMemoryMXBean().gc();
                    if (m != null) {
                        m.put("jvmMemory.getJvmMemoryGCCall", JvmMemoryGCCallStarted);
                    }
                }
                catch (Exception ex) {
                    if (m == null) break block4;
                    m.put("jvmMemory.getJvmMemoryGCCall", JvmMemoryGCCallFailed);
                }
            }
            return;
        }
        throw new SnmpStatusException(10);
    }

    @Override
    public void checkJvmMemoryGCCall(EnumJvmMemoryGCCall x) throws SnmpStatusException {
        if (x.intValue() != JvmMemoryGCCallStart.intValue()) {
            throw new SnmpStatusException(10);
        }
    }

    @Override
    public Long getJvmMemoryHeapCommitted() throws SnmpStatusException {
        long val = this.getHeapMemoryUsage().getCommitted();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public EnumJvmMemoryGCVerboseLevel getJvmMemoryGCVerboseLevel() throws SnmpStatusException {
        if (ManagementFactory.getMemoryMXBean().isVerbose()) {
            return JvmMemoryGCVerboseLevelVerbose;
        }
        return JvmMemoryGCVerboseLevelSilent;
    }

    @Override
    public void setJvmMemoryGCVerboseLevel(EnumJvmMemoryGCVerboseLevel x) throws SnmpStatusException {
        if (JvmMemoryGCVerboseLevelVerbose.intValue() == x.intValue()) {
            ManagementFactory.getMemoryMXBean().setVerbose(true);
        } else {
            ManagementFactory.getMemoryMXBean().setVerbose(false);
        }
    }

    @Override
    public void checkJvmMemoryGCVerboseLevel(EnumJvmMemoryGCVerboseLevel x) throws SnmpStatusException {
    }

    @Override
    public Long getJvmMemoryHeapUsed() throws SnmpStatusException {
        long val = this.getHeapMemoryUsage().getUsed();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public Long getJvmMemoryHeapInitSize() throws SnmpStatusException {
        long val = this.getHeapMemoryUsage().getInit();
        if (val > -1L) {
            return new Long(val);
        }
        return Long0;
    }

    @Override
    public Long getJvmMemoryPendingFinalCount() throws SnmpStatusException {
        long val = ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
        if (val > -1L) {
            return new Long((int)val);
        }
        return new Long(0L);
    }
}

