/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmRTLibraryPathEntryImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvmmib.JvmRTLibraryPathTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmRTLibraryPathTableMetaImpl
extends JvmRTLibraryPathTableMeta {
    static final long serialVersionUID = 6713252710712502068L;
    private SnmpTableCache cache = new JvmRTLibraryPathTableCache(this, -1L);
    static final MibLogger log = new MibLogger(JvmRTLibraryPathTableMetaImpl.class);

    public JvmRTLibraryPathTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
    }

    @Override
    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        return this.getNextOid(null, userData);
    }

    @Override
    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        SnmpTableHandler handler;
        boolean dbg = log.isDebugOn();
        if (dbg) {
            log.debug("getNextOid", "previous=" + oid);
        }
        if ((handler = this.getHandler(userData)) == null) {
            if (dbg) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid next = handler.getNext(oid);
        if (dbg) {
            log.debug("*** **** **** **** getNextOid", "next=" + next);
        }
        if (next == null) {
            throw new SnmpStatusException(224);
        }
        return next;
    }

    @Override
    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        return handler.contains(oid);
    }

    @Override
    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        SnmpTableHandler handler;
        String entryTag;
        boolean dbg = log.isDebugOn();
        if (dbg) {
            log.debug("getEntry", "oid [" + oid + "]");
        }
        if (oid == null || oid.getLength() != 1) {
            if (dbg) {
                log.debug("getEntry", "Invalid oid [" + oid + "]");
            }
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> m = JvmContextFactory.getUserData();
        String string = entryTag = m == null ? null : "JvmRTLibraryPathTable.entry." + oid.toString();
        if (m != null) {
            Object entry = m.get(entryTag);
            if (entry != null) {
                if (dbg) {
                    log.debug("getEntry", "Entry is already in the cache");
                }
                return entry;
            }
            if (dbg) {
                log.debug("getEntry", "Entry is not in the cache");
            }
        }
        if ((handler = this.getHandler(m)) == null) {
            throw new SnmpStatusException(224);
        }
        Object data = handler.getData(oid);
        if (data == null) {
            throw new SnmpStatusException(224);
        }
        if (dbg) {
            log.debug("getEntry", "data is a: " + data.getClass().getName());
        }
        JvmRTLibraryPathEntryImpl entry = new JvmRTLibraryPathEntryImpl((String)data, (int)oid.getOidArc(0));
        if (m != null && entry != null) {
            m.put(entryTag, entry);
        }
        return entry;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        SnmpTableHandler handler;
        Map m = userData instanceof Map ? (Map)Util.cast(userData) : null;
        if (m != null && (handler = (SnmpTableHandler)m.get("JvmRTLibraryPathTable.handler")) != null) {
            return handler;
        }
        handler = this.cache.getTableHandler();
        if (m != null && handler != null) {
            m.put("JvmRTLibraryPathTable.handler", handler);
        }
        return handler;
    }

    private static class JvmRTLibraryPathTableCache
    extends SnmpTableCache {
        static final long serialVersionUID = 2035304445719393195L;
        private JvmRTLibraryPathTableMetaImpl meta;

        JvmRTLibraryPathTableCache(JvmRTLibraryPathTableMetaImpl meta, long validity) {
            this.meta = meta;
            this.validity = validity;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> userData = JvmContextFactory.getUserData();
            return this.getTableDatas(userData);
        }

        @Override
        protected SnmpCachedData updateCachedDatas(Object userData) {
            Object[] path = JvmRuntimeImpl.getLibraryPath(userData);
            long time = System.currentTimeMillis();
            int len = path.length;
            SnmpOid[] indexes = new SnmpOid[len];
            for (int i = 0; i < len; ++i) {
                indexes[i] = new SnmpOid(i + 1);
            }
            return new SnmpCachedData(time, indexes, path);
        }
    }
}

