/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvmmib.EnumJvmRTBootClassPathSupport;
import sun.management.snmp.jvmmib.JvmRuntimeMBean;
import sun.management.snmp.util.JvmContextFactory;

public class JvmRuntimeImpl
implements JvmRuntimeMBean {
    static final EnumJvmRTBootClassPathSupport JvmRTBootClassPathSupportSupported = new EnumJvmRTBootClassPathSupport("supported");
    static final EnumJvmRTBootClassPathSupport JvmRTBootClassPathSupportUnSupported = new EnumJvmRTBootClassPathSupport("unsupported");

    public JvmRuntimeImpl(SnmpMib myMib) {
    }

    public JvmRuntimeImpl(SnmpMib myMib, MBeanServer server) {
    }

    static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    private static String validDisplayStringTC(String str) {
        return JVM_MANAGEMENT_MIB_IMPL.validDisplayStringTC(str);
    }

    private static String validPathElementTC(String str) {
        return JVM_MANAGEMENT_MIB_IMPL.validPathElementTC(str);
    }

    private static String validJavaObjectNameTC(String str) {
        return JVM_MANAGEMENT_MIB_IMPL.validJavaObjectNameTC(str);
    }

    static String[] splitPath(String path) {
        String[] items = path.split(File.pathSeparator);
        return items;
    }

    static String[] getClassPath(Object userData) {
        String[] cached;
        Map m = (Map)Util.cast(userData instanceof Map ? userData : null);
        String tag = "JvmRuntime.getClassPath";
        if (m != null && (cached = (String[])m.get("JvmRuntime.getClassPath")) != null) {
            return cached;
        }
        String[] args = JvmRuntimeImpl.splitPath(JvmRuntimeImpl.getRuntimeMXBean().getClassPath());
        if (m != null) {
            m.put("JvmRuntime.getClassPath", args);
        }
        return args;
    }

    static String[] getBootClassPath(Object userData) {
        String[] cached;
        if (!JvmRuntimeImpl.getRuntimeMXBean().isBootClassPathSupported()) {
            return new String[0];
        }
        Map m = (Map)Util.cast(userData instanceof Map ? userData : null);
        String tag = "JvmRuntime.getBootClassPath";
        if (m != null && (cached = (String[])m.get("JvmRuntime.getBootClassPath")) != null) {
            return cached;
        }
        String[] args = JvmRuntimeImpl.splitPath(JvmRuntimeImpl.getRuntimeMXBean().getBootClassPath());
        if (m != null) {
            m.put("JvmRuntime.getBootClassPath", args);
        }
        return args;
    }

    static String[] getLibraryPath(Object userData) {
        String[] cached;
        Map m = (Map)Util.cast(userData instanceof Map ? userData : null);
        String tag = "JvmRuntime.getLibraryPath";
        if (m != null && (cached = (String[])m.get("JvmRuntime.getLibraryPath")) != null) {
            return cached;
        }
        String[] args = JvmRuntimeImpl.splitPath(JvmRuntimeImpl.getRuntimeMXBean().getLibraryPath());
        if (m != null) {
            m.put("JvmRuntime.getLibraryPath", args);
        }
        return args;
    }

    static String[] getInputArguments(Object userData) {
        String[] cached;
        Map m = (Map)Util.cast(userData instanceof Map ? userData : null);
        String tag = "JvmRuntime.getInputArguments";
        if (m != null && (cached = (String[])m.get("JvmRuntime.getInputArguments")) != null) {
            return cached;
        }
        List<String> l = JvmRuntimeImpl.getRuntimeMXBean().getInputArguments();
        String[] args = l.toArray(new String[0]);
        if (m != null) {
            m.put("JvmRuntime.getInputArguments", args);
        }
        return args;
    }

    @Override
    public String getJvmRTSpecVendor() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getSpecVendor());
    }

    @Override
    public String getJvmRTSpecName() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getSpecName());
    }

    @Override
    public String getJvmRTVMVersion() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getVmVersion());
    }

    @Override
    public String getJvmRTVMVendor() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getVmVendor());
    }

    @Override
    public String getJvmRTManagementSpecVersion() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getManagementSpecVersion());
    }

    @Override
    public String getJvmRTVMName() throws SnmpStatusException {
        return JvmRuntimeImpl.validJavaObjectNameTC(JvmRuntimeImpl.getRuntimeMXBean().getVmName());
    }

    @Override
    public Integer getJvmRTInputArgsCount() throws SnmpStatusException {
        String[] args = JvmRuntimeImpl.getInputArguments(JvmContextFactory.getUserData());
        return new Integer(args.length);
    }

    @Override
    public EnumJvmRTBootClassPathSupport getJvmRTBootClassPathSupport() throws SnmpStatusException {
        if (JvmRuntimeImpl.getRuntimeMXBean().isBootClassPathSupported()) {
            return JvmRTBootClassPathSupportSupported;
        }
        return JvmRTBootClassPathSupportUnSupported;
    }

    @Override
    public Long getJvmRTUptimeMs() throws SnmpStatusException {
        return new Long(JvmRuntimeImpl.getRuntimeMXBean().getUptime());
    }

    @Override
    public Long getJvmRTStartTimeMs() throws SnmpStatusException {
        return new Long(JvmRuntimeImpl.getRuntimeMXBean().getStartTime());
    }

    @Override
    public String getJvmRTSpecVersion() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getSpecVersion());
    }

    @Override
    public String getJvmRTName() throws SnmpStatusException {
        return JvmRuntimeImpl.validDisplayStringTC(JvmRuntimeImpl.getRuntimeMXBean().getName());
    }
}

