/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpStatusException;
import java.io.Serializable;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmThreadInstanceTableMetaImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvmmib.JVM_MANAGEMENT_MIBOidTable;
import sun.management.snmp.jvmmib.JvmThreadInstanceEntryMBean;
import sun.management.snmp.util.MibLogger;

public class JvmThreadInstanceEntryImpl
implements JvmThreadInstanceEntryMBean,
Serializable {
    static final long serialVersionUID = 910173589985461347L;
    private final ThreadInfo info;
    private final Byte[] index;
    private static String jvmThreadInstIndexOid = null;
    static final MibLogger log = new MibLogger(JvmThreadInstanceEntryImpl.class);

    public JvmThreadInstanceEntryImpl(ThreadInfo info, Byte[] index) {
        this.info = info;
        this.index = index;
    }

    public static String getJvmThreadInstIndexOid() throws SnmpStatusException {
        if (jvmThreadInstIndexOid == null) {
            JVM_MANAGEMENT_MIBOidTable table = new JVM_MANAGEMENT_MIBOidTable();
            SnmpOidRecord record = table.resolveVarName("jvmThreadInstIndex");
            jvmThreadInstIndexOid = record.getOid();
        }
        return jvmThreadInstIndexOid;
    }

    @Override
    public String getJvmThreadInstLockOwnerPtr() throws SnmpStatusException {
        long id = this.info.getLockOwnerId();
        if (id == -1L) {
            return new String("0.0");
        }
        SnmpOid oid = JvmThreadInstanceTableMetaImpl.makeOid(id);
        return JvmThreadInstanceEntryImpl.getJvmThreadInstIndexOid() + "." + oid.toString();
    }

    private String validDisplayStringTC(String str) {
        return JVM_MANAGEMENT_MIB_IMPL.validDisplayStringTC(str);
    }

    private String validJavaObjectNameTC(String str) {
        return JVM_MANAGEMENT_MIB_IMPL.validJavaObjectNameTC(str);
    }

    private String validPathElementTC(String str) {
        return JVM_MANAGEMENT_MIB_IMPL.validPathElementTC(str);
    }

    @Override
    public String getJvmThreadInstLockName() throws SnmpStatusException {
        return this.validJavaObjectNameTC(this.info.getLockName());
    }

    @Override
    public String getJvmThreadInstName() throws SnmpStatusException {
        return this.validJavaObjectNameTC(this.info.getThreadName());
    }

    @Override
    public Long getJvmThreadInstCpuTimeNs() throws SnmpStatusException {
        long l = 0L;
        ThreadMXBean tmb = JvmThreadingImpl.getThreadMXBean();
        try {
            if (tmb.isThreadCpuTimeSupported()) {
                l = tmb.getThreadCpuTime(this.info.getThreadId());
                log.debug("getJvmThreadInstCpuTimeNs", "Cpu time ns : " + l);
                if (l == -1L) {
                    l = 0L;
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            log.debug("getJvmThreadInstCpuTimeNs", "Operation not supported: " + e);
        }
        return new Long(l);
    }

    @Override
    public Long getJvmThreadInstBlockTimeMs() throws SnmpStatusException {
        long l = 0L;
        ThreadMXBean tmb = JvmThreadingImpl.getThreadMXBean();
        if (tmb.isThreadContentionMonitoringSupported() && (l = this.info.getBlockedTime()) == -1L) {
            l = 0L;
        }
        return new Long(l);
    }

    @Override
    public Long getJvmThreadInstBlockCount() throws SnmpStatusException {
        return new Long(this.info.getBlockedCount());
    }

    @Override
    public Long getJvmThreadInstWaitTimeMs() throws SnmpStatusException {
        long l = 0L;
        ThreadMXBean tmb = JvmThreadingImpl.getThreadMXBean();
        if (tmb.isThreadContentionMonitoringSupported() && (l = this.info.getWaitedTime()) == -1L) {
            l = 0L;
        }
        return new Long(l);
    }

    @Override
    public Long getJvmThreadInstWaitCount() throws SnmpStatusException {
        return new Long(this.info.getWaitedCount());
    }

    @Override
    public Byte[] getJvmThreadInstState() throws SnmpStatusException {
        return ThreadStateMap.getState(this.info);
    }

    @Override
    public Long getJvmThreadInstId() throws SnmpStatusException {
        return new Long(this.info.getThreadId());
    }

    @Override
    public Byte[] getJvmThreadInstIndex() throws SnmpStatusException {
        return this.index;
    }

    private String getJvmThreadInstStackTrace() throws SnmpStatusException {
        StackTraceElement[] stackTrace = this.info.getStackTrace();
        StringBuffer b = new StringBuffer();
        int stackSize = stackTrace.length;
        log.debug("getJvmThreadInstStackTrace", "Stack size : " + stackSize);
        for (int i = 0; i < stackSize; ++i) {
            log.debug("getJvmThreadInstStackTrace", "Append " + stackTrace[i].toString());
            b.append(stackTrace[i].toString());
            if (i >= stackSize) continue;
            b.append("\n");
        }
        return this.validPathElementTC(b.toString());
    }

    public static final class ThreadStateMap {
        public static final byte mask0 = 63;
        public static final byte mask1 = -128;

        private static void setBit(byte[] bitmap, int index, byte state) {
            bitmap[index] = (byte)(bitmap[index] | state);
        }

        public static void setNative(byte[] bitmap) {
            ThreadStateMap.setBit(bitmap, 0, (byte)-128);
        }

        public static void setSuspended(byte[] bitmap) {
            ThreadStateMap.setBit(bitmap, 0, (byte)64);
        }

        public static void setState(byte[] bitmap, Thread.State state) {
            switch (state) {
                case BLOCKED: {
                    ThreadStateMap.setBit(bitmap, 0, (byte)8);
                    return;
                }
                case NEW: {
                    ThreadStateMap.setBit(bitmap, 0, (byte)32);
                    return;
                }
                case RUNNABLE: {
                    ThreadStateMap.setBit(bitmap, 0, (byte)16);
                    return;
                }
                case TERMINATED: {
                    ThreadStateMap.setBit(bitmap, 0, (byte)4);
                    return;
                }
                case TIMED_WAITING: {
                    ThreadStateMap.setBit(bitmap, 0, (byte)1);
                    return;
                }
                case WAITING: {
                    ThreadStateMap.setBit(bitmap, 0, (byte)2);
                    return;
                }
            }
        }

        public static void checkOther(byte[] bitmap) {
            if ((bitmap[0] & 0x3F) == 0 && (bitmap[1] & 0xFFFFFF80) == 0) {
                ThreadStateMap.setBit(bitmap, 1, (byte)-128);
            }
        }

        public static Byte[] getState(ThreadInfo info) {
            byte[] bitmap = new byte[]{0, 0};
            try {
                Thread.State state = info.getThreadState();
                boolean inNative = info.isInNative();
                boolean suspended = info.isSuspended();
                log.debug("getJvmThreadInstState", "[State=" + (Object)((Object)state) + ",isInNative=" + inNative + ",isSuspended=" + suspended + "]");
                ThreadStateMap.setState(bitmap, state);
                if (inNative) {
                    ThreadStateMap.setNative(bitmap);
                }
                if (suspended) {
                    ThreadStateMap.setSuspended(bitmap);
                }
                ThreadStateMap.checkOther(bitmap);
            }
            catch (RuntimeException r) {
                bitmap[0] = 0;
                bitmap[1] = -128;
                log.trace("getJvmThreadInstState", "Unexpected exception: " + r);
                log.debug("getJvmThreadInstState", r);
            }
            Byte[] result = new Byte[]{new Byte(bitmap[0]), new Byte(bitmap[1])};
            return result;
        }

        public static final class Byte1 {
            public static final byte other = -128;
            public static final byte reserved10 = 64;
            public static final byte reserved11 = 32;
            public static final byte reserved12 = 16;
            public static final byte reserved13 = 8;
            public static final byte reserved14 = 4;
            public static final byte reserved15 = 2;
            public static final byte reserved16 = 1;
        }

        public static final class Byte0 {
            public static final byte inNative = -128;
            public static final byte suspended = 64;
            public static final byte newThread = 32;
            public static final byte runnable = 16;
            public static final byte blocked = 8;
            public static final byte terminated = 4;
            public static final byte waiting = 2;
            public static final byte timedWaiting = 1;
        }
    }
}

