/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.TreeMap;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmThreadInstanceEntryImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvmmib.JvmThreadInstanceTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmThreadInstanceTableMetaImpl
extends JvmThreadInstanceTableMeta {
    static final long serialVersionUID = -8432271929226397492L;
    public static final int MAX_STACK_TRACE_DEPTH = 0;
    protected SnmpTableCache cache;
    static final MibLogger log = new MibLogger(JvmThreadInstanceTableMetaImpl.class);

    static SnmpOid makeOid(long l) {
        long[] x = new long[]{l >> 56 & 0xFFL, l >> 48 & 0xFFL, l >> 40 & 0xFFL, l >> 32 & 0xFFL, l >> 24 & 0xFFL, l >> 16 & 0xFFL, l >> 8 & 0xFFL, l & 0xFFL};
        return new SnmpOid(x);
    }

    static long makeId(SnmpOid oid) {
        long id = 0L;
        long[] arcs = oid.longValue(false);
        id |= arcs[0] << 56;
        id |= arcs[1] << 48;
        id |= arcs[2] << 40;
        id |= arcs[3] << 32;
        id |= arcs[4] << 24;
        id |= arcs[5] << 16;
        id |= arcs[6] << 8;
        return id |= arcs[7];
    }

    public JvmThreadInstanceTableMetaImpl(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib, objserv);
        this.cache = new JvmThreadInstanceTableCache(this, ((JVM_MANAGEMENT_MIB_IMPL)myMib).validity());
        log.debug("JvmThreadInstanceTableMetaImpl", "Create Thread meta");
    }

    @Override
    protected SnmpOid getNextOid(Object userData) throws SnmpStatusException {
        log.debug("JvmThreadInstanceTableMetaImpl", "getNextOid");
        return this.getNextOid(null, userData);
    }

    @Override
    protected SnmpOid getNextOid(SnmpOid oid, Object userData) throws SnmpStatusException {
        log.debug("getNextOid", "previous=" + oid);
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            log.debug("getNextOid", "handler is null!");
            throw new SnmpStatusException(224);
        }
        SnmpOid next = oid;
        while ((next = handler.getNext(next)) != null && this.getJvmThreadInstance(userData, next) == null) {
        }
        log.debug("*** **** **** **** getNextOid", "next=" + next);
        if (next == null) {
            throw new SnmpStatusException(224);
        }
        return next;
    }

    @Override
    protected boolean contains(SnmpOid oid, Object userData) {
        SnmpTableHandler handler = this.getHandler(userData);
        if (handler == null) {
            return false;
        }
        if (!handler.contains(oid)) {
            return false;
        }
        JvmThreadInstanceEntryImpl inst = this.getJvmThreadInstance(userData, oid);
        return inst != null;
    }

    @Override
    public Object getEntry(SnmpOid oid) throws SnmpStatusException {
        log.debug("*** **** **** **** getEntry", "oid [" + oid + "]");
        if (oid == null || oid.getLength() != 8) {
            log.debug("getEntry", "Invalid oid [" + oid + "]");
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> m = JvmContextFactory.getUserData();
        SnmpTableHandler handler = this.getHandler(m);
        if (handler == null || !handler.contains(oid)) {
            throw new SnmpStatusException(224);
        }
        JvmThreadInstanceEntryImpl entry = this.getJvmThreadInstance(m, oid);
        if (entry == null) {
            throw new SnmpStatusException(224);
        }
        return entry;
    }

    protected SnmpTableHandler getHandler(Object userData) {
        SnmpTableHandler handler;
        Map m = userData instanceof Map ? (Map)Util.cast(userData) : null;
        if (m != null && (handler = (SnmpTableHandler)m.get("JvmThreadInstanceTable.handler")) != null) {
            return handler;
        }
        handler = this.cache.getTableHandler();
        if (m != null && handler != null) {
            m.put("JvmThreadInstanceTable.handler", handler);
        }
        return handler;
    }

    private ThreadInfo getThreadInfo(long id) {
        return JvmThreadingImpl.getThreadMXBean().getThreadInfo(id, 0);
    }

    private ThreadInfo getThreadInfo(SnmpOid oid) {
        return this.getThreadInfo(JvmThreadInstanceTableMetaImpl.makeId(oid));
    }

    private JvmThreadInstanceEntryImpl getJvmThreadInstance(Object userData, SnmpOid oid) {
        JvmThreadInstanceEntryImpl cached = null;
        String entryTag = null;
        Map map = null;
        boolean dbg = log.isDebugOn();
        if (userData instanceof Map) {
            map = (Map)Util.cast(userData);
            entryTag = "JvmThreadInstanceTable.entry." + oid.toString();
            cached = (JvmThreadInstanceEntryImpl)map.get(entryTag);
        }
        if (cached != null) {
            if (dbg) {
                log.debug("*** getJvmThreadInstance", "Entry found in cache: " + entryTag);
            }
            return cached;
        }
        if (dbg) {
            log.debug("*** getJvmThreadInstance", "Entry [" + oid + "] is not in cache");
        }
        ThreadInfo info = null;
        try {
            info = this.getThreadInfo(oid);
        }
        catch (RuntimeException r) {
            log.trace("*** getJvmThreadInstance", "Failed to get thread info for rowOid: " + oid);
            log.debug("*** getJvmThreadInstance", r);
        }
        if (info == null) {
            if (dbg) {
                log.debug("*** getJvmThreadInstance", "No entry by that oid [" + oid + "]");
            }
            return null;
        }
        cached = new JvmThreadInstanceEntryImpl(info, oid.toByte());
        if (map != null) {
            map.put(entryTag, cached);
        }
        if (dbg) {
            log.debug("*** getJvmThreadInstance", "Entry created for Thread OID [" + oid + "]");
        }
        return cached;
    }

    private static class JvmThreadInstanceTableCache
    extends SnmpTableCache {
        static final long serialVersionUID = 4947330124563406878L;
        private final JvmThreadInstanceTableMetaImpl meta;

        JvmThreadInstanceTableCache(JvmThreadInstanceTableMetaImpl meta, long validity) {
            this.validity = validity;
            this.meta = meta;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> userData = JvmContextFactory.getUserData();
            return this.getTableDatas(userData);
        }

        @Override
        protected SnmpCachedData updateCachedDatas(Object userData) {
            long[] id = JvmThreadingImpl.getThreadMXBean().getAllThreadIds();
            long time = System.currentTimeMillis();
            SnmpOid[] indexes = new SnmpOid[id.length];
            TreeMap<SnmpOid, Object> table = new TreeMap<SnmpOid, Object>(SnmpCachedData.oidComparator);
            for (int i = 0; i < id.length; ++i) {
                log.debug("", "Making index for thread id [" + id[i] + "]");
                SnmpOid oid = JvmThreadInstanceTableMetaImpl.makeOid(id[i]);
                table.put(oid, oid);
            }
            return new SnmpCachedData(time, table);
        }
    }
}

