/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmThreadContentionMonitoring;
import sun.management.snmp.jvmmib.EnumJvmThreadCpuTimeMonitoring;
import sun.management.snmp.jvmmib.JvmThreadingMBean;
import sun.management.snmp.util.MibLogger;

public class JvmThreadingImpl
implements JvmThreadingMBean {
    static final EnumJvmThreadCpuTimeMonitoring JvmThreadCpuTimeMonitoringUnsupported = new EnumJvmThreadCpuTimeMonitoring("unsupported");
    static final EnumJvmThreadCpuTimeMonitoring JvmThreadCpuTimeMonitoringEnabled = new EnumJvmThreadCpuTimeMonitoring("enabled");
    static final EnumJvmThreadCpuTimeMonitoring JvmThreadCpuTimeMonitoringDisabled = new EnumJvmThreadCpuTimeMonitoring("disabled");
    static final EnumJvmThreadContentionMonitoring JvmThreadContentionMonitoringUnsupported = new EnumJvmThreadContentionMonitoring("unsupported");
    static final EnumJvmThreadContentionMonitoring JvmThreadContentionMonitoringEnabled = new EnumJvmThreadContentionMonitoring("enabled");
    static final EnumJvmThreadContentionMonitoring JvmThreadContentionMonitoringDisabled = new EnumJvmThreadContentionMonitoring("disabled");
    private long jvmThreadPeakCountReset = 0L;
    static final MibLogger log = new MibLogger(JvmThreadingImpl.class);

    public JvmThreadingImpl(SnmpMib myMib) {
        log.debug("JvmThreadingImpl", "Constructor");
    }

    public JvmThreadingImpl(SnmpMib myMib, MBeanServer server) {
        log.debug("JvmThreadingImpl", "Constructor with server");
    }

    static ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    @Override
    public EnumJvmThreadCpuTimeMonitoring getJvmThreadCpuTimeMonitoring() throws SnmpStatusException {
        ThreadMXBean mbean = JvmThreadingImpl.getThreadMXBean();
        if (!mbean.isThreadCpuTimeSupported()) {
            log.debug("getJvmThreadCpuTimeMonitoring", "Unsupported ThreadCpuTimeMonitoring");
            return JvmThreadCpuTimeMonitoringUnsupported;
        }
        try {
            if (mbean.isThreadCpuTimeEnabled()) {
                log.debug("getJvmThreadCpuTimeMonitoring", "Enabled ThreadCpuTimeMonitoring");
                return JvmThreadCpuTimeMonitoringEnabled;
            }
            log.debug("getJvmThreadCpuTimeMonitoring", "Disabled ThreadCpuTimeMonitoring");
            return JvmThreadCpuTimeMonitoringDisabled;
        }
        catch (UnsupportedOperationException e) {
            log.debug("getJvmThreadCpuTimeMonitoring", "Newly unsupported ThreadCpuTimeMonitoring");
            return JvmThreadCpuTimeMonitoringUnsupported;
        }
    }

    @Override
    public void setJvmThreadCpuTimeMonitoring(EnumJvmThreadCpuTimeMonitoring x) throws SnmpStatusException {
        ThreadMXBean mbean = JvmThreadingImpl.getThreadMXBean();
        if (JvmThreadCpuTimeMonitoringEnabled.intValue() == x.intValue()) {
            mbean.setThreadCpuTimeEnabled(true);
        } else {
            mbean.setThreadCpuTimeEnabled(false);
        }
    }

    @Override
    public void checkJvmThreadCpuTimeMonitoring(EnumJvmThreadCpuTimeMonitoring x) throws SnmpStatusException {
        if (JvmThreadCpuTimeMonitoringUnsupported.intValue() == x.intValue()) {
            log.debug("checkJvmThreadCpuTimeMonitoring", "Try to set to illegal unsupported value");
            throw new SnmpStatusException(10);
        }
        if (JvmThreadCpuTimeMonitoringEnabled.intValue() == x.intValue() || JvmThreadCpuTimeMonitoringDisabled.intValue() == x.intValue()) {
            ThreadMXBean mbean = JvmThreadingImpl.getThreadMXBean();
            if (mbean.isThreadCpuTimeSupported()) {
                return;
            }
            log.debug("checkJvmThreadCpuTimeMonitoring", "Unsupported operation, can't set state");
            throw new SnmpStatusException(12);
        }
        log.debug("checkJvmThreadCpuTimeMonitoring", "unknown enum value ");
        throw new SnmpStatusException(10);
    }

    @Override
    public EnumJvmThreadContentionMonitoring getJvmThreadContentionMonitoring() throws SnmpStatusException {
        ThreadMXBean mbean = JvmThreadingImpl.getThreadMXBean();
        if (!mbean.isThreadContentionMonitoringSupported()) {
            log.debug("getJvmThreadContentionMonitoring", "Unsupported ThreadContentionMonitoring");
            return JvmThreadContentionMonitoringUnsupported;
        }
        if (mbean.isThreadContentionMonitoringEnabled()) {
            log.debug("getJvmThreadContentionMonitoring", "Enabled ThreadContentionMonitoring");
            return JvmThreadContentionMonitoringEnabled;
        }
        log.debug("getJvmThreadContentionMonitoring", "Disabled ThreadContentionMonitoring");
        return JvmThreadContentionMonitoringDisabled;
    }

    @Override
    public void setJvmThreadContentionMonitoring(EnumJvmThreadContentionMonitoring x) throws SnmpStatusException {
        ThreadMXBean mbean = JvmThreadingImpl.getThreadMXBean();
        if (JvmThreadContentionMonitoringEnabled.intValue() == x.intValue()) {
            mbean.setThreadContentionMonitoringEnabled(true);
        } else {
            mbean.setThreadContentionMonitoringEnabled(false);
        }
    }

    @Override
    public void checkJvmThreadContentionMonitoring(EnumJvmThreadContentionMonitoring x) throws SnmpStatusException {
        if (JvmThreadContentionMonitoringUnsupported.intValue() == x.intValue()) {
            log.debug("checkJvmThreadContentionMonitoring", "Try to set to illegal unsupported value");
            throw new SnmpStatusException(10);
        }
        if (JvmThreadContentionMonitoringEnabled.intValue() == x.intValue() || JvmThreadContentionMonitoringDisabled.intValue() == x.intValue()) {
            ThreadMXBean mbean = JvmThreadingImpl.getThreadMXBean();
            if (mbean.isThreadContentionMonitoringSupported()) {
                return;
            }
            log.debug("checkJvmThreadContentionMonitoring", "Unsupported operation, can't set state");
            throw new SnmpStatusException(12);
        }
        log.debug("checkJvmThreadContentionMonitoring", "Try to set to unknown value");
        throw new SnmpStatusException(10);
    }

    @Override
    public Long getJvmThreadTotalStartedCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getTotalStartedThreadCount());
    }

    @Override
    public Long getJvmThreadPeakCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getPeakThreadCount());
    }

    @Override
    public Long getJvmThreadDaemonCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getDaemonThreadCount());
    }

    @Override
    public Long getJvmThreadCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getThreadCount());
    }

    @Override
    public synchronized Long getJvmThreadPeakCountReset() throws SnmpStatusException {
        return new Long(this.jvmThreadPeakCountReset);
    }

    @Override
    public synchronized void setJvmThreadPeakCountReset(Long x) throws SnmpStatusException {
        long l = x;
        if (l > this.jvmThreadPeakCountReset) {
            long stamp = System.currentTimeMillis();
            JvmThreadingImpl.getThreadMXBean().resetPeakThreadCount();
            this.jvmThreadPeakCountReset = stamp;
            log.debug("setJvmThreadPeakCountReset", "jvmThreadPeakCountReset=" + stamp);
        }
    }

    @Override
    public void checkJvmThreadPeakCountReset(Long x) throws SnmpStatusException {
    }
}

