/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import java.net.InetAddress;
import java.net.UnknownHostException;
import sun.management.snmp.jvminstr.NotificationTarget;

public class NotificationTargetImpl
implements NotificationTarget {
    private InetAddress address;
    private int port;
    private String community;

    public NotificationTargetImpl(String target) throws IllegalArgumentException, UnknownHostException {
        this.parseTarget(target);
    }

    public NotificationTargetImpl(String address, int port, String community) throws UnknownHostException {
        this(InetAddress.getByName(address), port, community);
    }

    public NotificationTargetImpl(InetAddress address, int port, String community) {
        this.address = address;
        this.port = port;
        this.community = community;
    }

    private void parseTarget(String target) throws IllegalArgumentException, UnknownHostException {
        String addrStr;
        int index;
        if (target == null || target.length() == 0) {
            throw new IllegalArgumentException("Invalid target [" + target + "]");
        }
        if (target.startsWith("[")) {
            index = target.indexOf("]");
            int index2 = target.lastIndexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Host starts with [ but does not end with ]");
            }
            addrStr = target.substring(1, index);
            this.port = Integer.parseInt(target.substring(index + 2, index2));
            if (!NotificationTargetImpl.isNumericIPv6Address(addrStr)) {
                throw new IllegalArgumentException("Address inside [...] must be numeric IPv6 address");
            }
            if (addrStr.startsWith("[")) {
                throw new IllegalArgumentException("More than one [[...]]");
            }
        } else {
            index = target.indexOf(":");
            int index2 = target.lastIndexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Missing port separator \":\"");
            }
            addrStr = target.substring(0, index);
            this.port = Integer.parseInt(target.substring(index + 1, index2));
        }
        this.address = InetAddress.getByName(addrStr);
        index = target.lastIndexOf(":");
        this.community = target.substring(index + 1, target.length());
    }

    private static boolean isNumericIPv6Address(String s) {
        return s.indexOf(58) >= 0;
    }

    @Override
    public String getCommunity() {
        return this.community;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "address : " + this.address + " port : " + this.port + " community : " + this.community;
    }
}

